/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.Type;
import prompto.compiler.IOperand;
import prompto.compiler.IntConstant;
import prompto.compiler.LongConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.java.JavaClassType;
import prompto.java.JavaLiteral;
import prompto.runtime.Context;
import prompto.type.IType;

public class JavaIntegerLiteral
extends JavaLiteral {
    Long value;

    public JavaIntegerLiteral(String text) {
        super(text);
        this.value = Long.valueOf(text);
    }

    @Override
    public Long interpret(Context context) {
        return this.value;
    }

    @Override
    public IType check(Context context) {
        return new JavaClassType((Type)((Object)Long.class));
    }

    public String toString() {
        return this.value.toString();
    }

    long x() {
        return 9876543210L;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method) {
        if (this.value >= 0L && this.value <= 5L) {
            Opcode opcode = Opcode.values()[Opcode.ICONST_0.ordinal() + this.value.intValue()];
            method.addInstruction(opcode, new IOperand[0]);
            return new ResultInfo(Integer.TYPE, new ResultInfo.Flag[0]);
        }
        if (this.value <= Integer.MAX_VALUE && this.value >= Integer.MIN_VALUE) {
            method.addInstruction(Opcode.LDC_W, new IntConstant(this.value.intValue()));
            return new ResultInfo(Integer.TYPE, new ResultInfo.Flag[0]);
        }
        method.addInstruction(Opcode.LDC2_W, new LongConstant(this.value));
        return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
    }
}

