/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import prompto.compiler.CompilerException;
import prompto.compiler.Descriptor;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.PromptoClassLoader;
import prompto.compiler.ResultInfo;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.java.JavaClassType;
import prompto.java.JavaExpression;
import prompto.java.JavaExpressionList;
import prompto.java.JavaSelectorExpression;
import prompto.java.JavaValueConverter;
import prompto.runtime.Context;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.NativeInstance;

public class JavaMethodExpression
extends JavaSelectorExpression {
    String name;
    JavaExpressionList arguments;

    public JavaMethodExpression(String name, JavaExpressionList arguments) {
        this.name = name;
        this.arguments = arguments != null ? arguments : new JavaExpressionList();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.parent.toDialect(writer);
        writer.append('.');
        writer.append(this.name);
        writer.append('(');
        this.arguments.toDialect(writer);
        writer.append(')');
    }

    public String toString() {
        return this.parent.toString() + "." + this.name + "(" + this.arguments.toString() + ")";
    }

    @Override
    public IType check(Context context) {
        try {
            Method method = this.findMethod(context);
            if (method == null) {
                context.getProblemListener().reportUnknownMethod(this, this.name);
                return VoidType.instance();
            }
            return new JavaClassType(method.getGenericReturnType());
        }
        catch (ClassNotFoundException e) {
            throw new SyntaxError(e.getMessage());
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method) {
        try {
            ResultInfo parentType = this.parent.compile(context, method);
            Method toCall = this.findMethod(context, parentType.getType());
            for (int i = 0; i < this.arguments.size(); ++i) {
                JavaExpression arg = (JavaExpression)this.arguments.get(i);
                ResultInfo pushed = arg.compile(context, method);
                Class<?> argType = toCall.getParameterTypes()[i];
                JavaValueConverter.compileAutoboxing(method, pushed, argType);
            }
            Descriptor.Method dm = new Descriptor.Method((Type[])toCall.getParameterTypes(), (Type)toCall.getReturnType());
            MethodConstant operand = new MethodConstant(parentType.getType(), toCall.getName(), dm);
            if (parentType.isStatic()) {
                method.addInstruction(Opcode.INVOKESTATIC, operand);
            } else {
                method.addInstruction(Opcode.INVOKEVIRTUAL, operand);
            }
            return new ResultInfo(toCall.getReturnType(), new ResultInfo.Flag[0]);
        }
        catch (ClassNotFoundException e) {
            throw new CompilerException(e);
        }
    }

    @Override
    public Object interpret(Context context) throws PromptoError {
        Object instance = this.parent.interpret(context);
        if (instance == null) {
            throw new SyntaxError("Could not locate: " + this.parent.toString());
        }
        if (instance instanceof NativeInstance) {
            instance = ((NativeInstance)instance).getInstance();
        }
        try {
            Class<?> klass;
            Method method = this.findMethod(context, instance);
            if (method == null) {
                throw new SyntaxError("Could not locate: " + this.toString());
            }
            Object[] args = this.interpret_arguments(context, method);
            Class<?> clazz = klass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
            if (klass == instance) {
                instance = null;
            }
            try {
                return method.invoke(instance, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    Object[] interpret_arguments(Context context, Method method) throws PromptoError {
        Object[] args = new Object[this.arguments.size()];
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            JavaExpression exp = (JavaExpression)this.arguments.get(i);
            args[i] = this.interpret_argument(context, exp, types[i]);
        }
        return args;
    }

    Object interpret_argument(Context context, JavaExpression expression, Class<?> type) throws PromptoError {
        Object value = expression.interpret(context);
        if (value instanceof IExpression) {
            value = ((IExpression)value).interpret(context);
        }
        if (value instanceof IValue) {
            value = ((IValue)value).convertTo(context, type);
        }
        return value;
    }

    public Method findMethod(Context context) throws ClassNotFoundException {
        IType type = this.parent.check(context);
        if (type == null) {
            context.getProblemListener().reportUnknownIdentifier(this.parent, this.parent.toString());
            return null;
        }
        Type klass = this.findClass(context, type);
        return this.findMethod(context, klass);
    }

    private Type findClass(Context context, IType type) {
        IDeclaration named;
        if (type instanceof CategoryType && (named = context.getRegisteredDeclaration(IDeclaration.class, type.getTypeNameId())) instanceof NativeCategoryDeclaration) {
            return ((NativeCategoryDeclaration)named).getBoundClass(true);
        }
        return type.getJavaType(context);
    }

    public Method findMethod(Context context, Object instance) throws ClassNotFoundException {
        if (instance instanceof NamedType) {
            instance = Class.forName(((NamedType)((Object)instance)).getTypeName(), true, PromptoClassLoader.getInstance());
        }
        if (instance instanceof Class) {
            return this.findMethod(context, instance);
        }
        return this.findMethod(context, instance.getClass());
    }

    public Method findMethod(Context context, Class<?> klass) {
        if (klass == null) {
            return null;
        }
        Method method = this.findExactMethod(context, klass);
        if (method != null) {
            return method;
        }
        return this.findCompatibleMethod(context, klass);
    }

    private Method findExactMethod(Context context, Class<?> klass) {
        Class[] types = new Class[this.arguments.size()];
        int i = 0;
        try {
            for (JavaExpression exp : this.arguments) {
                Class<?> argType = exp.check(context).getJavaType(context);
                if (argType instanceof NamedType) {
                    argType = Class.forName(argType.getTypeName());
                }
                types[i++] = argType;
            }
            return klass.getDeclaredMethod(this.name, types);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return null;
        }
    }

    private Method findCompatibleMethod(Context context, Class<?> klass) {
        Method[] methods;
        for (Method m : methods = klass.getMethods()) {
            if (!this.name.equals(m.getName()) || !this.hasValidPrototype(context, m)) continue;
            return m;
        }
        return null;
    }

    boolean hasValidPrototype(Context context, Method method) {
        Class<?>[] types = method.getParameterTypes();
        if (types.length != this.arguments.size()) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (this.isCompatibleArgument(context, types[i], (JavaExpression)this.arguments.get(i))) continue;
            return false;
        }
        return true;
    }

    boolean isCompatibleArgument(Context context, Class<?> klass, JavaExpression argument) {
        IType argIType = argument.check(context);
        if (argIType instanceof MethodType && klass == IMethodDeclaration.class) {
            return true;
        }
        Class<?> argType = argIType.getJavaType(context);
        if (argType instanceof NamedType) {
            try {
                argType = Class.forName(argType.getTypeName());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return this.isCompatibleArgument(klass, argType);
    }

    boolean isCompatibleArgument(Class<?> required, Class<?> provided) {
        return required == provided || required.isAssignableFrom(provided) || JavaValueConverter.canBeAutoboxed(required, provided);
    }
}

