/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.NativeError;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.java.JavaClassType;
import prompto.java.JavaExpression;
import prompto.java.JavaValueConverter;
import prompto.runtime.Context;
import prompto.runtime.VoidResult;
import prompto.type.IType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.utils.Logger;
import prompto.value.IValue;
import prompto.value.NullValue;

public class JavaStatement {
    static Logger logger = new Logger();
    JavaExpression expression;
    boolean isReturn;
    static Map<Class<?>, Function<MethodInfo, ResultInfo>> resultConsumers = JavaStatement.createResultConsumers();

    public JavaStatement(JavaExpression expression, boolean isReturn) {
        this.expression = expression;
        this.isReturn = isReturn;
    }

    public IType check(Context context, IType returnType) {
        IType type = this.expression.check(context);
        if (type instanceof JavaClassType) {
            type = ((JavaClassType)type).convertJavaClassToPromptoType(context, returnType);
        }
        return this.isReturn ? type : VoidType.instance();
    }

    public IValue interpret(Context context, IType returnType) throws PromptoError {
        Object result = this.interpret(context);
        if (result == null) {
            if (this.isReturn) {
                if (returnType == null) {
                    return VoidResult.instance();
                }
                return NullValue.instance();
            }
            return null;
        }
        IType type = this.expression.check(context);
        if (type instanceof JavaClassType) {
            return ((JavaClassType)type).convertJavaValueToPromptoValue(context, result, returnType);
        }
        return VoidResult.instance();
    }

    private Object interpret(Context context) {
        try {
            return this.expression.interpret(context);
        }
        catch (Throwable t) {
            logger.error(() -> "While interpreting: " + this.toString(), t);
            throw new NativeError("While interpreting: " + this.toString(), t);
        }
    }

    public String toString() {
        return "" + (this.isReturn ? "return " : "") + this.expression.toString() + ";";
    }

    public void toDialect(CodeWriter writer) {
        if (this.isReturn) {
            writer.append("return ");
        }
        this.expression.toDialect(writer);
        writer.append(';');
    }

    private static Map<Class<?>, Function<MethodInfo, ResultInfo>> createResultConsumers() {
        HashMap map = new HashMap();
        return map;
    }

    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = this.expression.compile(context, method);
        if (this.isReturn) {
            if (info.getType() == Void.TYPE) {
                throw new SyntaxError("Cannot return void!");
            }
            info = JavaValueConverter.convertResult(method, info);
            if (!flags.isInline()) {
                method.addInstruction(Opcode.ARETURN, new IOperand[0]);
            }
            return info;
        }
        if (info.getType() != Void.TYPE) {
            Function<MethodInfo, ResultInfo> consumer = resultConsumers.get(info.getType());
            if (consumer != null) {
                info = consumer.apply(method);
            } else {
                method.addInstruction(Opcode.POP, new IOperand[0]);
            }
            return new ResultInfo(Void.TYPE, new ResultInfo.Flag[0]);
        }
        return info;
    }
}

