/*
 * Decompiled with CFR 0.152.
 */
package prompto.java;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import prompto.compiler.CompilerUtils;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;

public abstract class JavaValueConverter {
    static Map<Class<?>, Function<MethodInfo, ResultInfo>> resultConverters = JavaValueConverter.createResultConverters();

    private static Map<Class<?>, Function<MethodInfo, ResultInfo>> createResultConverters() {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, CompilerUtils::booleanToBoolean);
        map.put(Byte.TYPE, CompilerUtils::intTolong);
        map.put(Byte.class, CompilerUtils::ByteToLong);
        map.put(Short.TYPE, CompilerUtils::intToLong);
        map.put(Short.TYPE, CompilerUtils::ShortToLong);
        map.put(Integer.TYPE, CompilerUtils::intToLong);
        map.put(Integer.class, CompilerUtils::IntegerToLong);
        map.put(Long.TYPE, CompilerUtils::longToLong);
        map.put(Float.TYPE, CompilerUtils::floatToDouble);
        map.put(Float.class, CompilerUtils::FloatToDouble);
        map.put(Double.TYPE, CompilerUtils::doubleToDouble);
        map.put(Character.TYPE, CompilerUtils::charToCharacter);
        return map;
    }

    public static ResultInfo convertResult(MethodInfo method, ResultInfo info) {
        Function<MethodInfo, ResultInfo> converter = resultConverters.get(info.getType());
        if (converter != null) {
            return converter.apply(method);
        }
        return info;
    }

    public static boolean canBeAutoboxed(Class<?> from, Class<?> to) {
        return JavaValueConverter.canBeAutoboxed(from, to, true);
    }

    public static boolean canBeAutoboxed(Class<?> from, Class<?> to, boolean tryReverse) {
        return from == Character.TYPE && to == Character.class || from == Boolean.TYPE && to == Boolean.class || from == Long.TYPE && to == Long.class || from == Double.TYPE && to == Double.class || tryReverse && JavaValueConverter.canBeAutoboxed(to, from, false);
    }

    public static ResultInfo compileAutoboxing(MethodInfo method, ResultInfo from, Class<?> to) {
        if (from.getType() == to) {
            return from;
        }
        if (from.getType() == Character.TYPE && to == Character.class) {
            return CompilerUtils.charToCharacter(method);
        }
        if (from.getType() == Character.class && to == Character.TYPE) {
            return CompilerUtils.CharacterTochar(method);
        }
        if (from.getType() == Boolean.TYPE && to == Boolean.class) {
            return CompilerUtils.booleanToBoolean(method);
        }
        if (from.getType() == Boolean.class && to == Boolean.TYPE) {
            return CompilerUtils.BooleanToboolean(method);
        }
        if (from.getType() == Long.TYPE && to == Long.class) {
            return CompilerUtils.longToLong(method);
        }
        if (from.getType() == Long.class && to == Long.TYPE) {
            return CompilerUtils.LongTolong(method);
        }
        if (from.getType() == Double.TYPE && to == Double.class) {
            return CompilerUtils.doubleToDouble(method);
        }
        if (from.getType() == Double.class && to == Double.TYPE) {
            return CompilerUtils.DoubleTodouble(method);
        }
        return from;
    }
}

