/*
 * Decompiled with CFR 0.152.
 */
package prompto.javascript;

import prompto.javascript.JavaScriptExpression;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;

public class JavaScriptIdentifierExpression
implements JavaScriptExpression {
    JavaScriptIdentifierExpression parent;
    String identifier;

    public static JavaScriptIdentifierExpression parse(String ids) {
        String[] parts = ids.split("\\.");
        JavaScriptIdentifierExpression result = null;
        for (String part : parts) {
            result = new JavaScriptIdentifierExpression(result, part);
        }
        return result;
    }

    public JavaScriptIdentifierExpression(String identifier) {
        this.identifier = identifier;
    }

    public JavaScriptIdentifierExpression(JavaScriptIdentifierExpression parent, String identifier) {
        this.parent = parent;
        this.identifier = identifier;
    }

    public JavaScriptIdentifierExpression getParent() {
        return this.parent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        if (this.parent == null) {
            return this.identifier;
        }
        return this.parent.toString() + "." + this.identifier;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.parent != null) {
            this.parent.toDialect(writer);
            writer.append('.');
        }
        writer.append(this.identifier);
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (this.parent != null) {
            this.parent.declare(transpiler);
        }
        if ("$context".equals(this.identifier)) {
            transpiler.require("Context");
        }
    }

    @Override
    public void transpile(Transpiler transpiler) {
        if (this.parent != null) {
            this.parent.transpile(transpiler);
            transpiler.append('.');
        }
        transpiler.append(this.identifier);
    }

    @Override
    public void transpileRoot(Transpiler transpiler) {
        if (this.parent != null) {
            this.parent.transpileRoot(transpiler);
        } else {
            transpiler.append(this.identifier);
        }
    }
}

