/*
 * Decompiled with CFR 0.152.
 */
package prompto.javascript;

import prompto.declaration.IMethodDeclaration;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.Identifier;
import prompto.javascript.JavaScriptExpression;
import prompto.javascript.JavaScriptExpressionList;
import prompto.javascript.JavaScriptIdentifierExpression;
import prompto.javascript.JavaScriptSelectorExpression;
import prompto.param.IParameter;
import prompto.statement.MethodCall;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;

public class JavaScriptMethodExpression
extends JavaScriptSelectorExpression {
    String name;
    JavaScriptExpressionList arguments = new JavaScriptExpressionList();

    public JavaScriptMethodExpression(String name) {
        this.name = name;
    }

    public void setArguments(JavaScriptExpressionList arguments) {
        this.arguments = arguments != null ? arguments : new JavaScriptExpressionList();
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent.toString() + "." + this.name + "(" + this.arguments.toString() + ")";
        }
        return this.name + "(" + this.arguments.toString() + ")";
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.parent != null) {
            this.parent.toDialect(writer);
            writer.append('.');
        }
        writer.append(this.name);
        writer.append('(');
        if (this.arguments != null) {
            this.arguments.toDialect(writer);
        }
        writer.append(')');
    }

    @Override
    public void transpile(Transpiler transpiler) {
        if (this.parent != null) {
            this.parent.transpile(transpiler);
            transpiler.append('.');
        }
        transpiler.append(this.name).append('(');
        this.transpileArguments(transpiler);
        transpiler.append(')');
    }

    private void transpileArguments(Transpiler transpiler) {
        if (this.arguments != null) {
            this.arguments.transpile(transpiler);
        }
    }

    @Override
    public void transpileRoot(Transpiler transpiler) {
        if (this.parent != null) {
            this.parent.transpileRoot(transpiler);
        } else {
            transpiler.append(this.name);
        }
    }

    @Override
    public void transpileInlineMethodCall(Transpiler transpiler, IMethodDeclaration declaration, MethodCall methodCall) {
        if (this.parent != null) {
            this.parent.transpileInlineMethodCall(transpiler, declaration, methodCall);
            transpiler.append('.');
        }
        transpiler.append(this.name).append("(");
        this.transpileInlineArguments(transpiler, declaration, methodCall);
        transpiler.append(")");
    }

    private void transpileInlineArguments(Transpiler transpiler, IMethodDeclaration declaration, MethodCall methodCall) {
        if (this.arguments != null && this.arguments.size() > 0) {
            this.arguments.forEach(exp -> {
                this.transpileInlineArgument(transpiler, (JavaScriptExpression)exp, declaration, methodCall);
                transpiler.append(", ");
            });
            transpiler.trimLast(", ".length());
        }
    }

    private void transpileInlineArgument(Transpiler transpiler, JavaScriptExpression exp, IMethodDeclaration declaration, MethodCall methodCall) {
        if (exp instanceof JavaScriptIdentifierExpression && ((JavaScriptIdentifierExpression)exp).getParent() == null) {
            Identifier id = new Identifier(exp.toString());
            Argument argument = methodCall.getArguments().find(id);
            if (argument == null && declaration.getParameters().size() == 1) {
                argument = (Argument)methodCall.getArguments().get(0);
            }
            if (argument == null) {
                exp.transpile(transpiler);
            } else {
                IParameter parameter = argument.getParameter();
                if (parameter == null && declaration.getParameters().size() == 1) {
                    parameter = (IParameter)declaration.getParameters().get(0);
                }
                IExpression expression = argument.getExpression();
                parameter.transpileCall(transpiler, expression);
            }
        } else {
            exp.transpile(transpiler);
        }
    }
}

