/*
 * Decompiled with CFR 0.152.
 */
package prompto.javascript;

import java.util.Collection;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;

public class JavaScriptModule {
    Collection<String> identifiers;

    public JavaScriptModule(Collection<String> identifiers) {
        this.identifiers = identifiers;
    }

    public void toDialect(CodeWriter writer) {
        writer.append(" from module: ");
        for (String id : this.identifiers) {
            if ("js".equals(id)) {
                writer.trimLast(1);
                writer.append('.');
            }
            writer.append(id);
            writer.append('/');
        }
        writer.trimLast(1);
    }

    public void declare(Transpiler transpiler) {
        if (this.isPromptoIntrinsic()) {
            String[] ids = this.identifiers.toArray(new String[this.identifiers.size()]);
            transpiler.require(ids[2]);
        }
    }

    public void transpile(Transpiler transpiler) {
        for (String id : this.identifiers) {
            if ("js".equals(id)) {
                transpiler.trimLast(1);
                transpiler.append('.');
            }
            transpiler.append(id);
            transpiler.append('/');
        }
        transpiler.trimLast(1);
    }

    public boolean isPromptoIntrinsic() {
        String[] ids = this.identifiers.toArray(new String[this.identifiers.size()]);
        return ids.length >= 2 && "prompto".equals(ids[0]) && "intrinsic".equals(ids[1]);
    }
}

