/*
 * Decompiled with CFR 0.152.
 */
package prompto.javascript;

import prompto.grammar.NativeCategoryBinding;
import prompto.javascript.JavaScriptModule;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;

public class JavaScriptNativeCategoryBinding
extends NativeCategoryBinding {
    String identifier;
    JavaScriptModule module;

    public JavaScriptNativeCategoryBinding(String identifier, JavaScriptModule module) {
        this.identifier = identifier;
        this.module = module;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("JavaScript: ");
        writer.append(this.identifier);
        if (this.module != null) {
            this.module.toDialect(writer);
        }
    }

    public void transpile(Transpiler transpiler) {
        if (this.module != null) {
            if (transpiler.getEngine().isTestEngine()) {
                transpiler.append("var ").append(this.identifier).append(" = require('");
                this.module.transpile(transpiler);
                transpiler.append("').").append(this.identifier).append(";").newLine();
            } else {
                transpiler.append("var ").append(this.identifier).append(" = require('/");
                this.module.transpile(transpiler);
                transpiler.append("', null, null, function(m) { return {id: m, uri: m}; }).").append(this.identifier).append(";").newLine();
            }
        }
    }

    public String getBoundName() {
        return this.identifier;
    }

    public void transpileWidget(Transpiler transpiler, String name) {
        transpiler.append("var ").append(name).append(" = ");
        if (this.module != null) {
            this.module.transpile(transpiler);
            transpiler.append(".");
        }
        transpiler.append(this.identifier).append(";").newLine();
    }
}

