/*
 * Decompiled with CFR 0.152.
 */
package prompto.jsx;

import java.util.List;
import prompto.grammar.Identifier;
import prompto.jsx.IJsxExpression;
import prompto.jsx.JsxClosing;
import prompto.jsx.JsxElementBase;
import prompto.jsx.JsxProperty;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.utils.CodeWriter;

public class JsxElement
extends JsxElementBase {
    String nameSuite;
    String openingSuite;
    List<IJsxExpression> children;
    JsxClosing closing;

    public JsxElement(Identifier name, String nameSuite, List<JsxProperty> attributes, String openingSuite) {
        super(name, attributes);
        this.nameSuite = nameSuite;
        this.openingSuite = openingSuite;
    }

    public void setChildren(List<IJsxExpression> children) {
        this.children = children;
    }

    public void setClosing(JsxClosing closing) {
        this.closing = closing;
    }

    @Override
    protected void checkChildren(Context context) {
        if (this.children != null) {
            this.children.forEach(child -> child.check(context));
        }
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("<").append(this.id);
        if (this.nameSuite != null) {
            writer.appendRaw(this.nameSuite);
        } else if (!this.properties.isEmpty()) {
            writer.append(" ");
        }
        this.properties.forEach(attr -> attr.toDialect(writer));
        writer.append(">");
        if (this.openingSuite != null) {
            writer.appendRaw(this.openingSuite);
        }
        if (this.children != null) {
            this.children.forEach(child -> child.toDialect(writer));
        }
        this.closing.toDialect(writer);
    }

    @Override
    public void declareChildren(Transpiler transpiler) {
        if (this.children != null) {
            this.children.forEach(child -> child.declare(transpiler));
        }
    }

    @Override
    public void transpileChildren(Transpiler transpiler) {
        if (this.children != null) {
            this.children.forEach(child -> {
                transpiler.append(", ");
                child.transpile(transpiler);
            });
        }
    }
}

