/*
 * Decompiled with CFR 0.152.
 */
package prompto.jsx;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.grammar.Identifier;
import prompto.jsx.IJsxExpression;
import prompto.jsx.JsxProperty;
import prompto.literal.DictEntry;
import prompto.literal.DocEntryList;
import prompto.literal.TypeLiteral;
import prompto.parser.ISection;
import prompto.parser.OCleverParser;
import prompto.parser.Section;
import prompto.processor.WidgetPropertiesProcessor;
import prompto.property.Property;
import prompto.property.PropertyMap;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.JsxType;

public abstract class JsxElementBase
extends Section
implements IJsxExpression {
    Identifier id;
    List<JsxProperty> properties;
    static final String HTML_PROPERTY_TYPES = "{\nabbr: { type: Text, help: \"Alternative label to use for the header cell when referencing the cell in other contexts\"},\naccept: { type: any, help: \"Hint for expected file type in file upload controls\"},\n\"accept-charset\": { type: any, help: \"Character encodings to use for form submission\"},\naccesskey: { type: any, help: \"Keyboard shortcut to activate or focus element\"},\naction: { type: Text, help: \"URL to use for form submission\"},\nallow: { type: Text, help: \"Feature policy to be applied to the iframe's contents\"},\nallowfullscreen: { type: Boolean, help: \"Whether to allow the iframe's contents to use requestFullscreen()\"},\nallowpaymentrequest: { type: Boolean, help: \"Whether the iframe's contents are allowed to use the PaymentRequest interface to make payment requests\"},\nalt: { type: Text, help: \"Replacement text for use when images are not available\"},\nas: { type: any, help: \"Potential destination for a preload request (for rel='preload' and rel='modulepreload')\"},\nasync: { type: Boolean, help: \"Execute script when available, without blocking while fetching\"},\nautocapitalize: { values: <null, \"characters\", \"sentences\", \"words\", \"none\", \"off\", \"on\">, help: \"Recommended autocapitalization behavior (for supported input methods)\"},\nautocomplete: { values: <null, \"off\", \"on\">, help: \"Default setting for autofill feature for controls in the form\"},\nautofocus: { type: Boolean, help: \"Automatically focus the element when the page is loaded\"},\nautoplay: { type: Boolean, help: \"Hint that the media resource can be started automatically when the page is loaded\"},\ncharset: { type: Text, help: \"Character encoding declaration\"},\nchecked: { type: Boolean, help: \"Whether the control is checked\"},\ncite: { type: Text, help: \"Link to the source of the quotation or more information about the edit\"},\nclass: { type: Text, help: \"Classes to which the element belongs\"},\ncolor: { type: Text, help: \"Color to use when customizing a site's icon (for rel='mask-icon')\"},\ncols: { type: Integer, help: \"Maximum number of characters per line\"},\ncolspan: { type: Integer, help: \"Number of columns that the cell is to span\"},\ncontent: { type: Text, help: \"Value of the element\"},\ncontenteditable: { type: Boolean, help: \"Whether the element is editable\"},\ncontrols: { type: Boolean, help: \"Show user agent controls\"},\ncoords: { type: Text, help: \"Coordinates for the shape to be created in an image map\"},\ncrossorigin: { values: <null, \"anonymous\", \"use-credentials\">, help: \"How the element handles crossorigin requests\"},\ndata: { type: Text, help: \"Address of the resource\"},\ndatetime: { types: <Date, null, DateTime>, help: \"Date and (optionally) time of the change\"},\ndecoding: { values: <null, \"async\", \"auto\", \"sync\">, help: \"Decoding hint to use when processing this image for presentation\"},\ndefault: { type: Boolean, help: \"Enable the track if no other text track is more suitable\"},\ndefer: { type: Boolean, help: \"Defer script execution\"},\ndir: { values: <null, \"auto\", \"ltr\", \"rtl\">, help: \"The text directionality of the element\"},\ndirname: { type: Text, help: \"Name of form control to use for sending the element's directionality in form submission\"},\ndisabled: { type: Boolean, help: \"Whether the form control is disabled\"},\ndownload: { type: any, help: \"Whether to download the resource instead of navigating to it, and its file name if so\"},\ndraggable: { type: Boolean, help: \"Whether the element is draggable\"},\nenctype: { values: <null, \"multipart/form-data\", \"application/x-www-form-urlencoded\", \"text/plain\">, help: \"Entry list encoding type to use for form submission\"},\nenterkeyhint: { values: <\"next\", null, \"search\", \"previous\", \"go\", \"enter\", \"done\", \"send\">, help: \"Hint for selecting an enter key action\"},\nfor: { type: any, help: \"Associate the label with form control\"},\nform: { type: any, help: \"Associates the element with a form element\"},\nformaction: { type: Text, help: \"URL to use for form submission\"},\nformenctype: { values: <null, \"multipart/form-data\", \"application/x-www-form-urlencoded\", \"text/plain\">, help: \"Entry list encoding type to use for form submission\"},\nformmethod: { values: <null, \"dialog\", \"POST\", \"GET\">, help: \"Variant to use for form submission\"},\nformnovalidate: { type: Boolean, help: \"Bypass form control validation for form submission\"},\nformtarget: { type: Text, help: \"Browsing context for form submission\"},\nheaders: { type: any, help: \"The header cells for this cell\"},\nheight: { type: Integer, help: \"Vertical dimension\"},\nhidden: { type: Boolean, help: \"Whether the element is relevant\"},\nhigh: { type: Decimal, help: \"Low limit of high range\"},\nhref: { type: Text, help: \"Address of the hyperlink\"},\nhreflang: { type: any, help: \"Language of the linked resource\"},\n\"http-equiv\": { values: <\"default-style\", null, \"x-ua-compatible\", \"content-security-policy\", \"refresh\", \"content-type\">, help: \"Pragma directive\"},\nid: { type: Text, help: \"The element's ID\"},\nimagesizes: { type: Text, help: \"Image sizes for different page layouts\"},\nimagesrcset: { type: Text, help: \"Images to use in different situations (e.g., high-resolution displays, small monitors, etc.)\"},\ninputmode: { values: <null, \"search\", \"numeric\", \"tel\", \"none\", \"text\", \"decimal\", \"email\", \"url\">, help: \"Hint for selecting an input modality\"},\nintegrity: { type: Text, help: \"Integrity metadata used in Subresource Integrity checks [SRI]\"},\nis: { type: any, help: \"Creates a customized built-in element\"},\nismap: { type: Boolean, help: \"Whether the image is a server-side image map\"},\nitemid: { type: Text, help: \"Global identifier for a microdata item\"},\nitemprop: { type: any, help: \"Property names of a microdata item\"},\nitemref: { type: any, help: \"Referenced elements\"},\nitemscope: { type: Boolean, help: \"Introduces a microdata item\"},\nitemtype: { type: any, help: \"Item types of a microdata item\"},\nkind: { values: <null, \"subtitles\", \"metadata\", \"chapters\", \"descriptions\", \"captions\">, help: \"The type of text track\"},\nlabel: { type: Text, help: \"User-visible label\"},\nlang: { type: any, help: \"Language of the element\"},\nlist: { type: any, help: \"List of autocomplete options\"},\nloop: { type: Boolean, help: \"Whether to loop the media resource\"},\nlow: { type: Decimal, help: \"High limit of low range\"},\nmanifest: { type: Text, help: \"Application cache manifest\"},\nmax: { type: any, help: \"Maximum value\"},\nmaxlength: { type: Integer, help: \"Maximum length of value\"},\nmedia: { type: Text, help: \"Applicable media\"},\nmethod: { values: <null, \"dialog\", \"POST\", \"GET\">, help: \"Variant to use for form submission\"},\nmin: { type: any, help: \"Minimum value\"},\nminlength: { type: Integer, help: \"Minimum length of value\"},\nmultiple: { type: Boolean, help: \"Whether to allow multiple values\"},\nmuted: { type: Boolean, help: \"Whether to mute the media resource by default\"},\nname: { type: Text, help: \"Name of the element to use for form submission and in the form.elements API\"},\nnomodule: { type: Boolean, help: \"Prevents execution in user agents that support module scripts\"},\nnonce: { type: Text, help: \"Cryptographic nonce used in Content Security Policy checks [CSP]\"},\nnovalidate: { type: Boolean, help: \"Bypass form control validation for form submission\"},\nopen: { type: Boolean, help: \"Whether the details are visible\"},\noptimum: { type: Decimal, help: \"Optimum value in gauge\"},\npattern: { type: Text, help: \"Pattern to be matched by the form control's value\"},\nping: { type: any, help: \"URLs to ping\"},\nplaceholder: { type: Text, help: \"User-visible label to be placed within the form control\"},\nplaysinline: { type: Boolean, help: \"Encourage the user agent to display video content within the element's playback area\"},\nposter: { type: Text, help: \"Poster frame to show prior to video playback\"},\npreload: { values: <null, \"metadata\", \"auto\", \"none\">, help: \"Hints how much buffering the media resource will likely need\"},\nreadonly: { type: Boolean, help: \"Whether to allow the value to be edited by the user\"},\nreferrerpolicy: { values: <\"strict-origin-when-cross-origin\", null, \"strict-origin\", \"origin\", \"unsafe-url\", \"no-referrer\", \"same-origin\", \"no-referrer-when-downgrade\", \"origin-when-cross-origin\">, help: \"Referrer policy for fetches initiated by the element\"},\nrel: { type: Text, help: \"Relationship between the location in the document containing the hyperlink and the destination resource\"},\nrequired: { type: Boolean, help: \"Whether the control is required for form submission\"},\nreversed: { type: Boolean, help: \"Number the list backwards\"},\nrows: { type: Integer, help: \"Number of lines to show\"},\nrowspan: { type: Integer, help: \"Number of rows that the cell is to span\"},\nsandbox: { type: any, help: \"Security rules for nested content\"},\nscope: { values: <null, \"col\", \"row\", \"colgroup\", \"rowgroup\">, help: \"Specifies which cells the header cell applies to\"},\nselected: { type: Boolean, help: \"Whether the option is selected by default\"},\nshape: { values: <null, \"rect\", \"default\", \"poly\", \"circle\">, help: \"The kind of shape to be created in an image map\"},\nsize: { type: Integer, help: \"Size of the control\"},\nsizes: { type: any, help: \"Sizes of the icons (for rel='icon')\"},\nslot: { type: Text, help: \"The element's desired slot\"},\nspan: { type: Integer, help: \"Number of columns spanned by the element\"},\nspellcheck: { type: Boolean, help: \"Whether the element is to have its spelling and grammar checked\"},\nsrc: { type: Text, help: \"Address of the resource\"},\nsrcdoc: { type: Text, help: \"A document to render in the iframe\"},\nsrclang: { type: any, help: \"Language of the text track\"},\nsrcset: { type: Text, help: \"Images to use in different situations (e.g., high-resolution displays, small monitors, etc.)\"},\nstart: { type: Integer, help: \"Starting value of the list\"},\nstep: { type: any, help: \"Granularity to be matched by the form control's value\"},\nstyle: { type: any, help: \"Presentational and formatting instructions\"},\ntabindex: { type: Integer, help: \"Whether the element is focusable, and the relative order of the element for the purposes of sequential focus navigation\"},\ntarget: { type: Text, help: \"Browsing context for hyperlink navigation\"},\ntitle: { type: Text, help: \"Advisory information for the element\"},\ntranslate: { values: <null, \"no\", \"yes\">, help: \"Whether the element is to be translated when the page is localized\"},\ntype: { type: Text, help: \"Hint for the type of the referenced resource\"},\nusemap: { type: Text, help: \"Name of image map to use\"},\nvalue: { type: Text, help: \"Value to be used for form submission\"},\nwidth: { type: Integer, help: \"Horizontal dimension\"},\nwrap: { values: <null, \"hard\", \"soft\">, help: \"How the value of the form control is to be wrapped for form submission\"},\nonClick: ClickEventCallback,\nonContextMenu: ClickEventCallback,\nonChange: InputChangedCallback,\nkey: Any\n}";
    static ThreadLocal<PropertyMap> HTML_PROPERTIES_MAP = new ThreadLocal();
    static ThreadLocal<Boolean> HTML_TEST_MODE = ThreadLocal.withInitial(() -> false);

    public JsxElementBase(Identifier id, List<JsxProperty> attributes) {
        this.id = id;
        this.properties = attributes;
    }

    public String toString() {
        return "<" + this.id.toString() + ">...</" + this.id.toString() + ">";
    }

    @Override
    public IType check(Context context) {
        if (Character.isUpperCase(this.id.toString().charAt(0))) {
            PropertyMap propertyMap = this.getPropertyMap(context);
            this.checkWidgetProperties(context, propertyMap);
        } else {
            this.checkHtmlProperties(context);
        }
        this.checkChildren(context);
        return JsxType.instance();
    }

    protected void checkChildren(Context context) {
    }

    private PropertyMap getPropertyMap(Context context) {
        if (this.isHtmlTag()) {
            return this.getHtmlPropertyTypes(context, this.id.toString());
        }
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, this.id);
        if (decl == null) {
            context.getProblemListener().reportUnknownIdentifier(this.id, this.id.toString());
            return null;
        }
        if (decl instanceof CategoryDeclaration && ((CategoryDeclaration)decl).isAWidget(context)) {
            return ((CategoryDeclaration)decl).asWidget().getProperties();
        }
        return null;
    }

    private boolean isHtmlTag() {
        return Character.isLowerCase(this.id.toString().charAt(0));
    }

    private void checkWidgetProperties(Context context, PropertyMap propertyMap) {
        HashSet actualNames = new HashSet();
        if (this.properties != null) {
            this.properties.forEach(prop -> {
                if (actualNames.contains(prop.getName())) {
                    context.getProblemListener().reportDuplicateProperty((ISection)prop, prop.getName());
                } else {
                    actualNames.add(prop.getName());
                }
                if (propertyMap != null) {
                    Property declared = (Property)propertyMap.get(prop.getName());
                    if (declared == null) {
                        declared = (Property)this.getHtmlPropertyTypes(context, null).get(prop.getName());
                    }
                    if (declared == null) {
                        declared = (Property)this.getHtmlPropertyTypes(context, null).get(prop.getName().toLowerCase());
                    }
                    if (declared == null) {
                        context.getProblemListener().reportUnknownProperty((ISection)prop, prop.getName());
                    } else {
                        declared.validate(context, (JsxProperty)prop);
                    }
                } else {
                    prop.check(context);
                }
            });
        }
        if (propertyMap != null) {
            propertyMap.entrySet().stream().filter(e -> ((Property)e.getValue()).isRequired()).forEach(e -> {
                if (this.properties == null || !actualNames.contains(e.getKey())) {
                    context.getProblemListener().reportMissingProperty(this, (String)e.getKey());
                }
            });
        }
    }

    private void checkHtmlProperties(Context context) {
        PropertyMap propertyMap = this.getHtmlPropertyTypes(context, this.id.toString());
        HashSet actualNames = new HashSet();
        if (this.properties != null) {
            this.properties.forEach(prop -> {
                if (actualNames.contains(prop.getName())) {
                    context.getProblemListener().reportDuplicateProperty((ISection)prop, prop.getName());
                } else {
                    actualNames.add(prop.getName());
                }
                prop.check(context);
                Property declared = (Property)propertyMap.get(prop.getName());
                if (declared == null) {
                    declared = (Property)propertyMap.get(prop.getName().toLowerCase());
                }
                if (declared == null) {
                    context.getProblemListener().reportUnknownProperty((ISection)prop, prop.getName());
                } else {
                    declared.validate(context, (JsxProperty)prop);
                }
            });
        }
        if (propertyMap != null) {
            propertyMap.entrySet().stream().filter(e -> ((Property)e.getValue()).isRequired()).forEach(e -> {
                if (this.properties == null || !actualNames.contains(e.getKey())) {
                    context.getProblemListener().reportMissingProperty(this, (String)e.getKey());
                }
            });
        }
    }

    public static void setTestMode(boolean set) {
        HTML_TEST_MODE.set(set);
        if (set) {
            HTML_PROPERTIES_MAP.set(null);
        }
    }

    private PropertyMap getHtmlPropertyTypes(Context context, String tagName) {
        if (HTML_PROPERTIES_MAP.get() == null) {
            OCleverParser parser = new OCleverParser(HTML_PROPERTY_TYPES);
            DocEntryList types = parser.parse_document_literal().getEntries();
            if (HTML_TEST_MODE.get().booleanValue()) {
                TypeLiteral any = new TypeLiteral(AnyType.instance());
                types = new DocEntryList(types.stream().map(e -> new DictEntry(e.getKey(), any)).collect(Collectors.toList()));
            }
            HTML_PROPERTIES_MAP.set(new WidgetPropertiesProcessor().loadProperties(null, context, types));
        }
        return HTML_PROPERTIES_MAP.get();
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (!this.isHtmlTag()) {
            IDeclaration decl = transpiler.getContext().getRegisteredDeclaration(IDeclaration.class, this.id);
            if (decl == null) {
                transpiler.getContext().getProblemListener().reportUnknownIdentifier(this.id, this.id.toString());
            } else {
                decl.declare(transpiler.newLocalTranspiler());
            }
        }
        if (this.properties != null) {
            PropertyMap propertyMap = this.getPropertyMap(transpiler.getContext());
            PropertyMap htmlPropertyMap = this.isHtmlTag() ? null : this.getHtmlPropertyTypes(transpiler.getContext(), this.id.toString());
            this.properties.forEach(jsxprop -> {
                Property prop;
                Property property = prop = propertyMap == null ? null : (Property)propertyMap.get(jsxprop.getName());
                if (prop == null) {
                    Property property2 = prop = htmlPropertyMap == null ? null : (Property)htmlPropertyMap.get(jsxprop.getName());
                }
                if (prop == null) {
                    prop = htmlPropertyMap == null ? null : (Property)htmlPropertyMap.get(jsxprop.getName().toLowerCase());
                }
                jsxprop.declare(transpiler, prop);
            });
        }
        this.declareChildren(transpiler);
    }

    public void declareChildren(Transpiler transpiler) {
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("React.createElement(");
        if (!this.isHtmlTag()) {
            transpiler.append(this.id.toString());
        } else {
            transpiler.append('\"').append(this.id.toString()).append('\"');
        }
        transpiler.append(", ");
        if (this.properties == null || this.properties.isEmpty()) {
            transpiler.append("null");
        } else {
            PropertyMap propertyMap = this.getPropertyMap(transpiler.getContext());
            PropertyMap htmlPropertyMap = this.isHtmlTag() ? null : this.getHtmlPropertyTypes(transpiler.getContext(), this.id.toString());
            transpiler.append("{");
            this.properties.forEach(jsxprop -> {
                Property prop;
                Property property = prop = propertyMap == null ? null : (Property)propertyMap.get(jsxprop.getName());
                if (prop == null) {
                    Property property2 = prop = htmlPropertyMap == null ? null : (Property)htmlPropertyMap.get(jsxprop.getName());
                }
                if (prop == null) {
                    prop = htmlPropertyMap == null ? null : (Property)htmlPropertyMap.get(jsxprop.getName().toLowerCase());
                }
                jsxprop.transpile(transpiler, prop);
                transpiler.append(", ");
            });
            transpiler.trimLast(2).append("}");
        }
        this.transpileChildren(transpiler);
        transpiler.append(")");
        return false;
    }

    public void transpileChildren(Transpiler transpiler) {
    }
}

