/*
 * Decompiled with CFR 0.152.
 */
package prompto.jsx;

import java.util.List;
import prompto.jsx.IJsxExpression;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.JsxType;
import prompto.utils.CodeWriter;

public class JsxFragment
extends Section
implements IJsxExpression {
    String openingSuite;
    List<IJsxExpression> children;

    public JsxFragment(String openingSuite) {
        this.openingSuite = openingSuite;
    }

    public void setChildren(List<IJsxExpression> children) {
        this.children = children;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("<>");
        if (this.openingSuite != null) {
            writer.appendRaw(this.openingSuite);
        }
        if (this.children != null) {
            this.children.forEach(child -> child.toDialect(writer));
        }
        writer.append("</>");
    }

    @Override
    public IType check(Context context) {
        if (this.children != null) {
            this.children.forEach(child -> child.check(context));
        }
        return JsxType.instance();
    }

    @Override
    public void declare(Transpiler transpiler) {
        if (this.children != null) {
            this.children.forEach(child -> child.declare(transpiler));
        }
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        if (this.children != null && !this.children.isEmpty()) {
            transpiler.append("React.createElement(React.Fragment, null");
            this.children.forEach(child -> {
                transpiler.append(", ");
                child.transpile(transpiler);
            });
            transpiler.append(")");
        }
        return false;
    }
}

