/*
 * Decompiled with CFR 0.152.
 */
package prompto.jsx;

import java.util.HashMap;
import java.util.Map;
import prompto.grammar.Identifier;
import prompto.jsx.IJsxValue;
import prompto.parser.Section;
import prompto.property.Property;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;

public class JsxProperty
extends Section {
    Identifier id;
    IJsxValue value;
    String suite;
    private static Map<String, String> REACT_REPLACEMENTS = JsxProperty.getReactReplacements();

    public JsxProperty(Identifier id, IJsxValue value, String suite) {
        this.id = id;
        this.value = value;
        this.suite = suite != null && !suite.isEmpty() ? suite : null;
    }

    public Identifier getId() {
        return this.id;
    }

    public String getName() {
        return this.id.toString();
    }

    public IJsxValue getValue() {
        return this.value;
    }

    public IType check(Context context) {
        if (this.value != null) {
            return this.value.check(context);
        }
        return BooleanType.instance();
    }

    public IType checkProto(Context context, MethodType type) {
        if (this.value != null) {
            return this.value.checkProto(context, type);
        }
        return VoidType.instance();
    }

    public void toDialect(CodeWriter writer) {
        writer.append(this.id.toString());
        if (this.value != null) {
            writer.append("=");
            this.value.toDialect(writer);
        }
        if (this.suite != null) {
            writer.appendRaw(this.suite);
        } else {
            writer.append(" ");
        }
    }

    public void declare(Transpiler transpiler, Property property) {
        if (this.value != null) {
            this.value.declare(transpiler, property);
        }
    }

    private static Map<String, String> getReactReplacements() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("class", "className");
        result.put("for", "htmlFor");
        result.put("readonly", "readOnly");
        return result;
    }

    public void transpile(Transpiler transpiler, Property property) {
        String name = this.id.toString();
        if ((name = REACT_REPLACEMENTS.getOrDefault(name, name)).contains("-")) {
            name = "\"" + name + "\"";
        }
        transpiler.append(name);
        transpiler.append(": ");
        if (this.value != null) {
            this.value.transpile(transpiler, property);
        } else {
            transpiler.append("true");
        }
    }
}

