/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import prompto.compiler.ByteOperand;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.value.BooleanValue;

public class BooleanLiteral
extends Literal<BooleanValue> {
    public BooleanLiteral(String text) {
        super(text, BooleanValue.parse(text));
    }

    @Override
    public IType check(Context context) {
        return BooleanType.instance();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        method.addInstruction(Opcode.BIPUSH, new ByteOperand(((BooleanValue)this.value).getValue() ? (byte)1 : 0));
        if (flags.toPrimitive()) {
            return new ResultInfo(Boolean.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.booleanToBoolean(method);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append((String)this.text.get());
        return false;
    }
}

