/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import prompto.compiler.ByteOperand;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IntConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.ShortOperand;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.CharacterType;
import prompto.type.IType;
import prompto.value.CharacterValue;

public class CharacterLiteral
extends Literal<CharacterValue> {
    public CharacterLiteral(String text) {
        super(text, CharacterLiteral.unescape(text));
    }

    private static CharacterValue unescape(String text) {
        StreamTokenizer parser = new StreamTokenizer(new StringReader(text));
        try {
            parser.nextToken();
            return new CharacterValue(parser.sval.charAt(0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IType check(Context context) {
        return CharacterType.instance();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        char c = ((CharacterValue)this.value).getValue();
        if ((c & 0xFFFFFF00) == 0) {
            method.addInstruction(Opcode.BIPUSH, new ByteOperand((byte)c));
        } else if ((c & 0xFFFF0000) == 0) {
            method.addInstruction(Opcode.SIPUSH, new ShortOperand((short)c));
        } else {
            method.addInstruction(Opcode.LDC_W, new IntConstant(c));
        }
        return CompilerUtils.charToCharacter(method);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append((String)this.text.get());
        return false;
    }
}

