/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.Supplier;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.expression.IExpression;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.type.CharacterType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.TextType;
import prompto.utils.ExpressionList;
import prompto.utils.TypeUtils;
import prompto.value.CharacterValue;
import prompto.value.DecimalValue;
import prompto.value.IContainer;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public abstract class ContainerLiteral<T extends IContainer<IValue>>
extends Literal<T> {
    boolean mutable;
    IType itemType = null;
    ExpressionList expressions = null;

    protected ContainerLiteral(Supplier<String> text, T value, ExpressionList expressions, boolean mutable) {
        super(text, value);
        this.expressions = expressions;
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public IType check(Context context) {
        if (this.itemType == null) {
            this.itemType = this.expressions != null ? TypeUtils.inferElementType(context, this.expressions) : TypeUtils.inferValuesType(context, this.getItems());
        }
        return this.newType(this.itemType);
    }

    protected abstract IType newType(IType var1);

    protected abstract Collection<IValue> getItems();

    protected IValue interpretPromotion(IValue item) {
        if (item == null) {
            return item;
        }
        if (DecimalType.instance() == this.itemType && item.getType() == IntegerType.instance()) {
            return new DecimalValue(((IntegerValue)item).doubleValue());
        }
        if (TextType.instance() == this.itemType && item.getType() == CharacterType.instance()) {
            return ((CharacterValue)item).asText();
        }
        return item;
    }

    public ExpressionList getExpressions() {
        return this.expressions;
    }

    protected void compileItems(Context context, MethodInfo method, Class<?> klass) {
        Flags flags = new Flags();
        flags.withPrimitive(true);
        for (IExpression e : this.expressions) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            ResultInfo info = e.compile(context, method, flags);
            this.compilePromotion(method, info);
            MethodConstant c = new MethodConstant(klass, "add", new Type[]{Object.class, Boolean.TYPE});
            method.addInstruction(Opcode.INVOKEVIRTUAL, c);
            method.addInstruction(Opcode.POP, new IOperand[0]);
        }
    }

    protected ResultInfo compilePromotion(MethodInfo method, ResultInfo info) {
        if (DecimalType.instance() == this.itemType && Long.class == info.getType()) {
            return CompilerUtils.LongToDouble(method);
        }
        if (TextType.instance() == this.itemType) {
            if (Character.TYPE == info.getType()) {
                return CompilerUtils.charToString(method);
            }
            if (Character.class == info.getType()) {
                return CompilerUtils.CharacterToString(method);
            }
        }
        return info;
    }
}

