/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.intrinsic.PromptoDate;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DateType;
import prompto.type.IType;
import prompto.value.DateValue;

public class DateLiteral
extends Literal<DateValue> {
    public DateLiteral(String text) {
        super(text, DateLiteral.parseDate(text.substring(1, text.length() - 1)));
    }

    public DateLiteral(PromptoDate date) {
        super("'" + date.toString() + "'", new DateValue(date));
    }

    @Override
    public IType check(Context context) {
        return DateType.instance();
    }

    public static DateValue parseDate(String text) {
        return new DateValue(PromptoDate.parse(text));
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        PromptoDate date = ((DateValue)this.value).getStorableData();
        method.addInstruction(Opcode.LDC_W, new StringConstant(date.toString()));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDate.class), "parse", new Type[]{String.class, PromptoDate.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)PromptoDate.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Period");
        transpiler.require("LocalDate");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("LocalDate.parse(").append((String)this.text.get()).append(")");
        return false;
    }
}

