/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.intrinsic.PromptoDateTime;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DateTimeType;
import prompto.type.IType;
import prompto.value.DateTimeValue;

public class DateTimeLiteral
extends Literal<DateTimeValue> {
    public DateTimeLiteral(String text) {
        super(text, DateTimeLiteral.parseDateTime(text.substring(1, text.length() - 1)));
    }

    public DateTimeLiteral(PromptoDateTime dateTime) {
        super("'" + dateTime.toString() + "'", new DateTimeValue(dateTime));
    }

    @Override
    public IType check(Context context) {
        return DateTimeType.instance();
    }

    public static DateTimeValue parseDateTime(String text) {
        return new DateTimeValue(PromptoDateTime.parse(text));
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        PromptoDateTime dateTime = ((DateTimeValue)this.value).getStorableData();
        method.addInstruction(Opcode.LDC_W, new StringConstant(dateTime.toString()));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoDateTime.class), "parse", new Type[]{String.class, PromptoDateTime.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)PromptoDateTime.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Period");
        transpiler.require("DateTime");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("DateTime.parse(").append((String)this.text.get()).append(")");
        return false;
    }
}

