/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import prompto.compiler.CompilerUtils;
import prompto.compiler.DoubleConstant;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.value.DecimalValue;

public class DecimalLiteral
extends Literal<DecimalValue> {
    public DecimalLiteral(String text) {
        super(text, DecimalValue.Parse(text));
    }

    public DecimalLiteral(double value) {
        super(Double.toString(value), new DecimalValue(value));
    }

    @Override
    public IType check(Context context) {
        return DecimalType.instance();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        double d = ((DecimalValue)this.value).doubleValue();
        if (d == 0.0) {
            method.addInstruction(Opcode.DCONST_0, new IOperand[0]);
        } else if (d == 1.0) {
            method.addInstruction(Opcode.DCONST_1, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LDC2_W, new DoubleConstant(d));
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Double.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.doubleToDouble(method);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append((String)this.text.get());
        return false;
    }
}

