/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.intrinsic.PromptoDict;
import prompto.literal.DictEntry;
import prompto.literal.DictEntryList;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DictType;
import prompto.type.IType;
import prompto.type.MissingType;
import prompto.utils.CodeWriter;
import prompto.utils.TypeUtils;
import prompto.value.DictionaryValue;
import prompto.value.IValue;
import prompto.value.TextValue;

public class DictLiteral
extends Literal<DictionaryValue> {
    boolean mutable;
    DictEntryList entries;
    IType itemType = null;

    public DictLiteral(boolean mutable) {
        super("<:>", new DictionaryValue((IType)MissingType.instance(), mutable));
        this.entries = new DictEntryList();
        this.mutable = mutable;
    }

    public DictLiteral(DictEntryList entries, boolean mutable) {
        super(() -> entries.toString(), new DictionaryValue((IType)MissingType.instance(), mutable));
        this.entries = entries;
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.mutable) {
            writer.append("mutable ");
        }
        this.entries.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        if (this.itemType == null) {
            this.itemType = this.inferElementType(context);
        }
        return new DictType(this.itemType);
    }

    private IType inferElementType(Context context) {
        if (this.entries.isEmpty()) {
            return MissingType.instance();
        }
        List<IType> types = this.entries.stream().map(e -> e.getValue().check(context)).collect(Collectors.toList());
        return TypeUtils.inferCollectionType(context, types);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (this.entries.size() > 0) {
            this.check(context);
            PromptoDict<TextValue, IValue> dict = new PromptoDict<TextValue, IValue>(true);
            for (DictEntry e : this.entries) {
                TextValue key = e.getKey().asText();
                IValue val = e.getValue().interpret(context);
                dict.put(key, val);
            }
            dict.setMutable(this.mutable);
            return new DictionaryValue(this.itemType, dict);
        }
        return this.value;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = CompilerUtils.compileNewRawInstance(method, PromptoDict.class);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.ICONST_1, new IOperand[0]);
        CompilerUtils.compileCallConstructor(method, PromptoDict.class, new Type[]{Boolean.TYPE});
        this.addEntries(context, method, flags.withPrimitive(false));
        if (!this.mutable) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            method.addInstruction(Opcode.ICONST_0, new IOperand[0]);
            MethodConstant m = new MethodConstant((Type)((Object)PromptoDict.class), "setMutable", Boolean.TYPE, Void.TYPE);
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
        }
        return info;
    }

    private void addEntries(Context context, MethodInfo method, Flags flags) {
        for (DictEntry e : this.entries) {
            MethodConstant m;
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            ResultInfo info = e.getKey().compile(context, method, flags);
            if (info.getType() != String.class) {
                m = new MethodConstant(info.getType(), "toString", new Type[]{String.class});
                method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            }
            e.getValue().compile(context, method, flags);
            m = new MethodConstant((Type)((Object)PromptoDict.class), "put", new Type[]{Object.class, Object.class, Object.class});
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            method.addInstruction(Opcode.POP, new IOperand[0]);
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Dictionary");
        this.entries.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("new Dictionary(").append(this.mutable).append(", ");
        this.entries.transpile(transpiler);
        transpiler.append(")");
        return false;
    }
}

