/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoDocument;
import prompto.literal.DictEntry;
import prompto.literal.DocEntryList;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DocumentType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.DocumentValue;
import prompto.value.IValue;

public class DocumentLiteral
extends Literal<DocumentValue> {
    DocEntryList entries;

    public DocumentLiteral() {
        super("{}", new DocumentValue());
        this.entries = new DocEntryList();
    }

    public DocumentLiteral(DocEntryList entries) {
        super(() -> entries.toString(), new DocumentValue());
        this.entries = entries;
    }

    public DocEntryList getEntries() {
        return this.entries;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        this.entries.toDialect(writer);
    }

    @Override
    public IType check(Context context) {
        return DocumentType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (this.entries.size() > 0) {
            PromptoDocument<Identifier, IValue> doc = new PromptoDocument<Identifier, IValue>();
            for (DictEntry e : this.entries) {
                Identifier key = e.getKey().asIdentifier();
                IValue val = e.getValue().interpret(context);
                doc.put(key, val);
            }
            return new DocumentValue(context, doc, false);
        }
        return this.value;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = CompilerUtils.compileNewInstance(method, PromptoDocument.class);
        this.addEntries(context, method, flags.withPrimitive(false));
        return info;
    }

    private void addEntries(Context context, MethodInfo method, Flags flags) {
        for (DictEntry e : this.entries) {
            MethodConstant m;
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            ResultInfo info = e.getKey().compile(context, method, flags);
            if (info.getType() != String.class) {
                m = new MethodConstant(info.getType(), "toString", new Type[]{String.class});
                method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            }
            e.getValue().compile(context, method, flags);
            m = new MethodConstant((Type)((Object)PromptoDocument.class), "put", new Type[]{Object.class, Object.class, Object.class});
            method.addInstruction(Opcode.INVOKEVIRTUAL, m);
            method.addInstruction(Opcode.POP, new IOperand[0]);
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Document");
        this.entries.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("new Document(");
        this.entries.transpile(transpiler);
        transpiler.append(")");
        return false;
    }
}

