/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.value.IntegerValue;

public class HexaLiteral
extends Literal<IntegerValue> {
    public HexaLiteral(String text) {
        super(text, HexaLiteral.parseHexa(text));
    }

    @Override
    public IType check(Context context) {
        return IntegerType.instance();
    }

    public static IntegerValue parseHexa(String text) {
        long value = 0L;
        for (char c : text.substring(2).toCharArray()) {
            value <<= 4;
            if (c >= '0' && c <= '9') {
                value += (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                value += (long)(c - 97);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                value += (long)(10 + (c - 65));
                continue;
            }
            throw new NumberFormatException(text + " is not a valid hexadecimal number");
        }
        return new IntegerValue(value);
    }
}

