/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.LongConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.value.IntegerValue;

public class IntegerLiteral
extends Literal<IntegerValue> {
    public IntegerLiteral(String text) {
        super(text, new IntegerValue(Long.valueOf(text)));
    }

    public IntegerLiteral(long value) {
        super(Long.toString(value), new IntegerValue(value));
    }

    public IntegerLiteral(String text, IntegerValue value) {
        super(text, value);
    }

    @Override
    public IType check(Context context) {
        return IntegerType.instance();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        long l = ((IntegerValue)this.value).longValue();
        if (l >= 0L && l <= 1L) {
            Opcode opcode = Opcode.values()[Opcode.LCONST_0.ordinal() + (int)l];
            method.addInstruction(opcode, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.LDC2_W, new LongConstant(l));
        }
        if (flags.toPrimitive()) {
            return new ResultInfo(Long.TYPE, new ResultInfo.Flag[0]);
        }
        return CompilerUtils.longToLong(method);
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append((String)this.text.get());
        return false;
    }
}

