/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.util.function.Supplier;
import java.util.stream.Collectors;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.runtime.Context;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public abstract class Literal<T extends IValue>
implements IExpression {
    Supplier<String> text;
    protected T value;

    protected Literal(String text, T value) {
        this(() -> text, value);
    }

    protected Literal(Supplier<String> text, T value) {
        this.text = text;
        this.value = value;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.escapedText(writer.getEscapeMode()));
    }

    public String escapedText(int escapeMode) {
        String value = this.text.get();
        if (escapeMode <= 0 || !value.contains("'")) {
            return value;
        }
        return value.chars().mapToObj(c -> c == 39 ? "\\'" : Character.valueOf((char)c).toString()).collect(Collectors.joining());
    }

    public String toString() {
        return this.text.get();
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Literal) {
            return this.value.equals(((Literal)obj).value);
        }
        return this.value.equals(obj);
    }
}

