/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.intrinsic.PromptoPeriod;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.PeriodType;
import prompto.value.PeriodValue;

public class PeriodLiteral
extends Literal<PeriodValue> {
    public PeriodLiteral(String text) {
        super(text, PeriodLiteral.parseDuration(text.substring(1, text.length() - 1)));
    }

    @Override
    public IType check(Context context) {
        return PeriodType.instance();
    }

    public static PeriodValue parseDuration(String text) {
        return new PeriodValue(PromptoPeriod.parse(text));
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        PromptoPeriod period = ((PeriodValue)this.value).getStorableData();
        method.addInstruction(Opcode.LDC_W, new StringConstant(period.toString()));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoPeriod.class), "parse", new Type[]{String.class, PromptoPeriod.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)PromptoPeriod.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Period");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("Period.parse(").append((String)this.text.get()).append(")");
        return false;
    }
}

