/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoDate;
import prompto.intrinsic.PromptoRange;
import prompto.intrinsic.PromptoTime;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class RangeLiteral
implements IExpression {
    IExpression first;
    IExpression last;
    static Map<Type, Type> rangeClassMap = RangeLiteral.createRangeClassMap();

    public RangeLiteral(IExpression first, IExpression last) {
        this.first = first;
        this.last = last;
    }

    public String toString() {
        return "[" + this.first.toString() + ".." + this.last.toString() + "]";
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append("[");
        this.first.toDialect(writer);
        writer.append("..");
        this.last.toDialect(writer);
        writer.append("]");
    }

    private static Map<Type, Type> createRangeClassMap() {
        HashMap<Type, Type> map = new HashMap<Type, Type>();
        map.put(Character.TYPE, (Type)((Object)PromptoRange.Character.class));
        map.put((Type)((Object)Character.class), (Type)((Object)PromptoRange.Character.class));
        map.put(Long.TYPE, (Type)((Object)PromptoRange.Long.class));
        map.put((Type)((Object)Long.class), (Type)((Object)PromptoRange.Long.class));
        map.put((Type)((Object)PromptoDate.class), (Type)((Object)PromptoRange.Date.class));
        map.put((Type)((Object)PromptoTime.class), (Type)((Object)PromptoRange.Time.class));
        return map;
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        IType itemType = RangeLiteral.checkType(context, this.first);
        Type itemKlass = itemType.getJavaType(context);
        Type rangeKlass = rangeClassMap.get(itemKlass);
        if (rangeKlass == null) {
            System.err.println("Missing PromptoRange for = " + itemType.getFamilyInfo(context));
            throw new SyntaxError("Cannot build Range of " + itemType.getFamilyInfo(context));
        }
        CompilerUtils.compileNewRawInstance(method, rangeKlass);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        this.first.compile(context, method, flags.withPrimitive(false));
        this.last.compile(context, method, flags.withPrimitive(false));
        return CompilerUtils.compileCallConstructor(method, rangeKlass, itemKlass, itemKlass);
    }

    public IExpression getFirst() {
        return this.first;
    }

    public IExpression getLast() {
        return this.last;
    }

    @Override
    public IType check(Context context) {
        return RangeLiteral.checkType(context, this.first).checkRange(context, RangeLiteral.checkType(context, this.last));
    }

    private static IType checkType(Context context, IExpression exp) {
        IType type = exp.check(context);
        if (!"IntegerLimits".equals(type.getTypeName())) {
            return type;
        }
        return IntegerType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        IType type = RangeLiteral.checkType(context, this.first);
        IValue of = this.first.interpret(context);
        IValue ol = this.last.interpret(context);
        return type.newRange(of, ol);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.first.declare(transpiler);
        IType firstType = this.first.check(transpiler.getContext());
        firstType.declare(transpiler);
        this.last.declare(transpiler);
        IType lastType = this.last.check(transpiler.getContext());
        lastType.declare(transpiler);
        firstType.declareRange(transpiler, lastType);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        IType firstType = this.first.check(transpiler.getContext());
        firstType.transpileRange(transpiler, this.first, this.last);
        return false;
    }
}

