/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.util.Collection;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoSet;
import prompto.literal.ContainerLiteral;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.MissingType;
import prompto.type.SetType;
import prompto.utils.CodeWriter;
import prompto.utils.ExpressionList;
import prompto.value.IValue;
import prompto.value.SetValue;

public class SetLiteral
extends ContainerLiteral<SetValue> {
    public SetLiteral() {
        super(() -> "<>", new SetValue(MissingType.instance()), null, false);
    }

    public SetLiteral(ExpressionList expressions) {
        super(() -> "<" + expressions.toString() + ">", new SetValue(MissingType.instance()), expressions, false);
    }

    @Override
    public Collection<IValue> getItems() {
        return ((SetValue)this.value).getItems();
    }

    @Override
    protected IType newType(IType itemType) {
        return new SetType(itemType);
    }

    @Override
    public SetValue interpret(Context context) throws PromptoError {
        if (((SetValue)this.value).isEmpty() && this.expressions != null && !this.expressions.isEmpty()) {
            this.check(context);
            PromptoSet<IValue> set = new PromptoSet<IValue>();
            for (IExpression exp : this.expressions) {
                IValue item = exp.interpret(context);
                item = this.interpretPromotion(item);
                set.add(item);
            }
            this.value = new SetValue(this.itemType, set);
        }
        return (SetValue)this.value;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.expressions != null) {
            writer.append('<');
            this.expressions.toDialect(writer);
            writer.append('>');
        } else {
            writer.append("< >");
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = CompilerUtils.compileNewInstance(method, PromptoSet.class);
        if (this.expressions != null) {
            this.compileItems(context, method, PromptoSet.class);
        }
        return info;
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("StrictSet");
        this.expressions.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("new StrictSet([");
        this.expressions.transpile(transpiler);
        transpiler.append("])");
        return false;
    }
}

