/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.intrinsic.PromptoTime;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.TimeType;
import prompto.value.TimeValue;

public class TimeLiteral
extends Literal<TimeValue> {
    public TimeLiteral(String text) {
        super(text, TimeLiteral.parseTime(text.substring(1, text.length() - 1)));
    }

    public TimeLiteral(PromptoTime time) {
        super("'" + time.toString() + "'", new TimeValue(time));
    }

    @Override
    public IType check(Context context) {
        return TimeType.instance();
    }

    public static TimeValue parseTime(String text) {
        return new TimeValue(PromptoTime.parse(text));
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        PromptoTime time = ((TimeValue)this.value).getStorableData();
        method.addInstruction(Opcode.LDC_W, new StringConstant(time.toString()));
        MethodConstant oper = new MethodConstant((Type)((Object)PromptoTime.class), "parse", new Type[]{String.class, PromptoTime.class});
        method.addInstruction(Opcode.INVOKESTATIC, oper);
        return new ResultInfo((Type)((Object)PromptoTime.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Period");
        transpiler.require("LocalTime");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("LocalTime.parse(").append((String)this.text.get()).append(")");
        return false;
    }
}

