/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.intrinsic.PromptoTuple;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.TupleType;
import prompto.utils.CodeWriter;
import prompto.utils.ExpressionList;
import prompto.value.IValue;
import prompto.value.TupleValue;

public class TupleLiteral
extends Literal<TupleValue> {
    ExpressionList expressions = null;
    boolean mutable = false;

    public TupleLiteral(boolean mutable) {
        super("()", new TupleValue(mutable));
        this.mutable = mutable;
    }

    public TupleLiteral(ExpressionList expressions, boolean mutable) {
        super(() -> TupleLiteral.toTupleString(expressions), new TupleValue(mutable));
        this.expressions = expressions;
        this.mutable = mutable;
    }

    private static String toTupleString(ExpressionList expressions) {
        return "(" + expressions.toString() + (expressions.size() == 1 ? "," : "") + ")";
    }

    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public IType check(Context context) {
        return TupleType.instance();
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        if (((TupleValue)this.value).isEmpty() && this.expressions != null) {
            PromptoTuple<IValue> list = new PromptoTuple<IValue>(this.mutable);
            for (IExpression exp : this.expressions) {
                list.add(exp.interpret(context));
            }
            this.value = new TupleValue(list);
        }
        return this.value;
    }

    public ExpressionList getExpressions() {
        return this.expressions;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.mutable) {
            writer.append("mutable ");
        }
        if (this.expressions != null) {
            writer.append('(');
            this.expressions.toDialect(writer);
            if (this.expressions.size() == 1) {
                writer.append(',');
            }
            writer.append(')');
        } else {
            writer.append("()");
        }
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        ResultInfo info = CompilerUtils.compileNewRawInstance(method, PromptoTuple.class);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(this.mutable ? Opcode.ICONST_1 : Opcode.ICONST_0, new IOperand[0]);
        CompilerUtils.compileCallConstructor(method, PromptoTuple.class, new Type[]{Boolean.TYPE});
        if (this.expressions != null) {
            this.addItems(context, method, flags);
        }
        return info;
    }

    private void addItems(Context context, MethodInfo method, Flags flags) {
        for (IExpression e : this.expressions) {
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            e.compile(context, method, flags.withPrimitive(false));
            MethodConstant c = new MethodConstant((Type)((Object)PromptoTuple.class), "add", new Type[]{Object.class, Boolean.TYPE});
            method.addInstruction(Opcode.INVOKEVIRTUAL, c);
            method.addInstruction(Opcode.POP, new IOperand[0]);
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("List");
        transpiler.require("Tuple");
        this.expressions.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("new Tuple(").append(this.mutable).append(", [");
        this.expressions.transpile(transpiler);
        transpiler.append("])");
        return false;
    }
}

