/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.error.PromptoError;
import prompto.expression.IExpression;
import prompto.expression.TypeExpression;
import prompto.intrinsic.PromptoType;
import prompto.parser.Dialect;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.TypeType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;
import prompto.value.TypeValue;

public class TypeLiteral
extends Section
implements IExpression {
    IType type;

    public TypeLiteral(IType type) {
        this.type = type;
    }

    public IType getType() {
        return this.type;
    }

    @Override
    public IType check(Context context) {
        return new TypeType(this.type);
    }

    @Override
    public IValue interpret(Context context) throws PromptoError {
        return new TypeValue(this.type);
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        CompilerUtils.compileNewRawInstance(method, PromptoType.class);
        method.addInstruction(Opcode.DUP, new IOperand[0]);
        method.addInstruction(Opcode.LDC, new StringConstant(this.type.getTypeName()));
        CompilerUtils.compileCallConstructor(method, PromptoType.class, new Type[]{String.class});
        return new ResultInfo((Type)((Object)PromptoType.class), new ResultInfo.Flag[0]);
    }

    @Override
    public ResultInfo compileParent(Context context, MethodInfo method, Flags flags) {
        return new TypeExpression(this.type).compileParent(context, method, flags);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (writer.getDialect() == Dialect.E) {
            writer.append("Type: ");
        }
        this.type.toDialect(writer);
    }

    @Override
    public void parentToDialect(CodeWriter writer) {
        this.type.toDialect(writer);
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("Type");
    }

    @Override
    public void declareParent(Transpiler transpiler) {
        this.type.declare(transpiler);
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("new Type('").append(this.type.toString()).append("')");
        return false;
    }

    @Override
    public boolean transpileParent(Transpiler transpiler) {
        transpiler.append(this.type.toString());
        return false;
    }
}

