/*
 * Decompiled with CFR 0.152.
 */
package prompto.literal;

import java.lang.reflect.Type;
import java.util.UUID;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StringConstant;
import prompto.literal.Literal;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.type.UuidType;
import prompto.value.UuidValue;

public class UuidLiteral
extends Literal<UuidValue> {
    public UuidLiteral(String text) {
        super(text, UuidLiteral.parse(text));
    }

    private static UuidValue parse(String text) {
        return new UuidValue(UUID.fromString(text.substring(1, text.length() - 1)));
    }

    @Override
    public IType check(Context context) {
        return UuidType.instance();
    }

    @Override
    public ResultInfo compile(Context context, MethodInfo method, Flags flags) {
        UUID uuid = ((UuidValue)this.value).getValue();
        StringConstant operand = new StringConstant(uuid.toString());
        method.addInstruction(Opcode.LDC_W, operand);
        MethodConstant m = new MethodConstant((Type)((Object)UUID.class), "fromString", new Type[]{String.class, UUID.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        return new ResultInfo((Type)((Object)UUID.class), new ResultInfo.Flag[0]);
    }

    @Override
    public void declare(Transpiler transpiler) {
        transpiler.require("UUID");
    }

    @Override
    public boolean transpile(Transpiler transpiler) {
        transpiler.append("UUID.fromString(").append((String)this.text.get()).append(")");
        return false;
    }
}

