/*
 * Decompiled with CFR 0.152.
 */
package prompto.param;

import java.lang.reflect.Type;
import java.util.Objects;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.FieldInfo;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.param.BaseParameter;
import prompto.param.INamedParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.CategoryType;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class AttributeParameter
extends BaseParameter
implements INamedParameter {
    public AttributeParameter(Identifier id) {
        super(id);
    }

    @Override
    public String getSignature(Dialect dialect) {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.id);
        if (this.defaultExpression != null) {
            writer.append(" = ");
            this.defaultExpression.toDialect(writer);
        }
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getProto() {
        return this.id.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeParameter)) {
            return false;
        }
        AttributeParameter other = (AttributeParameter)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Override
    public void register(Context context) {
        context.registerValue(this, true);
        if (this.defaultExpression != null) {
            try {
                context.setValue(this.id, this.defaultExpression.interpret(context));
            }
            catch (PromptoError error) {
                throw new SyntaxError("Unable to register default value: " + this.defaultExpression.toString() + " for argument: " + this.id);
            }
        }
    }

    @Override
    public void check(Context context) {
        AttributeDeclaration actual = context.getRegisteredDeclaration(AttributeDeclaration.class, this.id);
        if (actual == null) {
            throw new SyntaxError("Unknown attribute: \"" + this.id + "\"");
        }
    }

    @Override
    public IType getType(Context context) {
        IDeclaration named = context.getRegisteredDeclaration(IDeclaration.class, this.id);
        return named.getType(context);
    }

    @Override
    public IValue checkValue(Context context, IExpression expression) throws PromptoError {
        AttributeDeclaration actual = context.getRegisteredDeclaration(AttributeDeclaration.class, this.id);
        return actual.checkValue(context, expression);
    }

    @Override
    public Type getJavaType(Context context) {
        return CompilerUtils.getAttributeInterfaceType(this.id);
    }

    @Override
    public StackLocal registerLocal(Context context, MethodInfo method, Flags flags) {
        String desc = CompilerUtils.getDescriptor(this.getJavaType(context));
        IVerifierEntry.VerifierType type = IVerifierEntry.VerifierType.fromDescriptor(desc);
        ClassConstant classConstant = new ClassConstant(this.getJavaType(context));
        String instanceName = "%" + this.getName() + "%";
        return method.registerLocal(instanceName, type, classConstant);
    }

    @Override
    public void extractLocal(Context context, MethodInfo method, Flags flags) {
        super.registerLocal(context, method, flags);
        String instanceName = "%" + this.getName() + "%";
        CompilerUtils.compileALOAD(method, instanceName);
        Type klass = this.getJavaType(context);
        String getterName = CompilerUtils.getterName(this.getName());
        AttributeDeclaration actual = context.getRegisteredDeclaration(AttributeDeclaration.class, this.id);
        FieldInfo field = actual.toFieldInfo(context);
        InterfaceConstant m = new InterfaceConstant(klass, getterName, field.getType());
        method.addInstruction(Opcode.INVOKEINTERFACE, m);
        StackLocal local = method.getRegisteredLocal(this.getName());
        CompilerUtils.compileASTORE(method, local);
    }

    @Override
    public void compileParameter(Context context, MethodInfo method, Flags flags, ArgumentList assignments, boolean isFirst) {
        Argument assign = this.makeArgument(assignments, isFirst);
        IType itype = assign.getExpression().check(context.getCallingContext());
        if (itype instanceof CategoryType) {
            assign.getExpression().compile(context.getCallingContext(), method, flags);
        } else {
            Type type = CompilerUtils.getAttributeConcreteType(this.id);
            CompilerUtils.compileNewRawInstance(method, type);
            method.addInstruction(Opcode.DUP, new IOperand[0]);
            ResultInfo info = assign.getExpression().compile(context.getCallingContext(), method, flags);
            CompilerUtils.compileCallConstructor(method, type, info.getType());
        }
    }

    @Override
    public String getTranspiledName(Context context) {
        return this.id.toString();
    }

    @Override
    public void declare(Transpiler transpiler) {
        IDeclaration decl = transpiler.getContext().getRegisteredDeclaration(IDeclaration.class, this.id);
        decl.declare(transpiler);
    }

    @Override
    public void transpileCall(Transpiler transpiler, IExpression expression) {
        AttributeDeclaration decl = transpiler.getContext().getRegisteredDeclaration(AttributeDeclaration.class, this.id);
        if (decl.getConstraint() != null) {
            transpiler.append("$check_").append(this.getName()).append("(");
            super.transpileCall(transpiler, expression);
            transpiler.append(")");
        } else {
            super.transpileCall(transpiler, expression);
        }
    }
}

