/*
 * Decompiled with CFR 0.152.
 */
package prompto.param;

import java.lang.reflect.Type;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.MethodInfo;
import prompto.compiler.ResultInfo;
import prompto.compiler.StackLocal;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.DefaultExpression;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.param.IParameter;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DecimalType;
import prompto.type.IntegerType;
import prompto.value.DecimalValue;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public abstract class BaseParameter
implements IParameter {
    Identifier id;
    boolean mutable = false;
    DefaultExpression defaultExpression;

    protected BaseParameter(Identifier id) {
        this.id = id;
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    @Override
    public boolean setMutable(boolean set) {
        boolean result = this.mutable;
        this.mutable = set;
        return result;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public DefaultExpression getDefaultExpression() {
        return this.defaultExpression;
    }

    public void setDefaultExpression(IExpression expression) {
        this.defaultExpression = expression == null ? null : new DefaultExpression(expression);
    }

    @Override
    public IValue checkValue(Context context, IExpression expression) throws PromptoError {
        IValue value = expression.interpret(context);
        if (value instanceof IntegerValue && this.getType(context) == DecimalType.instance()) {
            return new DecimalValue(((IntegerValue)value).doubleValue());
        }
        if (value instanceof DecimalValue && this.getType(context) == IntegerType.instance()) {
            return new IntegerValue(((DecimalValue)value).longValue());
        }
        return value;
    }

    @Override
    public Type getJavaType(Context context) {
        return this.getType(context).getJavaType(context);
    }

    @Override
    public StackLocal registerLocal(Context context, MethodInfo method, Flags flags) {
        String desc = CompilerUtils.getDescriptor(this.getJavaType(context));
        IVerifierEntry.VerifierType type = IVerifierEntry.VerifierType.fromDescriptor(desc);
        ClassConstant classConstant = new ClassConstant(this.getJavaType(context));
        return method.registerLocal(this.getName(), type, classConstant);
    }

    @Override
    public void compileParameter(Context context, MethodInfo method, Flags flags, ArgumentList assignments, boolean isFirst) {
        Argument assign = this.makeArgument(assignments, isFirst);
        ResultInfo valueInfo = assign.getExpression().compile(context.getCallingContext(), method, flags);
        Type type = this.getJavaType(context);
        if (type == Double.class) {
            CompilerUtils.numberToDouble(method, valueInfo);
        } else if (type == Long.class) {
            CompilerUtils.numberToLong(method, valueInfo);
        }
    }

    protected Argument makeArgument(ArgumentList assignments, boolean isFirst) {
        Argument assign = assignments.find(this.id);
        if (assign != null) {
            return assign;
        }
        if (isFirst && assignments.size() > 0 && ((Argument)assignments.get(0)).getParameter() == null) {
            return (Argument)assignments.get(0);
        }
        if (this.defaultExpression != null) {
            return new Argument(this, this.defaultExpression);
        }
        throw new SyntaxError("Missing value for argument " + this.getName());
    }

    @Override
    public void transpile(Transpiler transpiler) {
        transpiler.append(this.getName());
    }

    @Override
    public void transpileCall(Transpiler transpiler, IExpression expression) {
        expression.transpile(transpiler);
    }
}

