/*
 * Decompiled with CFR 0.152.
 */
package prompto.param;

import java.util.Objects;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.expression.IExpression;
import prompto.grammar.Identifier;
import prompto.param.BaseParameter;
import prompto.param.ITypedParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.IntegerType;
import prompto.type.MethodType;
import prompto.utils.CodeWriter;
import prompto.value.ContextualExpression;

public class CategoryParameter
extends BaseParameter
implements ITypedParameter {
    IType type;
    IType resolved;

    public CategoryParameter(IType type, Identifier id) {
        super(id);
        this.type = type;
    }

    public CategoryParameter(IType type, Identifier id, IExpression defaultValue) {
        super(id);
        this.type = type;
        this.setDefaultExpression(defaultValue);
    }

    @Override
    public IType getType() {
        return this.type;
    }

    public IType getResolved() {
        return this.resolved;
    }

    @Override
    public String getSignature(Dialect dialect) {
        return this.getProto();
    }

    @Override
    public String getProto() {
        return this.type.getTypeNameId().toString();
    }

    @Override
    public String getTranspiledName(Context context) {
        return this.type.getTranspiledName(context);
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.mutable) {
            writer.append("mutable ");
        }
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
        if (this.defaultExpression != null) {
            writer.append(" = ");
            this.defaultExpression.toDialect(writer);
        }
    }

    private void toEDialect(CodeWriter writer) {
        boolean anonymous = "any".equals(this.type.getTypeName());
        this.type.toDialect(writer);
        if (anonymous) {
            writer.append(' ');
            writer.append(this.id);
        }
        if (!anonymous) {
            writer.append(' ');
            writer.append(this.id);
        }
    }

    private void toODialect(CodeWriter writer) {
        this.type.toDialect(writer);
        writer.append(' ');
        writer.append(this.id);
    }

    private void toMDialect(CodeWriter writer) {
        writer.append(this.id);
        writer.append(':');
        this.type.toDialect(writer);
    }

    public String toString() {
        return this.id.toString() + ':' + this.getProto();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryParameter)) {
            return false;
        }
        CategoryParameter other = (CategoryParameter)obj;
        return Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getId(), other.getId());
    }

    @Override
    public void register(Context context) {
        Context actual = context.contextForValue(this.id);
        if (actual == context) {
            throw new SyntaxError("Duplicate argument: \"" + this.id + "\"");
        }
        context.registerValue(this);
        if (this.defaultExpression != null) {
            try {
                context.setValue(this.id, this.defaultExpression.interpret(context));
            }
            catch (PromptoError error) {
                throw new SyntaxError("Unable to register default value: " + this.defaultExpression.toString() + " for argument: " + this.id);
            }
        }
    }

    @Override
    public void check(Context context) {
        this.resolve(context);
        this.resolved.checkExists(context);
    }

    private void resolve(Context context) {
        if (this.resolved == null) {
            this.resolved = this.type.resolve(context, null);
        }
    }

    @Override
    public IType getType(Context context) {
        return this.type;
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.resolve(transpiler.getContext());
        this.resolved.declare(transpiler);
    }

    @Override
    public void transpileCall(Transpiler transpiler, IExpression expression) {
        this.resolve(transpiler.getContext());
        if (!this.transpileArrowExpressionCall(transpiler, expression)) {
            this.transpileValue(transpiler, expression);
        }
    }

    private boolean transpileArrowExpressionCall(Transpiler transpiler, IExpression expression) {
        if (this.resolved instanceof MethodType) {
            if (expression instanceof ContextualExpression) {
                expression = ((ContextualExpression)expression).getExpression();
            }
            if (expression instanceof ArrowExpression) {
                ((MethodType)this.resolved).transpileArrowExpression(transpiler, (ArrowExpression)expression);
                return true;
            }
        }
        return false;
    }

    void transpileValue(Transpiler transpiler, IExpression expression) {
        IType expType = expression.check(transpiler.getContext());
        if (this.resolved == IntegerType.instance() && expType == DecimalType.instance()) {
            transpiler.append("Math.round(");
            expression.transpile(transpiler);
            transpiler.append(")");
        } else {
            expression.transpile(transpiler);
        }
    }
}

