/*
 * Decompiled with CFR 0.152.
 */
package prompto.param;

import java.lang.reflect.Type;
import java.util.Objects;
import prompto.compiler.ClassConstant;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Flags;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.Opcode;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.grammar.ArgumentList;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoProxy;
import prompto.param.CategoryParameter;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.utils.IdentifierList;

public class ExtendedParameter
extends CategoryParameter {
    IdentifierList attributes;

    public ExtendedParameter(IType type, Identifier id, IdentifierList attributes) {
        super(type, id);
        this.attributes = attributes;
    }

    public IdentifierList getAttributes() {
        return this.attributes;
    }

    @Override
    public String getProto() {
        return this.type.getTypeNameId().toString() + '(' + this.attributes.toString() + ')';
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.mutable) {
            writer.append("mutable ");
        }
        switch (writer.getDialect()) {
            case E: {
                this.toEDialect(writer);
                break;
            }
            case O: {
                this.toODialect(writer);
                break;
            }
            case M: {
                this.toMDialect(writer);
            }
        }
        if (this.defaultExpression != null) {
            writer.append(" = ");
            this.defaultExpression.toDialect(writer);
        }
    }

    private void toEDialect(CodeWriter writer) {
        this.type.toDialect(writer);
        writer.append(' ');
        writer.append(this.id);
        switch (this.attributes.size()) {
            case 0: {
                break;
            }
            case 1: {
                writer.append(" with attribute ");
                this.attributes.toDialect(writer, false);
                break;
            }
            default: {
                writer.append(" with attributes ");
                this.attributes.toDialect(writer, true);
            }
        }
    }

    private void toODialect(CodeWriter writer) {
        this.type.toDialect(writer);
        writer.append('(');
        this.attributes.toDialect(writer, false);
        writer.append(')');
        writer.append(' ');
        writer.append(this.id);
    }

    private void toMDialect(CodeWriter writer) {
        writer.append(this.id);
        writer.append(':');
        this.type.toDialect(writer);
        writer.append('(');
        this.attributes.toDialect(writer, false);
        writer.append(')');
    }

    @Override
    public String toString() {
        return this.id.toString() + ':' + this.getProto();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExtendedParameter)) {
            return false;
        }
        ExtendedParameter other = (ExtendedParameter)obj;
        return Objects.equals(this.getType(), other.getType()) && Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes());
    }

    @Override
    public void register(Context context) {
        INamed actual = context.getRegisteredValue(INamed.class, this.id);
        if (actual != null) {
            throw new SyntaxError("Duplicate argument: \"" + this.id + "\"");
        }
        ConcreteCategoryDeclaration declaration = new ConcreteCategoryDeclaration(this.id, this.attributes, new IdentifierList(this.type.getTypeNameId()), null);
        context.registerDeclaration(declaration);
        context.registerValue(this);
        if (this.defaultExpression != null) {
            try {
                context.setValue(this.id, this.defaultExpression.interpret(context));
            }
            catch (PromptoError error) {
                throw new SyntaxError("Unable to register default value: " + this.defaultExpression.toString() + " for argument: " + this.id);
            }
        }
    }

    @Override
    public void check(Context context) {
        this.type.checkExists(context);
        for (Identifier attribute : this.attributes) {
            AttributeDeclaration actual = context.getRegisteredDeclaration(AttributeDeclaration.class, attribute);
            if (actual != null) continue;
            throw new SyntaxError("Unknown attribute: \"" + attribute + "\"");
        }
    }

    @Override
    public IType getType(Context context) {
        IDeclaration decl = context.getRegisteredDeclaration(IDeclaration.class, this.id);
        return decl != null ? decl.getType(context) : this.type;
    }

    @Override
    public Type getJavaType(Context context) {
        return CompilerUtils.getExtendedInterfaceType(this.type.getTypeNameId(), this.attributes);
    }

    @Override
    public void compileParameter(Context context, MethodInfo method, Flags flags, ArgumentList assignments, boolean isFirst) {
        super.compileParameter(context, method, flags, assignments, isFirst);
        ClassConstant c = new ClassConstant(this.getJavaType(context));
        method.addInstruction(Opcode.LDC, c);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoProxy.class), "newProxy", new Type[]{Object.class, Class.class, Object.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.CHECKCAST, c);
    }
}

