/*
 * Decompiled with CFR 0.152.
 */
package prompto.param;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import prompto.compiler.ClassConstant;
import prompto.compiler.ClassFile;
import prompto.compiler.CompilerUtils;
import prompto.compiler.Descriptor;
import prompto.compiler.Flags;
import prompto.compiler.IOperand;
import prompto.compiler.IVerifierEntry;
import prompto.compiler.InterfaceType;
import prompto.compiler.MethodConstant;
import prompto.compiler.MethodInfo;
import prompto.compiler.NamedType;
import prompto.compiler.Opcode;
import prompto.compiler.StackLocal;
import prompto.compiler.StringConstant;
import prompto.declaration.IMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.ArrowExpression;
import prompto.expression.IExpression;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.grammar.ParameterList;
import prompto.intrinsic.PromptoProxy;
import prompto.param.BaseParameter;
import prompto.param.CodeParameter;
import prompto.param.INamedParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.MethodType;
import prompto.type.VoidType;
import prompto.utils.CodeWriter;
import prompto.value.ArrowValue;
import prompto.value.ContextualExpression;
import prompto.value.IValue;

public class MethodParameter
extends BaseParameter
implements INamedParameter {
    public MethodParameter(Identifier id) {
        super(id);
    }

    @Override
    public String getSignature(Dialect dialect) {
        return this.id.toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.id);
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getProto() {
        return this.id.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MethodParameter)) {
            return false;
        }
        MethodParameter other = (MethodParameter)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Override
    public void register(Context context) {
        INamed actual = context.getRegisteredValue(INamed.class, this.id);
        if (actual != null) {
            throw new SyntaxError("Duplicate parameter: \"" + this.id + "\"");
        }
        context.registerValue(this);
    }

    @Override
    public void check(Context context) {
        IMethodDeclaration actual = this.getDeclaration(context);
        if (actual == null) {
            throw new SyntaxError("Unknown method: \"" + this.id + "\"");
        }
    }

    @Override
    public IValue checkValue(Context context, IExpression expression) throws PromptoError {
        boolean isArrow;
        boolean bl = isArrow = expression instanceof ContextualExpression && ((ContextualExpression)expression).getExpression() instanceof ArrowExpression;
        if (isArrow) {
            return this.checkArrowValue(context, (ContextualExpression)expression);
        }
        return super.checkValue(context, expression);
    }

    private IValue checkArrowValue(Context context, ContextualExpression expression) {
        return new ArrowValue(this.getDeclaration(context), expression.getCalling(), (ArrowExpression)expression.getExpression());
    }

    @Override
    public MethodType getType(Context context) {
        IMethodDeclaration actual = this.getDeclaration(context);
        return new MethodType(actual);
    }

    private IMethodDeclaration getDeclaration(Context context) {
        Context.MethodDeclarationMap methods = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, this.id);
        if (methods != null) {
            return (IMethodDeclaration)methods.values().iterator().next();
        }
        return null;
    }

    @Override
    public void compileParameter(Context context, MethodInfo method, Flags flags, ArgumentList arguments, boolean isFirst) {
        Argument argument = this.makeArgument(arguments, isFirst);
        IExpression expression = argument.getExpression();
        if (expression instanceof ArrowExpression) {
            this.compileArrowArgument(context, method, flags, (ArrowExpression)expression);
        } else {
            this.compileMethodArgument(context, method, flags, expression);
        }
    }

    private void compileMethodArgument(Context context, MethodInfo method, Flags flags, IExpression expression) {
        MethodType target = this.getType(context);
        IMethodDeclaration decl = target.getMethod();
        ParameterList parameters = decl.getParameters();
        expression.compile(context.getCallingContext(), method, flags);
        ClassConstant dest = new ClassConstant(this.getJavaType(context));
        method.addInstruction(Opcode.LDC, dest);
        InterfaceType intf = new InterfaceType(parameters, decl.getReturnType());
        String methodName = intf.getInterfaceMethodName();
        method.addInstruction(Opcode.LDC, new StringConstant(methodName));
        List<Type> javaTypes = parameters.stream().map(arg -> arg.getJavaType(context)).collect(Collectors.toList());
        CompilerUtils.compileClassConstantsArray(method, javaTypes);
        MethodConstant m = new MethodConstant((Type)((Object)PromptoProxy.class), "newProxy", new Type[]{Object.class, Class.class, String.class, Class[].class, Object.class});
        method.addInstruction(Opcode.INVOKESTATIC, m);
        method.addInstruction(Opcode.CHECKCAST, dest);
    }

    private void compileArrowArgument(Context context, MethodInfo method, Flags flags, ArrowExpression expression) {
        MethodType target = this.getType(context);
        IMethodDeclaration decl = target.getMethod();
        ParameterList parameters = decl.getParameters();
        InterfaceType intf = new InterfaceType(parameters, decl.getReturnType());
        String innerClassName = this.compileArrowExpressionInnerClass(context, method.getClassFile(), intf, expression);
        this.compileNewArrowExpressionInstance(context, method, flags, innerClassName, expression);
    }

    private void compileNewArrowExpressionInstance(Context context, MethodInfo method, Flags flags, String innerClassName, ArrowExpression expression) {
        NamedType innerType = new NamedType(innerClassName);
        CompilerUtils.compileNewInstance(method, innerType);
    }

    private String compileArrowExpressionInnerClass(Context context, ClassFile parentClass, InterfaceType interfaceType, ArrowExpression expression) {
        int innerClassIndex = 1 + parentClass.getInnerClasses().size();
        String innerClassName = parentClass.getThisClass().getType().getTypeName() + '$' + innerClassIndex;
        ClassFile classFile = new ClassFile(new NamedType(innerClassName));
        classFile.setSuperClass(new ClassConstant((Type)((Object)Object.class)));
        classFile.addInterface(new ClassConstant(interfaceType.getInterfaceType()));
        CompilerUtils.compileEmptyConstructor(classFile);
        this.compileInnerClassProxyMethod(context, classFile, interfaceType);
        this.compileInnerClassArrowMethod(context, classFile, expression);
        parentClass.addInnerClass(classFile);
        return innerClassName;
    }

    private void compileInnerClassProxyMethod(Context context, ClassFile classFile, InterfaceType interfaceType) {
        MethodType target = this.getType(context);
        IMethodDeclaration declaration = target.getMethod();
        Type[] paramTypes = declaration.getParameters().stream().filter(a -> !(a instanceof CodeParameter)).map(arg -> Object.class).collect(Collectors.toList()).toArray(new Type[0]);
        Class<Object> returnType = declaration.getReturnType() == VoidType.instance() ? Void.TYPE : Object.class;
        Descriptor.Method proto = new Descriptor.Method(paramTypes, (Type)returnType);
        MethodInfo method = classFile.newMethod(interfaceType.getInterfaceMethodName(), proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        declaration.getParameters().forEach(param -> {
            ClassConstant classConstant = new ClassConstant((Type)((Object)Object.class));
            method.registerLocal(param.getName(), IVerifierEntry.VerifierType.ITEM_Object, classConstant);
        });
        this.produceInnerClassProxyByteCode(context, method, declaration);
    }

    private void produceInnerClassProxyByteCode(Context context, MethodInfo method, IMethodDeclaration declaration) {
        method.addInstruction(Opcode.ALOAD_0, method.getClassFile().getThisClass());
        declaration.getParameters().forEach(param -> {
            StackLocal local = method.getRegisteredLocal(param.getName());
            CompilerUtils.compileALOAD(method, local);
            Type type = param.getJavaType(context);
            if (type != Object.class) {
                method.addInstruction(Opcode.CHECKCAST, new ClassConstant(type));
            }
        });
        Descriptor.Method descriptor = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), declaration.getReturnType());
        MethodConstant constant = new MethodConstant(method.getClassFile().getThisClass(), declaration.getName(), descriptor);
        method.addInstruction(Opcode.INVOKEVIRTUAL, constant);
        if (declaration.getReturnType() == VoidType.instance()) {
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        } else {
            method.addInstruction(Opcode.ARETURN, new IOperand[0]);
        }
    }

    private void compileInnerClassArrowMethod(Context context, ClassFile classFile, ArrowExpression expression) {
        MethodType target = this.getType(context);
        IMethodDeclaration declaration = target.getMethod();
        Descriptor.Method proto = CompilerUtils.createMethodDescriptor(context, declaration.getParameters(), declaration.getReturnType());
        MethodInfo method = classFile.newMethod(declaration.getName(), proto);
        method.registerLocal("this", IVerifierEntry.VerifierType.ITEM_Object, classFile.getThisClass());
        declaration.getParameters().forEach(param -> param.registerLocal(context, method, new Flags()));
        this.produceInnerClassArrowByteCode(context, method, expression, declaration.getReturnType() == VoidType.instance());
    }

    private void produceInnerClassArrowByteCode(Context context, MethodInfo method, ArrowExpression expression, boolean isVoid) {
        expression.compile(context, method, new Flags());
        if (isVoid) {
            method.addInstruction(Opcode.RETURN, new IOperand[0]);
        }
    }

    @Override
    public void declare(Transpiler transpiler) {
    }

    @Override
    public String getTranspiledName(Context context) {
        IMethodDeclaration method = this.getDeclaration(context);
        return method.getTranspiledName(context);
    }

    @Override
    public void transpileCall(Transpiler transpiler, IExpression expression) {
        if (!this.transpileArrowExpressionCall(transpiler, expression)) {
            expression.transpile(transpiler);
        }
    }

    private boolean transpileArrowExpressionCall(Transpiler transpiler, IExpression expression) {
        if (expression instanceof ContextualExpression) {
            expression = ((ContextualExpression)expression).getExpression();
        }
        if (expression instanceof ArrowExpression) {
            MethodType target = this.getType(transpiler.getContext());
            target.transpileArrowExpression(transpiler, (ArrowExpression)expression);
            return true;
        }
        return false;
    }
}

