/*
 * Decompiled with CFR 0.152.
 */
package prompto.param;

import java.lang.reflect.Type;
import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.compiler.StackLocal;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.IDeclaration;
import prompto.error.SyntaxError;
import prompto.expression.IExpression;
import prompto.grammar.ArgumentList;
import prompto.grammar.Identifier;
import prompto.param.AttributeParameter;
import prompto.param.BaseParameter;
import prompto.param.INamedParameter;
import prompto.param.MethodParameter;
import prompto.parser.Dialect;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.IType;
import prompto.utils.CodeWriter;
import prompto.value.IValue;

public class UnresolvedParameter
extends BaseParameter
implements INamedParameter {
    INamedParameter resolved = null;

    public UnresolvedParameter(Identifier id) {
        super(id);
    }

    public INamedParameter getResolved() {
        return this.resolved;
    }

    @Override
    public String getSignature(Dialect dialect) {
        return this.getId().toString();
    }

    @Override
    public void toDialect(CodeWriter writer) {
        writer.append(this.id);
        if (this.defaultExpression != null) {
            writer.append(" = ");
            this.defaultExpression.toDialect(writer);
        }
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public void check(Context context) {
        this.resolve(context);
        this.resolved.check(context);
    }

    @Override
    public String getProto() {
        return this.id.toString();
    }

    @Override
    public IType getType(Context context) {
        this.resolve(context);
        return this.resolved.getType(context);
    }

    @Override
    public void register(Context context) {
        this.resolve(context);
        this.resolved.register(context);
    }

    @Override
    public IValue checkValue(Context context, IExpression value) {
        this.resolve(context);
        return this.resolved.checkValue(context, value);
    }

    private void resolve(Context context) {
        if (this.resolved != null) {
            return;
        }
        IDeclaration named = context.getRegisteredDeclaration(IDeclaration.class, this.id);
        if (named instanceof AttributeDeclaration) {
            this.resolved = new AttributeParameter(this.id);
        } else if (named instanceof Context.MethodDeclarationMap) {
            this.resolved = new MethodParameter(this.id);
        } else {
            throw new SyntaxError("Unknown identifier: " + this.id);
        }
    }

    @Override
    public Type getJavaType(Context context) {
        this.resolve(context);
        return this.resolved.getJavaType(context);
    }

    @Override
    public StackLocal registerLocal(Context context, MethodInfo method, Flags flags) {
        this.resolve(context);
        return this.resolved.registerLocal(context, method, flags);
    }

    @Override
    public void extractLocal(Context context, MethodInfo method, Flags flags) {
        this.resolve(context);
        this.resolved.extractLocal(context, method, flags);
    }

    @Override
    public void compileParameter(Context context, MethodInfo method, Flags flags, ArgumentList assignments, boolean isFirst) {
        this.resolve(context);
        this.resolved.compileParameter(context, method, flags, assignments, isFirst);
    }

    @Override
    public String getTranspiledName(Context context) {
        this.resolve(context);
        return this.resolved.getTranspiledName(context);
    }

    @Override
    public void declare(Transpiler transpiler) {
        this.resolve(transpiler.getContext());
        this.resolved.declare(transpiler);
    }

    @Override
    public void transpile(Transpiler transpiler) {
        this.resolve(transpiler.getContext());
        this.resolved.transpile(transpiler);
    }

    @Override
    public void transpileCall(Transpiler transpiler, IExpression expression) {
        this.resolve(transpiler.getContext());
        this.resolved.transpileCall(transpiler, expression);
    }
}

