/*
 * Decompiled with CFR 0.152.
 */
package prompto.parser;

import prompto.compiler.Flags;
import prompto.compiler.MethodInfo;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.expression.EqualsExpression;
import prompto.expression.IAssertion;
import prompto.expression.IExpression;
import prompto.parser.Dialect;
import prompto.parser.ISection;
import prompto.parser.Section;
import prompto.runtime.Context;
import prompto.transpiler.Transpiler;
import prompto.type.BooleanType;
import prompto.type.IType;
import prompto.utils.CodeWriter;

public class Assertion
extends Section {
    IExpression expression;

    public Assertion(IExpression expression) {
        this.expression = expression;
    }

    public void toDialect(CodeWriter writer) {
        this.expression.toDialect(writer);
    }

    public Context check(Context context) {
        IType type = this.expression.check(context);
        if (type != BooleanType.instance()) {
            context.getProblemListener().reportIllegalAssignment((ISection)this, BooleanType.instance(), type);
        }
        if (this.expression instanceof EqualsExpression) {
            context = ((EqualsExpression)this.expression).downCastForCheck(context);
        }
        return context;
    }

    public boolean interpret(Context context, TestMethodDeclaration test) throws PromptoError {
        return ((IAssertion)((Object)this.expression)).interpretAssert(context, test);
    }

    public void compile(Context context, MethodInfo method, Flags flags, TestMethodDeclaration test) {
        ((IAssertion)((Object)this.expression)).compileAssert(context, method, flags, test);
    }

    public void declare(Transpiler transpiler) {
        this.expression.declare(transpiler);
    }

    public void transpile(Transpiler transpiler) {
        this.expression.transpile(transpiler);
    }

    public String getExpected(Context context, Dialect dialect, int escapeMode) {
        CodeWriter writer = new CodeWriter(dialect, context, escapeMode);
        this.expression.toDialect(writer);
        return writer.toString();
    }

    public void transpileFound(Transpiler transpiler, Dialect dialect) {
        this.expression.transpileFound(transpiler, dialect);
    }
}

