/*
 * Decompiled with CFR 0.152.
 */
package prompto.parser;

import org.antlr.v4.runtime.Token;
import prompto.parser.ILocation;

public class Location
implements ILocation {
    int tokenIndex;
    int line;
    int column;

    public Location() {
    }

    public Location(Token token) {
        this(token, false);
    }

    public Location(Token token, boolean isEnd) {
        this.tokenIndex = token.getStartIndex();
        this.line = token.getLine();
        this.column = token.getCharPositionInLine();
        if (isEnd && token.getText() != null) {
            this.tokenIndex += token.getText().length();
            this.column += token.getText().length();
        }
    }

    public Location(ILocation location) {
        if (location == null) {
            location = null;
        }
        this.tokenIndex = location.getTokenIndex();
        this.line = location.getLine();
        this.column = location.getColumn();
    }

    public Location(int index, int line, int column) {
        this.tokenIndex = index;
        this.line = line;
        this.column = column;
    }

    public void setTokenIndex(int index) {
        this.tokenIndex = index;
    }

    @Override
    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public boolean isNotAfter(ILocation other) {
        return this.line < other.getLine() || this.line == other.getLine() && this.column <= other.getColumn();
    }

    public boolean isNotBefore(ILocation other) {
        return this.line > other.getLine() || this.line == other.getLine() && this.column >= other.getColumn();
    }
}

