/*
 * Decompiled with CFR 0.152.
 */
package prompto.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Token;
import prompto.parser.Dialect;
import prompto.parser.ILexer;
import prompto.parser.MLexer;
import prompto.problem.IProblemListener;

public class MIndentingLexer
extends MLexer
implements ILexer {
    IProblemListener problemListener;
    List<Token> tokens = new LinkedList<Token>();
    Stack<Integer> indents = new Stack();
    boolean wasLF = false;
    boolean addLF = true;

    public MIndentingLexer(CharStream input) {
        super(input);
        this.indents.push(0);
    }

    @Override
    public void setProblemListener(IProblemListener problemListener) {
        this.removeErrorListeners();
        if (problemListener != null) {
            this.addErrorListener((ANTLRErrorListener)problemListener);
        }
        this.problemListener = problemListener;
    }

    @Override
    public void reset(InputStream input) throws IOException {
        this.setInputStream((IntStream)CharStreams.fromStream((InputStream)input));
        this.tokens = new LinkedList<Token>();
        this.indents = new Stack();
        this.wasLF = false;
        this.indents.push(0);
    }

    public void setAddLF(boolean addLF) {
        this.addLF = addLF;
    }

    @Override
    public Dialect getDialect() {
        return Dialect.E;
    }

    @Override
    public Token nextToken() {
        Token t = this.getNextToken();
        this.wasLF = t.getType() == 5;
        return t;
    }

    private Token getNextToken() {
        if (this.tokens.size() > 0) {
            return this.tokens.remove(0);
        }
        this.interpret(super.nextToken());
        return this.nextToken();
    }

    void interpret(Token token) {
        switch (token.getType()) {
            case -1: {
                this.interpretEOF(token);
                break;
            }
            case 3: {
                this.interpretLFTAB(token);
                break;
            }
            default: {
                this.interpretAnyToken(token);
            }
        }
    }

    void interpretEOF(Token eof) {
        while (this.indents.size() > 1) {
            this.tokens.add((Token)this.deriveToken(eof, 2));
            this.tokens.add((Token)this.deriveToken(eof, 5));
            this.wasLF = true;
            this.indents.pop();
        }
        if (!this.wasLF && this.addLF) {
            this.tokens.add((Token)this.deriveToken(eof, 5));
        }
        this.tokens.add(eof);
    }

    void interpretLFTAB(Token lftab) {
        int indentCount = this.countIndents(lftab.getText());
        Token next = super.nextToken();
        if (next.getType() == -1 || next.getType() == 3) {
            this.tokens.add((Token)this.deriveToken(lftab, 5));
            this.interpret(next);
        } else if (indentCount == this.indents.peek()) {
            this.tokens.add((Token)this.deriveToken(lftab, 5));
            this.interpret(next);
        } else if (indentCount > this.indents.peek()) {
            this.tokens.add((Token)this.deriveToken(lftab, 5));
            this.tokens.add((Token)this.deriveToken(lftab, 1));
            this.indents.push(indentCount);
            this.interpret(next);
        } else {
            while (this.indents.size() > 1 && indentCount < this.indents.peek()) {
                this.tokens.add((Token)this.deriveToken(lftab, 2));
                this.tokens.add((Token)this.deriveToken(lftab, 5));
                this.indents.pop();
            }
            if (indentCount > this.indents.peek()) {
                // empty if block
            }
            this.interpret(next);
        }
    }

    private CommonToken deriveToken(Token token, int type) {
        CommonToken res = new CommonToken(token);
        res.setType(type);
        return res;
    }

    private int countIndents(String text) {
        int count = 0;
        block4: for (char c : text.toCharArray()) {
            switch (c) {
                case ' ': {
                    ++count;
                    continue block4;
                }
                case '\t': {
                    count += 4;
                }
            }
        }
        return count / 4;
    }

    void interpretAnyToken(Token token) {
        this.tokens.add(token);
    }
}

