/*
 * Decompiled with CFR 0.152.
 */
package prompto.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import prompto.constraint.IAttributeConstraint;
import prompto.constraint.MatchingCollectionConstraint;
import prompto.constraint.MatchingExpressionConstraint;
import prompto.constraint.MatchingPatternConstraint;
import prompto.csharp.CSharpBooleanLiteral;
import prompto.csharp.CSharpCharacterLiteral;
import prompto.csharp.CSharpDecimalLiteral;
import prompto.csharp.CSharpExpression;
import prompto.csharp.CSharpExpressionList;
import prompto.csharp.CSharpIdentifierExpression;
import prompto.csharp.CSharpIntegerLiteral;
import prompto.csharp.CSharpMethodExpression;
import prompto.csharp.CSharpNativeCall;
import prompto.csharp.CSharpNativeCategoryBinding;
import prompto.csharp.CSharpSelectorExpression;
import prompto.csharp.CSharpStatement;
import prompto.csharp.CSharpTextLiteral;
import prompto.csharp.CSharpThisExpression;
import prompto.css.CssCode;
import prompto.css.CssExpression;
import prompto.css.CssField;
import prompto.css.CssText;
import prompto.css.ICssValue;
import prompto.declaration.AbstractMethodDeclaration;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.ConcreteWidgetDeclaration;
import prompto.declaration.DeclarationList;
import prompto.declaration.EnumeratedCategoryDeclaration;
import prompto.declaration.EnumeratedNativeDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.NativeGetterMethodDeclaration;
import prompto.declaration.NativeMethodDeclaration;
import prompto.declaration.NativeResourceDeclaration;
import prompto.declaration.NativeSetterMethodDeclaration;
import prompto.declaration.NativeWidgetDeclaration;
import prompto.declaration.OperatorMethodDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.declaration.SingletonCategoryDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.expression.AndExpression;
import prompto.expression.ArrowExpression;
import prompto.expression.BlobExpression;
import prompto.expression.CastExpression;
import prompto.expression.CategorySymbol;
import prompto.expression.CodeExpression;
import prompto.expression.CompareExpression;
import prompto.expression.ConstructorExpression;
import prompto.expression.ContainsExpression;
import prompto.expression.DivideExpression;
import prompto.expression.DocumentExpression;
import prompto.expression.EqualsExpression;
import prompto.expression.ExecuteExpression;
import prompto.expression.FetchManyExpression;
import prompto.expression.FetchOneExpression;
import prompto.expression.FilteredExpression;
import prompto.expression.IExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.IntDivideExpression;
import prompto.expression.ItemSelector;
import prompto.expression.IteratorExpression;
import prompto.expression.MemberSelector;
import prompto.expression.MethodExpression;
import prompto.expression.MinusExpression;
import prompto.expression.ModuloExpression;
import prompto.expression.MultiplyExpression;
import prompto.expression.MutableExpression;
import prompto.expression.NativeSymbol;
import prompto.expression.NotExpression;
import prompto.expression.OrExpression;
import prompto.expression.ParenthesisExpression;
import prompto.expression.PlusExpression;
import prompto.expression.ReadAllExpression;
import prompto.expression.ReadBlobExpression;
import prompto.expression.ReadOneExpression;
import prompto.expression.SelectorExpression;
import prompto.expression.SliceSelector;
import prompto.expression.SortedExpression;
import prompto.expression.SubtractExpression;
import prompto.expression.SuperExpression;
import prompto.expression.SymbolExpression;
import prompto.expression.TernaryExpression;
import prompto.expression.ThisExpression;
import prompto.expression.TypeExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.expression.UnresolvedSelector;
import prompto.grammar.Annotation;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.CategorySymbolList;
import prompto.grammar.CmpOp;
import prompto.grammar.ContOp;
import prompto.grammar.EqOp;
import prompto.grammar.Identifier;
import prompto.grammar.MethodDeclarationList;
import prompto.grammar.NativeCategoryBinding;
import prompto.grammar.NativeCategoryBindingList;
import prompto.grammar.NativeSymbolList;
import prompto.grammar.Operator;
import prompto.grammar.OrderByClause;
import prompto.grammar.OrderByClauseList;
import prompto.grammar.ParameterList;
import prompto.instance.IAssignableInstance;
import prompto.instance.IAssignableSelector;
import prompto.instance.ItemInstance;
import prompto.instance.MemberInstance;
import prompto.instance.VariableInstance;
import prompto.java.JavaBooleanLiteral;
import prompto.java.JavaCharacterLiteral;
import prompto.java.JavaDecimalLiteral;
import prompto.java.JavaExpression;
import prompto.java.JavaExpressionList;
import prompto.java.JavaIdentifierExpression;
import prompto.java.JavaIntegerLiteral;
import prompto.java.JavaItemExpression;
import prompto.java.JavaMethodExpression;
import prompto.java.JavaNativeCall;
import prompto.java.JavaNativeCategoryBinding;
import prompto.java.JavaSelectorExpression;
import prompto.java.JavaStatement;
import prompto.java.JavaTextLiteral;
import prompto.java.JavaThisExpression;
import prompto.javascript.JavaScriptBooleanLiteral;
import prompto.javascript.JavaScriptCharacterLiteral;
import prompto.javascript.JavaScriptDecimalLiteral;
import prompto.javascript.JavaScriptExpression;
import prompto.javascript.JavaScriptExpressionList;
import prompto.javascript.JavaScriptIdentifierExpression;
import prompto.javascript.JavaScriptIntegerLiteral;
import prompto.javascript.JavaScriptMemberExpression;
import prompto.javascript.JavaScriptMethodExpression;
import prompto.javascript.JavaScriptModule;
import prompto.javascript.JavaScriptNativeCall;
import prompto.javascript.JavaScriptNativeCategoryBinding;
import prompto.javascript.JavaScriptNewExpression;
import prompto.javascript.JavaScriptSelectorExpression;
import prompto.javascript.JavaScriptStatement;
import prompto.javascript.JavaScriptTextLiteral;
import prompto.javascript.JavaScriptThisExpression;
import prompto.jsx.IJsxExpression;
import prompto.jsx.IJsxValue;
import prompto.jsx.JsxClosing;
import prompto.jsx.JsxElement;
import prompto.jsx.JsxExpression;
import prompto.jsx.JsxFragment;
import prompto.jsx.JsxLiteral;
import prompto.jsx.JsxProperty;
import prompto.jsx.JsxSelfClosing;
import prompto.jsx.JsxText;
import prompto.literal.BooleanLiteral;
import prompto.literal.CharacterLiteral;
import prompto.literal.DateLiteral;
import prompto.literal.DateTimeLiteral;
import prompto.literal.DecimalLiteral;
import prompto.literal.DictEntry;
import prompto.literal.DictEntryList;
import prompto.literal.DictIdentifierKey;
import prompto.literal.DictKey;
import prompto.literal.DictLiteral;
import prompto.literal.DictTextKey;
import prompto.literal.DocEntryList;
import prompto.literal.DocumentLiteral;
import prompto.literal.HexaLiteral;
import prompto.literal.IntegerLiteral;
import prompto.literal.ListLiteral;
import prompto.literal.MaxIntegerLiteral;
import prompto.literal.MinIntegerLiteral;
import prompto.literal.NullLiteral;
import prompto.literal.PeriodLiteral;
import prompto.literal.RangeLiteral;
import prompto.literal.SetLiteral;
import prompto.literal.TextLiteral;
import prompto.literal.TimeLiteral;
import prompto.literal.TupleLiteral;
import prompto.literal.TypeLiteral;
import prompto.literal.UuidLiteral;
import prompto.literal.VersionLiteral;
import prompto.param.CategoryParameter;
import prompto.param.CodeParameter;
import prompto.param.ExtendedParameter;
import prompto.param.IParameter;
import prompto.param.UnresolvedParameter;
import prompto.parser.Assertion;
import prompto.parser.Dialect;
import prompto.parser.MCleverParser;
import prompto.parser.MParser;
import prompto.parser.MParserBaseListener;
import prompto.parser.ParserUtils;
import prompto.parser.Section;
import prompto.python.Python2NativeCall;
import prompto.python.Python2NativeCategoryBinding;
import prompto.python.Python3NativeCall;
import prompto.python.Python3NativeCategoryBinding;
import prompto.python.PythonArgumentList;
import prompto.python.PythonBooleanLiteral;
import prompto.python.PythonCharacterLiteral;
import prompto.python.PythonDecimalLiteral;
import prompto.python.PythonExpression;
import prompto.python.PythonIdentifierExpression;
import prompto.python.PythonIntegerLiteral;
import prompto.python.PythonMethodExpression;
import prompto.python.PythonModule;
import prompto.python.PythonNamedArgument;
import prompto.python.PythonNativeCategoryBinding;
import prompto.python.PythonOrdinalArgument;
import prompto.python.PythonSelectorExpression;
import prompto.python.PythonSelfExpression;
import prompto.python.PythonStatement;
import prompto.python.PythonTextLiteral;
import prompto.statement.AssignInstanceStatement;
import prompto.statement.AssignTupleStatement;
import prompto.statement.AssignVariableStatement;
import prompto.statement.AtomicSwitchCase;
import prompto.statement.BaseSwitchStatement;
import prompto.statement.BreakStatement;
import prompto.statement.CollectionSwitchCase;
import prompto.statement.CommentStatement;
import prompto.statement.DeclarationStatement;
import prompto.statement.DoWhileStatement;
import prompto.statement.FetchManyStatement;
import prompto.statement.FetchOneStatement;
import prompto.statement.FlushStatement;
import prompto.statement.ForEachStatement;
import prompto.statement.IStatement;
import prompto.statement.IfStatement;
import prompto.statement.RaiseStatement;
import prompto.statement.RemoteCall;
import prompto.statement.ReturnStatement;
import prompto.statement.StatementList;
import prompto.statement.StoreStatement;
import prompto.statement.SwitchCase;
import prompto.statement.SwitchErrorStatement;
import prompto.statement.SwitchStatement;
import prompto.statement.UnresolvedCall;
import prompto.statement.WhileStatement;
import prompto.statement.WithResourceStatement;
import prompto.statement.WithSingletonStatement;
import prompto.statement.WriteStatement;
import prompto.type.AnyType;
import prompto.type.BlobType;
import prompto.type.BooleanType;
import prompto.type.CategoryType;
import prompto.type.CharacterType;
import prompto.type.CodeType;
import prompto.type.CssType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.DictType;
import prompto.type.DocumentType;
import prompto.type.HtmlType;
import prompto.type.IType;
import prompto.type.ImageType;
import prompto.type.IntegerType;
import prompto.type.IteratorType;
import prompto.type.ListType;
import prompto.type.NativeType;
import prompto.type.PeriodType;
import prompto.type.SetType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.UuidType;
import prompto.type.VersionType;
import prompto.utils.AssertionList;
import prompto.utils.ExpressionList;
import prompto.utils.IdentifierList;

public class MPromptoBuilder
extends MParserBaseListener {
    ParseTreeProperty<Object> nodeValues = new ParseTreeProperty();
    BufferedTokenStream input;
    String path = "";

    public MPromptoBuilder(MCleverParser parser) {
        this.input = (BufferedTokenStream)parser.getTokenStream();
        this.path = parser.getPath();
    }

    protected String getHiddenTokensBefore(Token token) {
        List hidden = this.input.getHiddenTokensToLeft(token.getTokenIndex());
        return this.getHiddenTokensText(hidden);
    }

    protected String getHiddenTokensAfter(Token token) {
        List hidden = this.input.getHiddenTokensToRight(token.getTokenIndex());
        return this.getHiddenTokensText(hidden);
    }

    private String getHiddenTokensText(List<Token> hidden) {
        if (hidden == null || hidden.isEmpty()) {
            return null;
        }
        return hidden.stream().map(Token::getText).collect(Collectors.joining());
    }

    private String getWhiteSpacePlus(ParserRuleContext ctx) {
        String after;
        String within;
        String string = within = ctx.children == null ? null : ctx.children.stream().filter(child -> MPromptoBuilder.isNotIndent(child)).map(child -> child.getText()).collect(Collectors.joining());
        if (within == null) {
            return null;
        }
        String before = this.getHiddenTokensBefore(ctx.getStart());
        if (before != null) {
            within = before + within;
        }
        if ((after = this.getHiddenTokensAfter(ctx.getStop())) != null) {
            within = within + after;
        }
        return within;
    }

    private static boolean isNotIndent(ParseTree tree) {
        return !(tree instanceof TerminalNode) || ((TerminalNode)tree).getSymbol().getType() != 1;
    }

    public void buildSection(ParserRuleContext node, Section section) {
        Token first = this.findFirstValidToken(node.start.getTokenIndex());
        Token last = this.findLastValidToken(node.stop.getTokenIndex());
        section.setFrom(this.path, first, last, Dialect.M);
    }

    private List<Annotation> readAnnotations(List<? extends ParseTree> contexts) {
        List<Annotation> annotations = contexts.stream().map(cx -> (Annotation)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        return annotations.isEmpty() ? null : annotations;
    }

    private List<CommentStatement> readComments(List<? extends ParseTree> contexts) {
        List<CommentStatement> comments = contexts.stream().map(cx -> (CommentStatement)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        return comments.isEmpty() ? null : comments;
    }

    @Override
    public void exitAbstract_method_declaration(MParser.Abstract_method_declarationContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        if (type instanceof CategoryType) {
            ((CategoryType)type).setMutable(ctx.MUTABLE() != null);
        }
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ParameterList args = (ParameterList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new AbstractMethodDeclaration(name, args, type));
    }

    @Override
    public void exitAddExpression(MParser.AddExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        IExpression exp = ctx.op.getType() == 32 ? new PlusExpression(left, right) : new SubtractExpression(left, right);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitAndExpression(MParser.AndExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new AndExpression(left, right));
    }

    @Override
    public void exitAnnotation_constructor(MParser.Annotation_constructorContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        DictEntryList args = new DictEntryList();
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        if (exp != null) {
            args.add(new DictEntry(null, exp));
        }
        ctx.annotation_argument().forEach(argCtx -> {
            DictEntry arg = (DictEntry)this.getNodeValue((ParseTree)argCtx);
            args.add(arg);
        });
        this.setNodeValue(ctx, new Annotation(name, args));
    }

    @Override
    public void exitAnnotation_argument(MParser.Annotation_argumentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new DictEntry(new DictIdentifierKey(name), exp));
    }

    @Override
    public void exitAnnotation_identifier(MParser.Annotation_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitAnnotation_argument_name(MParser.Annotation_argument_nameContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitAnnotationLiteralValue(MParser.AnnotationLiteralValueContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitAnnotationTypeValue(MParser.AnnotationTypeValueContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        this.setNodeValue((ParseTree)ctx, new TypeExpression(type));
    }

    @Override
    public void exitAnyDictType(MParser.AnyDictTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.any_type());
        this.setNodeValue(ctx, new DictType(type));
    }

    @Override
    public void exitAnyListType(MParser.AnyListTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.any_type());
        this.setNodeValue(ctx, new ListType(type));
    }

    @Override
    public void exitAnyType(MParser.AnyTypeContext ctx) {
        this.setNodeValue(ctx, AnyType.instance());
    }

    @Override
    public void exitArgument_assignment(MParser.Argument_assignmentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        UnresolvedParameter arg = new UnresolvedParameter(name);
        Argument item = new Argument(arg, exp);
        this.setNodeValue((ParseTree)ctx, item);
    }

    @Override
    public void exitArgument_list(MParser.Argument_listContext ctx) {
        ParameterList items = new ParameterList();
        ctx.argument().forEach(a -> {
            IParameter item = (IParameter)this.getNodeValue((ParseTree)a);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitArgumentAssignmentList(MParser.ArgumentAssignmentListContext ctx) {
        Argument item = (Argument)this.getNodeValue((ParseTree)ctx.item);
        ArgumentList items = new ArgumentList((Collection<Argument>)Collections.singletonList(item));
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitArgumentAssignmentListItem(MParser.ArgumentAssignmentListItemContext ctx) {
        Argument item = (Argument)this.getNodeValue((ParseTree)ctx.item);
        ArgumentList items = (ArgumentList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitArrow_prefix(MParser.Arrow_prefixContext ctx) {
        String arrowSuite;
        IdentifierList args = (IdentifierList)this.getNodeValue((ParseTree)ctx.arrow_args());
        String argsSuite = this.getWhiteSpacePlus(ctx.s1);
        if (argsSuite == null) {
            argsSuite = this.getHiddenTokensBefore(ctx.EGT().getSymbol());
        }
        if ((arrowSuite = this.getWhiteSpacePlus(ctx.s2)) == null) {
            arrowSuite = this.getHiddenTokensAfter(ctx.EGT().getSymbol());
        }
        this.setNodeValue(ctx, new ArrowExpression(args, argsSuite, arrowSuite));
    }

    @Override
    public void exitArrowExpression(MParser.ArrowExpressionContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.exp));
    }

    @Override
    public void exitArrowExpressionBody(MParser.ArrowExpressionBodyContext ctx) {
        ArrowExpression arrow = (ArrowExpression)this.getNodeValue((ParseTree)ctx.arrow_prefix());
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        arrow.setExpression(exp);
        this.setNodeValue(ctx, arrow);
    }

    @Override
    public void exitArrowListArg(MParser.ArrowListArgContext ctx) {
        IdentifierList list = (IdentifierList)this.getNodeValue((ParseTree)ctx.variable_identifier_list());
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitArrowSingleArg(MParser.ArrowSingleArgContext ctx) {
        Identifier arg = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        this.setNodeValue((ParseTree)ctx, new IdentifierList(arg));
    }

    @Override
    public void exitArrowStatementsBody(MParser.ArrowStatementsBodyContext ctx) {
        ArrowExpression arrow = (ArrowExpression)this.getNodeValue((ParseTree)ctx.arrow_prefix());
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.statement_list());
        arrow.setStatements(stmts);
        this.setNodeValue(ctx, arrow);
    }

    @Override
    public void exitAssertion(MParser.AssertionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new Assertion(exp));
    }

    @Override
    public void exitAssertion_list(MParser.Assertion_listContext ctx) {
        AssertionList items = new AssertionList();
        ctx.assertion().forEach(a -> {
            Assertion item = (Assertion)this.getNodeValue((ParseTree)a);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitAssign_instance_statement(MParser.Assign_instance_statementContext ctx) {
        IAssignableInstance inst = (IAssignableInstance)this.getNodeValue((ParseTree)ctx.inst);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new AssignInstanceStatement(inst, exp));
    }

    @Override
    public void exitAssign_tuple_statement(MParser.Assign_tuple_statementContext ctx) {
        IdentifierList items = (IdentifierList)this.getNodeValue((ParseTree)ctx.items);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new AssignTupleStatement(items, exp));
    }

    @Override
    public void exitAssign_variable_statement(MParser.Assign_variable_statementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue(ctx, new AssignVariableStatement(name, exp));
    }

    @Override
    public void exitAssignInstanceStatement(MParser.AssignInstanceStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitAssignTupleStatement(MParser.AssignTupleStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitAtomicSwitchCase(MParser.AtomicSwitchCaseContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new AtomicSwitchCase(exp, stmts));
    }

    @Override
    public void exitAttribute_declaration(MParser.Attribute_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        IAttributeConstraint match = (IAttributeConstraint)this.getNodeValue((ParseTree)ctx.match);
        IdentifierList indices = ctx.index_clause() != null ? (IdentifierList)this.getNodeValue((ParseTree)ctx.index_clause()) : null;
        AttributeDeclaration decl = new AttributeDeclaration(name, type, match, indices);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitIndex_clause(MParser.Index_clauseContext ctx) {
        IdentifierList indices = ctx.indices != null ? (IdentifierList)this.getNodeValue((ParseTree)ctx.indices) : new IdentifierList();
        this.setNodeValue((ParseTree)ctx, indices);
    }

    @Override
    public void exitAttribute_identifier(MParser.Attribute_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitAttribute_identifier_list(MParser.Attribute_identifier_listContext ctx) {
        IdentifierList list = new IdentifierList();
        for (MParser.Attribute_identifierContext v : ctx.attribute_identifier()) {
            Identifier item = (Identifier)this.getNodeValue((ParseTree)v);
            list.add(item);
        }
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitBlob_expression(MParser.Blob_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue((ParseTree)ctx, new BlobExpression(exp));
    }

    @Override
    public void exitBlobType(MParser.BlobTypeContext ctx) {
        this.setNodeValue(ctx, BlobType.instance());
    }

    @Override
    public void exitBooleanLiteral(MParser.BooleanLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new BooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitBooleanType(MParser.BooleanTypeContext ctx) {
        this.setNodeValue(ctx, BooleanType.instance());
    }

    @Override
    public void exitBreakStatement(MParser.BreakStatementContext ctx) {
        this.setNodeValue(ctx, new BreakStatement());
    }

    @Override
    public void exitCastExpression(MParser.CastExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IType type = (IType)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new CastExpression(left, type, ctx.MUTABLE() != null));
    }

    @Override
    public void exitCatch_statement_list(MParser.Catch_statement_listContext ctx) {
        BaseSwitchStatement.SwitchCaseList items = new BaseSwitchStatement.SwitchCaseList();
        ctx.catch_statement().forEach(s -> {
            SwitchCase item = (SwitchCase)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCatchAtomicStatement(MParser.CatchAtomicStatementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new AtomicSwitchCase(new SymbolExpression(name), stmts));
    }

    @Override
    public void exitCatchCollectionStatement(MParser.CatchCollectionStatementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new CollectionSwitchCase(exp, stmts));
    }

    @Override
    public void exitCategory_or_any_type(MParser.Category_or_any_typeContext ctx) {
        IType type = (IType)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitCategory_symbol(MParser.Category_symbolContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new CategorySymbol(name, args));
    }

    @Override
    public void exitCategory_symbol_list(MParser.Category_symbol_listContext ctx) {
        CategorySymbolList items = new CategorySymbolList();
        ctx.category_symbol().forEach(s -> {
            CategorySymbol item = (CategorySymbol)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCategory_type(MParser.Category_typeContext ctx) {
        Identifier name = new Identifier(ctx.getText());
        this.setNodeValue(ctx, new CategoryType(name));
    }

    @Override
    public void exitCategoryType(MParser.CategoryTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.c);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitCharacterLiteral(MParser.CharacterLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitCharacterType(MParser.CharacterTypeContext ctx) {
        this.setNodeValue(ctx, CharacterType.instance());
    }

    @Override
    public void exitChildInstance(MParser.ChildInstanceContext ctx) {
        IAssignableInstance parent = (IAssignableInstance)this.getNodeValue((ParseTree)ctx.assignable_instance());
        IAssignableSelector child = (IAssignableSelector)this.getNodeValue((ParseTree)ctx.child_instance());
        child.setParent(parent);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitClosure_expression(MParser.Closure_expressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new MethodExpression(name));
    }

    @Override
    public void exitClosureExpression(MParser.ClosureExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitClosureStatement(MParser.ClosureStatementContext ctx) {
        ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)this.getNodeValue((ParseTree)ctx.decl);
        this.setNodeValue(ctx, new DeclarationStatement<ConcreteMethodDeclaration>(decl));
    }

    @Override
    public void exitCode_argument(MParser.Code_argumentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new CodeParameter(name));
    }

    @Override
    public void exitCode_type(MParser.Code_typeContext ctx) {
        this.setNodeValue(ctx, CodeType.instance());
    }

    @Override
    public void exitCodeArgument(MParser.CodeArgumentContext ctx) {
        IParameter arg = (IParameter)this.getNodeValue((ParseTree)ctx.arg);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitCodeExpression(MParser.CodeExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CodeExpression(exp));
    }

    @Override
    public void exitCodeType(MParser.CodeTypeContext ctx) {
        this.setNodeValue(ctx, CodeType.instance());
    }

    @Override
    public void exitCollection_literal(MParser.Collection_literalContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCollectionSwitchCase(MParser.CollectionSwitchCaseContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new CollectionSwitchCase(exp, stmts));
    }

    @Override
    public void exitCommentStatement(MParser.CommentStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.comment_statement()));
    }

    @Override
    public void exitComment_statement(MParser.Comment_statementContext ctx) {
        this.setNodeValue(ctx, new CommentStatement(ctx.getText()));
    }

    @Override
    public void exitConcrete_category_declaration(MParser.Concrete_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        IdentifierList derived = (IdentifierList)this.getNodeValue((ParseTree)ctx.derived);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        ConcreteCategoryDeclaration decl = new ConcreteCategoryDeclaration(name, attrs, derived, methods);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitConcrete_method_declaration(MParser.Concrete_method_declarationContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        if (type instanceof CategoryType) {
            ((CategoryType)type).setMutable(ctx.MUTABLE() != null);
        }
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ParameterList args = (ParameterList)this.getNodeValue((ParseTree)ctx.args);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new ConcreteMethodDeclaration(name, args, type, stmts));
    }

    @Override
    public void exitConcrete_widget_declaration(MParser.Concrete_widget_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        Identifier derived = (Identifier)this.getNodeValue((ParseTree)ctx.derived);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        ConcreteWidgetDeclaration decl = new ConcreteWidgetDeclaration(name, derived, methods);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitConcreteCategoryDeclaration(MParser.ConcreteCategoryDeclarationContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.decl));
    }

    @Override
    public void exitConcreteWidgetDeclaration(MParser.ConcreteWidgetDeclarationContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.decl));
    }

    @Override
    public void exitConstructorFrom(MParser.ConstructorFromContext ctx) {
        CategoryType type = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression copyFrom = (IExpression)this.getNodeValue((ParseTree)ctx.copyExp);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new ConstructorExpression(type, copyFrom, args, true));
    }

    @Override
    public void exitConstructorNoFrom(MParser.ConstructorNoFromContext ctx) {
        CategoryType type = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new ConstructorExpression(type, null, args, true));
    }

    @Override
    public void exitCopy_from(MParser.Copy_fromContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.exp));
    }

    @Override
    public void exitCssType(MParser.CssTypeContext ctx) {
        this.setNodeValue(ctx, CssType.instance());
    }

    @Override
    public void exitHasExpression(MParser.HasExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.HAS, right));
    }

    @Override
    public void exitHasAllExpression(MParser.HasAllExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.HAS_ALL, right));
    }

    @Override
    public void exitHasAnyExpression(MParser.HasAnyExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.HAS_ANY, right));
    }

    @Override
    public void exitContainsExpression(MParser.ContainsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.CONTAINS, right));
    }

    @Override
    public void exitCsharp_identifier(MParser.Csharp_identifierContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitCsharp_method_expression(MParser.Csharp_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        CSharpExpressionList args = (CSharpExpressionList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue((ParseTree)ctx, new CSharpMethodExpression(name, args));
    }

    @Override
    public void exitCsharp_primary_expression(MParser.Csharp_primary_expressionContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCsharp_this_expression(MParser.Csharp_this_expressionContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpThisExpression());
    }

    @Override
    public void exitCSharpArgumentList(MParser.CSharpArgumentListContext ctx) {
        CSharpExpression item = (CSharpExpression)this.getNodeValue((ParseTree)ctx.item);
        this.setNodeValue((ParseTree)ctx, new CSharpExpressionList(item));
    }

    @Override
    public void exitCSharpArgumentListItem(MParser.CSharpArgumentListItemContext ctx) {
        CSharpExpression item = (CSharpExpression)this.getNodeValue((ParseTree)ctx.item);
        CSharpExpressionList items = (CSharpExpressionList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCSharpBooleanLiteral(MParser.CSharpBooleanLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpBooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpCategoryBinding(MParser.CSharpCategoryBindingContext ctx) {
        CSharpIdentifierExpression map = (CSharpIdentifierExpression)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new CSharpNativeCategoryBinding(map));
    }

    @Override
    public void exitCSharpCharacterLiteral(MParser.CSharpCharacterLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpCharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpChildIdentifier(MParser.CSharpChildIdentifierContext ctx) {
        CSharpIdentifierExpression parent = (CSharpIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        CSharpIdentifierExpression child = new CSharpIdentifierExpression(parent, name);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitCSharpDecimalLiteral(MParser.CSharpDecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpDecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpIdentifier(MParser.CSharpIdentifierContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new CSharpIdentifierExpression(name));
    }

    @Override
    public void exitCSharpIntegerLiteral(MParser.CSharpIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpIntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpMethodExpression(MParser.CSharpMethodExpressionContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCSharpNativeStatement(MParser.CSharpNativeStatementContext ctx) {
        CSharpStatement stmt = (CSharpStatement)this.getNodeValue((ParseTree)ctx.csharp_statement());
        this.setNodeValue(ctx, new CSharpNativeCall(stmt));
    }

    @Override
    public void exitCSharpPromptoIdentifier(MParser.CSharpPromptoIdentifierContext ctx) {
        String name = ctx.DOLLAR_IDENTIFIER().getText();
        this.setNodeValue((ParseTree)ctx, new CSharpIdentifierExpression(name));
    }

    @Override
    public void exitCSharpPrimaryExpression(MParser.CSharpPrimaryExpressionContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCSharpReturnStatement(MParser.CSharpReturnStatementContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CSharpStatement(exp, true));
    }

    @Override
    public void exitCSharpSelectorExpression(MParser.CSharpSelectorExpressionContext ctx) {
        CSharpExpression parent = (CSharpExpression)this.getNodeValue((ParseTree)ctx.parent);
        CSharpSelectorExpression child = (CSharpSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        child.setParent(parent);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitCSharpStatement(MParser.CSharpStatementContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CSharpStatement(exp, false));
    }

    @Override
    public void exitCSharpTextLiteral(MParser.CSharpTextLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpTextLiteral(ctx.getText()));
    }

    @Override
    public void exitCssExpression(MParser.CssExpressionContext ctx) {
        CssExpression exp = (CssExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, exp);
    }

    @Override
    public void exitCss_expression(MParser.Css_expressionContext ctx) {
        CssExpression exp = new CssExpression();
        ctx.css_field().forEach(cx -> {
            CssField field = (CssField)this.getNodeValue((ParseTree)cx);
            exp.addField(field);
        });
        this.setNodeValue(ctx, exp);
    }

    @Override
    public void exitCss_field(MParser.Css_fieldContext ctx) {
        String name = ctx.name.getText();
        ICssValue value = (ICssValue)this.getNodeValue((ParseTree)ctx.value);
        this.setNodeValue((ParseTree)ctx, new CssField(name, value));
    }

    @Override
    public void exitCssText(MParser.CssTextContext ctx) {
        String text = this.input.getText(ctx.text.start, ctx.text.stop);
        this.setNodeValue((ParseTree)ctx, new CssText(text));
    }

    @Override
    public void exitCssValue(MParser.CssValueContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CssCode(exp));
    }

    @Override
    public void exitDateLiteral(MParser.DateLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new DateLiteral(ctx.getText()));
    }

    @Override
    public void exitDateTimeLiteral(MParser.DateTimeLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new DateTimeLiteral(ctx.getText()));
    }

    @Override
    public void exitDateTimeType(MParser.DateTimeTypeContext ctx) {
        this.setNodeValue(ctx, DateTimeType.instance());
    }

    @Override
    public void exitDateType(MParser.DateTypeContext ctx) {
        this.setNodeValue(ctx, DateType.instance());
    }

    @Override
    public void exitDecimalLiteral(MParser.DecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new DecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitDecimalType(MParser.DecimalTypeContext ctx) {
        this.setNodeValue(ctx, DecimalType.instance());
    }

    @Override
    public void exitDeclaration(MParser.DeclarationContext ctx) {
        List<CommentStatement> comments = this.readComments(ctx.comment_statement());
        List<Annotation> annotations = this.readAnnotations(ctx.annotation_constructor());
        ParseTree ctx_ = ctx.getChild(ctx.getChildCount() - 1);
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx_);
        if (decl != null) {
            decl.setComments(comments);
            decl.setAnnotations(annotations);
            this.setNodeValue((ParseTree)ctx, decl);
        }
    }

    @Override
    public void exitDeclarations(MParser.DeclarationsContext ctx) {
        DeclarationList items = new DeclarationList();
        ctx.declaration().forEach(d -> {
            IDeclaration item = (IDeclaration)this.getNodeValue((ParseTree)d);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitDerived_list(MParser.Derived_listContext ctx) {
        IdentifierList items = (IdentifierList)this.getNodeValue((ParseTree)ctx.items);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitDict_entry(MParser.Dict_entryContext ctx) {
        DictKey key = (DictKey)this.getNodeValue((ParseTree)ctx.key);
        IExpression value = (IExpression)this.getNodeValue((ParseTree)ctx.value);
        DictEntry entry = new DictEntry(key, value);
        this.setNodeValue((ParseTree)ctx, entry);
    }

    @Override
    public void exitDict_literal(MParser.Dict_literalContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        DictEntryList items = (DictEntryList)this.getNodeValue((ParseTree)ctx.dict_entry_list());
        DictLiteral value = items == null ? new DictLiteral(mutable) : new DictLiteral(items, mutable);
        this.setNodeValue((ParseTree)ctx, value);
    }

    @Override
    public void exitDict_entry_list(MParser.Dict_entry_listContext ctx) {
        DictEntryList items = new DictEntryList();
        ctx.dict_entry().forEach(e -> {
            DictEntry item = (DictEntry)this.getNodeValue((ParseTree)e);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitDictKeyIdentifier(MParser.DictKeyIdentifierContext ctx) {
        String text = ctx.name.getText();
        this.setNodeValue(ctx, new DictIdentifierKey(new Identifier(text)));
    }

    @Override
    public void exitDictKeyText(MParser.DictKeyTextContext ctx) {
        String text = ctx.name.getText();
        this.setNodeValue(ctx, new DictTextKey(text));
    }

    @Override
    public void exitDictType(MParser.DictTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.d);
        this.setNodeValue(ctx, new DictType(type));
    }

    @Override
    public void exitDivideExpression(MParser.DivideExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new DivideExpression(left, right));
    }

    @Override
    public void exitDo_while_statement(MParser.Do_while_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new DoWhileStatement(exp, stmts));
    }

    @Override
    public void exitDocument_expression(MParser.Document_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue((ParseTree)ctx, new DocumentExpression(exp));
    }

    @Override
    public void exitDocumentType(MParser.DocumentTypeContext ctx) {
        this.setNodeValue(ctx, DocumentType.instance());
    }

    @Override
    public void exitDocument_literal(MParser.Document_literalContext ctx) {
        DictEntryList entries = (DictEntryList)this.getNodeValue((ParseTree)ctx.dict_entry_list());
        DocEntryList items = entries != null ? new DocEntryList(entries) : new DocEntryList();
        this.setNodeValue((ParseTree)ctx, new DocumentLiteral(items));
    }

    @Override
    public void exitDoWhileStatement(MParser.DoWhileStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitElseIfStatementList(MParser.ElseIfStatementListContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        IfStatement.IfElement elem = new IfStatement.IfElement(exp, stmts);
        this.setNodeValue((ParseTree)ctx, new IfStatement.IfElementList(elem));
    }

    @Override
    public void exitElseIfStatementListItem(MParser.ElseIfStatementListItemContext ctx) {
        IfStatement.IfElementList items = (IfStatement.IfElementList)this.getNodeValue((ParseTree)ctx.items);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        IfStatement.IfElement elem = new IfStatement.IfElement(exp, stmts);
        items.add(elem);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitEnum_category_declaration(MParser.Enum_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        Identifier parent = (Identifier)this.getNodeValue((ParseTree)ctx.derived);
        IdentifierList derived = parent == null ? null : new IdentifierList(parent);
        CategorySymbolList symbols = (CategorySymbolList)this.getNodeValue((ParseTree)ctx.symbols);
        this.setNodeValue(ctx, new EnumeratedCategoryDeclaration(name, attrs, derived, symbols));
    }

    @Override
    public void exitEnum_native_declaration(MParser.Enum_native_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        NativeType type = (NativeType)this.getNodeValue((ParseTree)ctx.typ);
        NativeSymbolList symbols = (NativeSymbolList)this.getNodeValue((ParseTree)ctx.symbols);
        this.setNodeValue(ctx, new EnumeratedNativeDeclaration(name, type, symbols));
    }

    @Override
    public void exitEnum_declaration(MParser.Enum_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitEqualsExpression(MParser.EqualsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.EQUALS, right));
    }

    @Override
    public void exitExpression_list(MParser.Expression_listContext ctx) {
        ExpressionList items = new ExpressionList();
        ctx.expression().forEach(e -> {
            IExpression item = (IExpression)this.getNodeValue((ParseTree)e);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitExpression_tuple(MParser.Expression_tupleContext ctx) {
        ExpressionList items = new ExpressionList();
        ctx.expression().forEach(e -> {
            IExpression item = (IExpression)this.getNodeValue((ParseTree)e);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitExecuteExpression(MParser.ExecuteExpressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue(ctx, new ExecuteExpression(name));
    }

    @Override
    public void exitExpressionAssignmentList(MParser.ExpressionAssignmentListContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        ArgumentList items = new ArgumentList();
        items.add(new Argument(null, exp));
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitFilteredListExpression(MParser.FilteredListExpressionContext ctx) {
        FilteredExpression fetch = (FilteredExpression)this.getNodeValue((ParseTree)ctx.filtered_list_suffix());
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.src);
        fetch.setSource(source);
        this.setNodeValue(ctx, fetch);
    }

    @Override
    public void exitFiltered_list_suffix(MParser.Filtered_list_suffixContext ctx) {
        Identifier itemName = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression predicate = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        this.setNodeValue(ctx, new FilteredExpression(itemName, null, predicate));
    }

    @Override
    public void exitFetchStatement(MParser.FetchStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitFetchOne(MParser.FetchOneContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        this.setNodeValue(ctx, new FetchOneExpression(category, filter));
    }

    @Override
    public void exitFetchOneAsync(MParser.FetchOneAsyncContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new FetchOneStatement(category, filter, name, stmts));
    }

    @Override
    public void exitFetchMany(MParser.FetchManyContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression start = (IExpression)this.getNodeValue((ParseTree)ctx.xstart);
        IExpression stop = (IExpression)this.getNodeValue((ParseTree)ctx.xstop);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        OrderByClauseList orderBy = (OrderByClauseList)this.getNodeValue((ParseTree)ctx.orderby);
        this.setNodeValue(ctx, new FetchManyExpression(category, start, stop, filter, orderBy));
    }

    @Override
    public void exitFetchManyAsync(MParser.FetchManyAsyncContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression start = (IExpression)this.getNodeValue((ParseTree)ctx.xstart);
        IExpression stop = (IExpression)this.getNodeValue((ParseTree)ctx.xstop);
        IExpression predicate = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        OrderByClauseList orderBy = (OrderByClauseList)this.getNodeValue((ParseTree)ctx.orderby);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new FetchManyStatement(category, start, stop, predicate, orderBy, name, stmts));
    }

    @Override
    public void exitFlush_statement(MParser.Flush_statementContext ctx) {
        this.setNodeValue(ctx, new FlushStatement());
    }

    @Override
    public void exitFlushStatement(MParser.FlushStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitFor_each_statement(MParser.For_each_statementContext ctx) {
        Identifier name1 = (Identifier)this.getNodeValue((ParseTree)ctx.name1);
        Identifier name2 = (Identifier)this.getNodeValue((ParseTree)ctx.name2);
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new ForEachStatement(name1, name2, source, stmts));
    }

    @Override
    public void exitForEachStatement(MParser.ForEachStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitFullDeclarationList(MParser.FullDeclarationListContext ctx) {
        DeclarationList items = (DeclarationList)this.getNodeValue((ParseTree)ctx.declarations());
        if (items == null) {
            items = new DeclarationList();
        }
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitGetter_method_declaration(MParser.Getter_method_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new GetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitGreaterThanExpression(MParser.GreaterThanExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.GT, right));
    }

    @Override
    public void exitGreaterThanOrEqualExpression(MParser.GreaterThanOrEqualExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.GTE, right));
    }

    @Override
    public void exitHexadecimalLiteral(MParser.HexadecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new HexaLiteral(ctx.getText()));
    }

    @Override
    public void exitHtmlType(MParser.HtmlTypeContext ctx) {
        this.setNodeValue(ctx, HtmlType.instance());
    }

    @Override
    public void exitIdentifierExpression(MParser.IdentifierExpressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new UnresolvedIdentifier(name));
    }

    @Override
    public void exitIf_statement(MParser.If_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        IfStatement.IfElementList elseIfs = (IfStatement.IfElementList)this.getNodeValue((ParseTree)ctx.elseIfs);
        StatementList elseStmts = (StatementList)this.getNodeValue((ParseTree)ctx.elseStmts);
        this.setNodeValue(ctx, new IfStatement(exp, stmts, elseIfs, elseStmts));
    }

    @Override
    public void exitIfStatement(MParser.IfStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitImageType(MParser.ImageTypeContext ctx) {
        this.setNodeValue(ctx, ImageType.instance());
    }

    @Override
    public void exitInExpression(MParser.InExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.IN, right));
    }

    @Override
    public void exitInstanceExpression(MParser.InstanceExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitIntDivideExpression(MParser.IntDivideExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new IntDivideExpression(left, right));
    }

    @Override
    public void exitIntegerLiteral(MParser.IntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new IntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitIntegerType(MParser.IntegerTypeContext ctx) {
        this.setNodeValue(ctx, IntegerType.instance());
    }

    @Override
    public void exitIsATypeExpression(MParser.IsATypeExpressionContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.category_or_any_type());
        TypeExpression exp = new TypeExpression(type);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitIsExpression(MParser.IsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        EqOp op = right instanceof TypeExpression ? EqOp.IS_A : EqOp.IS;
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, op, right));
    }

    @Override
    public void exitIsNotExpression(MParser.IsNotExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        EqOp op = right instanceof TypeExpression ? EqOp.IS_NOT_A : EqOp.IS_NOT;
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, op, right));
    }

    @Override
    public void exitIsOtherExpression(MParser.IsOtherExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitItemInstance(MParser.ItemInstanceContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new ItemInstance(exp));
    }

    @Override
    public void exitItemSelector(MParser.ItemSelectorContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new ItemSelector(exp));
    }

    @Override
    public void exitIteratorExpression(MParser.IteratorExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new IteratorExpression(name, source, exp));
    }

    @Override
    public void exitIteratorType(MParser.IteratorTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.i);
        this.setNodeValue(ctx, new IteratorType(type));
    }

    @Override
    public void exitJava_identifier(MParser.Java_identifierContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitJava_item_expression(MParser.Java_item_expressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new JavaItemExpression(exp));
    }

    @Override
    public void exitJava_method_expression(MParser.Java_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        JavaExpressionList args = (JavaExpressionList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new JavaMethodExpression(name, args));
    }

    @Override
    public void exitJava_parenthesis_expression(MParser.Java_parenthesis_expressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJava_primary_expression(MParser.Java_primary_expressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJava_this_expression(MParser.Java_this_expressionContext ctx) {
        this.setNodeValue(ctx, new JavaThisExpression());
    }

    @Override
    public void exitJavaArgumentList(MParser.JavaArgumentListContext ctx) {
        JavaExpression item = (JavaExpression)this.getNodeValue((ParseTree)ctx.item);
        this.setNodeValue((ParseTree)ctx, new JavaExpressionList(item));
    }

    @Override
    public void exitJavaArgumentListItem(MParser.JavaArgumentListItemContext ctx) {
        JavaExpression item = (JavaExpression)this.getNodeValue((ParseTree)ctx.item);
        JavaExpressionList items = (JavaExpressionList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitJavaBooleanLiteral(MParser.JavaBooleanLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaBooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaCategoryBinding(MParser.JavaCategoryBindingContext ctx) {
        JavaIdentifierExpression map = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new JavaNativeCategoryBinding(map));
    }

    @Override
    public void exitJavaCharacterLiteral(MParser.JavaCharacterLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaCharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaChildClassIdentifier(MParser.JavaChildClassIdentifierContext ctx) {
        JavaIdentifierExpression parent = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        JavaIdentifierExpression child = new JavaIdentifierExpression(parent, ctx.name.getText());
        this.setNodeValue(ctx, child);
    }

    @Override
    public void exitJavaChildIdentifier(MParser.JavaChildIdentifierContext ctx) {
        JavaIdentifierExpression parent = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        JavaIdentifierExpression child = new JavaIdentifierExpression(parent, name);
        this.setNodeValue(ctx, child);
    }

    @Override
    public void exitJavaClassIdentifier(MParser.JavaClassIdentifierContext ctx) {
        JavaIdentifierExpression klass = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.klass);
        this.setNodeValue(ctx, klass);
    }

    @Override
    public void exitJavaDecimalLiteral(MParser.JavaDecimalLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaDecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaIdentifier(MParser.JavaIdentifierContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue(ctx, new JavaIdentifierExpression(name));
    }

    @Override
    public void exitJavaIntegerLiteral(MParser.JavaIntegerLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaIntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaItemExpression(MParser.JavaItemExpressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaMethodExpression(MParser.JavaMethodExpressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaNativeStatement(MParser.JavaNativeStatementContext ctx) {
        JavaStatement stmt = (JavaStatement)this.getNodeValue((ParseTree)ctx.java_statement());
        this.setNodeValue(ctx, new JavaNativeCall(stmt));
    }

    @Override
    public void exitJavaPrimaryExpression(MParser.JavaPrimaryExpressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaReturnStatement(MParser.JavaReturnStatementContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaStatement(exp, true));
    }

    @Override
    public void exitJavascript_category_binding(MParser.Javascript_category_bindingContext ctx) {
        String identifier = ctx.javascript_identifier().stream().map(cx -> cx.getText()).collect(Collectors.joining("."));
        JavaScriptModule module = (JavaScriptModule)this.getNodeValue((ParseTree)ctx.javascript_module());
        JavaScriptNativeCategoryBinding map = new JavaScriptNativeCategoryBinding(identifier, module);
        this.setNodeValue((ParseTree)ctx, map);
    }

    @Override
    public void exitJavascript_identifier(MParser.Javascript_identifierContext ctx) {
        String name = ctx.getText();
        this.setNodeValue((ParseTree)ctx, name);
    }

    @Override
    public void exitJavascript_identifier_expression(MParser.Javascript_identifier_expressionContext ctx) {
        String name = ctx.name.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptIdentifierExpression(name));
    }

    @Override
    public void exitJavascript_method_expression(MParser.Javascript_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        JavaScriptMethodExpression method = new JavaScriptMethodExpression(name);
        JavaScriptExpressionList args = (JavaScriptExpressionList)this.getNodeValue((ParseTree)ctx.args);
        method.setArguments(args);
        this.setNodeValue((ParseTree)ctx, method);
    }

    @Override
    public void exitJavascript_module(MParser.Javascript_moduleContext ctx) {
        ArrayList<String> ids = new ArrayList<String>();
        for (MParser.Javascript_identifierContext ic : ctx.javascript_identifier()) {
            ids.add(ic.getText());
        }
        JavaScriptModule module = new JavaScriptModule(ids);
        this.setNodeValue((ParseTree)ctx, module);
    }

    @Override
    public void exitJavascript_native_statement(MParser.Javascript_native_statementContext ctx) {
        JavaScriptStatement stmt = (JavaScriptStatement)this.getNodeValue((ParseTree)ctx.javascript_statement());
        JavaScriptModule module = (JavaScriptModule)this.getNodeValue((ParseTree)ctx.javascript_module());
        stmt.setModule(module);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitJavascript_new_expression(MParser.Javascript_new_expressionContext ctx) {
        JavaScriptMethodExpression exp = (JavaScriptMethodExpression)this.getNodeValue((ParseTree)ctx.javascript_method_expression());
        this.setNodeValue((ParseTree)ctx, new JavaScriptNewExpression(exp));
    }

    @Override
    public void exitJavascript_primary_expression(MParser.Javascript_primary_expressionContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavascript_this_expression(MParser.Javascript_this_expressionContext ctx) {
        this.setNodeValue((ParseTree)ctx, new JavaScriptThisExpression());
    }

    @Override
    public void exitJavascriptArgumentList(MParser.JavascriptArgumentListContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.item);
        JavaScriptExpressionList list = new JavaScriptExpressionList(exp);
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitJavascriptArgumentListItem(MParser.JavascriptArgumentListItemContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.item);
        JavaScriptExpressionList list = (JavaScriptExpressionList)this.getNodeValue((ParseTree)ctx.items);
        list.add(exp);
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitJavascriptBooleanLiteral(MParser.JavascriptBooleanLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptBooleanLiteral(text));
    }

    @Override
    public void exitJavaScriptCategoryBinding(MParser.JavaScriptCategoryBindingContext ctx) {
        JavaScriptNativeCategoryBinding binding = (JavaScriptNativeCategoryBinding)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, binding);
    }

    @Override
    public void exitJavascriptCharacterLiteral(MParser.JavascriptCharacterLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptCharacterLiteral(text));
    }

    @Override
    public void exitJavascriptDecimalLiteral(MParser.JavascriptDecimalLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptDecimalLiteral(text));
    }

    @Override
    public void exitJavascriptIntegerLiteral(MParser.JavascriptIntegerLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptIntegerLiteral(text));
    }

    @Override
    public void exitJavaScriptMemberExpression(MParser.JavaScriptMemberExpressionContext ctx) {
        String name = ctx.name.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptMemberExpression(name));
    }

    @Override
    public void exitJavaScriptMethodExpression(MParser.JavaScriptMethodExpressionContext ctx) {
        JavaScriptExpression method = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.method);
        this.setNodeValue((ParseTree)ctx, method);
    }

    @Override
    public void exitJavaScriptNativeStatement(MParser.JavaScriptNativeStatementContext ctx) {
        JavaScriptStatement stmt = (JavaScriptStatement)this.getNodeValue((ParseTree)ctx.javascript_native_statement());
        this.setNodeValue(ctx, new JavaScriptNativeCall(stmt));
    }

    @Override
    public void exitJavascriptPrimaryExpression(MParser.JavascriptPrimaryExpressionContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavascriptReturnStatement(MParser.JavascriptReturnStatementContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaScriptStatement(exp, true));
    }

    @Override
    public void exitJavascriptSelectorExpression(MParser.JavascriptSelectorExpressionContext ctx) {
        JavaScriptExpression parent = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.parent);
        JavaScriptSelectorExpression child = (JavaScriptSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        child.setParent(parent);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitJavascriptStatement(MParser.JavascriptStatementContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaScriptStatement(exp, false));
    }

    @Override
    public void exitJavascriptTextLiteral(MParser.JavascriptTextLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptTextLiteral(text));
    }

    @Override
    public void exitJavaSelectorExpression(MParser.JavaSelectorExpressionContext ctx) {
        JavaExpression parent = (JavaExpression)this.getNodeValue((ParseTree)ctx.parent);
        JavaSelectorExpression child = (JavaSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        child.setParent(parent);
        this.setNodeValue(ctx, child);
    }

    @Override
    public void exitJavaStatement(MParser.JavaStatementContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaStatement(exp, false));
    }

    @Override
    public void exitJavaTextLiteral(MParser.JavaTextLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaTextLiteral(ctx.getText()));
    }

    @Override
    public void exitJsxChild(MParser.JsxChildContext ctx) {
        Object jsx = this.getNodeValue((ParseTree)ctx.jsx);
        this.setNodeValue((ParseTree)ctx, jsx);
    }

    @Override
    public void exitJsxCode(MParser.JsxCodeContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JsxExpression(exp));
    }

    @Override
    public void exitJsxElement(MParser.JsxElementContext ctx) {
        JsxElement element = (JsxElement)this.getNodeValue((ParseTree)ctx.opening);
        JsxClosing closing = (JsxClosing)this.getNodeValue((ParseTree)ctx.closing);
        element.setClosing(closing);
        List children = (List)this.getNodeValue((ParseTree)ctx.children_);
        element.setChildren(children);
        this.setNodeValue(ctx, element);
    }

    @Override
    public void exitJsxExpression(MParser.JsxExpressionContext ctx) {
        Object jsx = this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, jsx);
    }

    @Override
    public void exitJsxSelfClosing(MParser.JsxSelfClosingContext ctx) {
        JsxSelfClosing jsx = (JsxSelfClosing)this.getNodeValue((ParseTree)ctx.jsx);
        this.setNodeValue(ctx, jsx);
    }

    @Override
    public void exitJsxText(MParser.JsxTextContext ctx) {
        String text = ParserUtils.getFullText(ctx.text);
        this.setNodeValue((ParseTree)ctx, new JsxText(text));
    }

    @Override
    public void exitJsxValue(MParser.JsxValueContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JsxExpression(exp));
    }

    @Override
    public void exitJsx_attribute(MParser.Jsx_attributeContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IJsxValue value = (IJsxValue)this.getNodeValue((ParseTree)ctx.value);
        String suite = this.getWhiteSpacePlus(ctx.ws_plus());
        this.setNodeValue(ctx, new JsxProperty(name, value, suite));
    }

    @Override
    public void exitJsx_children(MParser.Jsx_childrenContext ctx) {
        List list = ctx.jsx_child().stream().map(cx -> (IJsxExpression)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitJsx_element_name(MParser.Jsx_element_nameContext ctx) {
        String name = ctx.getText();
        this.setNodeValue(ctx, new Identifier(name));
    }

    @Override
    public void exitJsx_expression(MParser.Jsx_expressionContext ctx) {
        Object jsx = this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, jsx);
    }

    @Override
    public void exitJsx_identifier(MParser.Jsx_identifierContext ctx) {
        String name = ctx.getText();
        this.setNodeValue(ctx, new Identifier(name));
    }

    @Override
    public void exitJsx_fragment(MParser.Jsx_fragmentContext ctx) {
        String openingSuite = this.getHiddenTokensAfter(ctx.jsx_fragment_start().getStop());
        JsxFragment fragment = new JsxFragment(openingSuite);
        List children = (List)this.getNodeValue((ParseTree)ctx.children_);
        fragment.setChildren(children);
        this.setNodeValue(ctx, fragment);
    }

    @Override
    public void exitJsxLiteral(MParser.JsxLiteralContext ctx) {
        String text = ctx.getText();
        this.setNodeValue((ParseTree)ctx, new JsxLiteral(text));
    }

    @Override
    public void exitJsx_opening(MParser.Jsx_openingContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        String nameSuite = this.getWhiteSpacePlus(ctx.ws_plus());
        List<JsxProperty> attributes = ctx.jsx_attribute().stream().map(cx -> (JsxProperty)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        this.setNodeValue(ctx, new JsxElement(name, nameSuite, attributes, null));
    }

    @Override
    public void exitJsx_closing(MParser.Jsx_closingContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new JsxClosing(name, null));
    }

    @Override
    public void exitJsx_self_closing(MParser.Jsx_self_closingContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        String nameSuite = this.getWhiteSpacePlus(ctx.ws_plus());
        List<JsxProperty> attributes = ctx.jsx_attribute().stream().map(cx -> (JsxProperty)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        this.setNodeValue(ctx, new JsxSelfClosing(name, nameSuite, attributes, null));
    }

    @Override
    public void exitKey_token(MParser.Key_tokenContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitLessThanExpression(MParser.LessThanExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.LT, right));
    }

    @Override
    public void exitLessThanOrEqualExpression(MParser.LessThanOrEqualExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.LTE, right));
    }

    @Override
    public void exitList_literal(MParser.List_literalContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.expression_list());
        ListLiteral value = items == null ? new ListLiteral(mutable) : new ListLiteral(items, mutable);
        this.setNodeValue((ParseTree)ctx, value);
    }

    @Override
    public void exitListType(MParser.ListTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.l);
        this.setNodeValue(ctx, new ListType(type));
    }

    @Override
    public void exitLiteral_expression(MParser.Literal_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitLiteral_list_literal(MParser.Literal_list_literalContext ctx) {
        ExpressionList items = new ExpressionList();
        ctx.atomic_literal().forEach(l -> {
            IExpression item = (IExpression)this.getNodeValue((ParseTree)l);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitLiteralExpression(MParser.LiteralExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitLiteralListLiteral(MParser.LiteralListLiteralContext ctx) {
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.literal_list_literal());
        this.setNodeValue((ParseTree)ctx, new ListLiteral(items, false));
    }

    @Override
    public void exitLiteralRangeLiteral(MParser.LiteralRangeLiteralContext ctx) {
        IExpression low = (IExpression)this.getNodeValue((ParseTree)ctx.low);
        IExpression high = (IExpression)this.getNodeValue((ParseTree)ctx.high);
        this.setNodeValue((ParseTree)ctx, new RangeLiteral(low, high));
    }

    @Override
    public void exitLiteralSetLiteral(MParser.LiteralSetLiteralContext ctx) {
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.literal_list_literal());
        this.setNodeValue((ParseTree)ctx, new SetLiteral(items));
    }

    @Override
    public void exitMatchingExpression(MParser.MatchingExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new MatchingExpressionConstraint(exp));
    }

    @Override
    public void exitMatchingList(MParser.MatchingListContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue(ctx, new MatchingCollectionConstraint(exp));
    }

    @Override
    public void exitMatchingPattern(MParser.MatchingPatternContext ctx) {
        this.setNodeValue(ctx, new MatchingPatternConstraint(new TextLiteral(ctx.text.getText())));
    }

    @Override
    public void exitMatchingRange(MParser.MatchingRangeContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue(ctx, new MatchingCollectionConstraint(exp));
    }

    @Override
    public void exitMatchingSet(MParser.MatchingSetContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue(ctx, new MatchingCollectionConstraint(exp));
    }

    @Override
    public void exitMaxIntegerLiteral(MParser.MaxIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new MaxIntegerLiteral());
    }

    @Override
    public void exitMember_method_declaration(MParser.Member_method_declarationContext ctx) {
        List<CommentStatement> comments = this.readComments(ctx.comment_statement());
        List<Annotation> annotations = this.readAnnotations(ctx.annotation_constructor());
        ParseTree ctx_ = ctx.getChild(ctx.getChildCount() - 1);
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx_);
        if (decl != null) {
            decl.setComments(comments);
            decl.setAnnotations(annotations);
            this.setNodeValue((ParseTree)ctx, decl);
        }
    }

    @Override
    public void exitMember_method_declaration_list(MParser.Member_method_declaration_listContext ctx) {
        MethodDeclarationList items = new MethodDeclarationList();
        ctx.member_method_declaration().forEach(m -> {
            IMethodDeclaration item = (IMethodDeclaration)this.getNodeValue((ParseTree)m);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitMember_identifier(MParser.Member_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitMemberInstance(MParser.MemberInstanceContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new MemberInstance(name));
    }

    @Override
    public void exitMemberSelector(MParser.MemberSelectorContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue(ctx, new MemberSelector(name));
    }

    @Override
    public void exitMethod_call_expression(MParser.Method_call_expressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        UnresolvedIdentifier caller = new UnresolvedIdentifier(name);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new UnresolvedCall(caller, args));
    }

    @Override
    public void exitMethod_call_statement(MParser.Method_call_statementContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        UnresolvedCall call = (UnresolvedCall)this.getNodeValue((ParseTree)ctx.method);
        call.setParent(parent);
        Identifier resultName = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        if (resultName != null || stmts != null) {
            this.setNodeValue(ctx, new RemoteCall(call, resultName, stmts));
        } else {
            this.setNodeValue(ctx, call);
        }
    }

    @Override
    public void exitMethod_declaration(MParser.Method_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitMethod_expression(MParser.Method_expressionContext ctx) {
        IExpression decl = (IExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitMethod_identifier(MParser.Method_identifierContext ctx) {
        Object id = this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, id);
    }

    @Override
    public void exitMethodCallStatement(MParser.MethodCallStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitMethodExpression(MParser.MethodExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitMethodSelector(MParser.MethodSelectorContext ctx) {
        UnresolvedCall call = (UnresolvedCall)this.getNodeValue((ParseTree)ctx.method);
        if (call.getCaller() instanceof UnresolvedIdentifier) {
            Identifier id = ((UnresolvedIdentifier)call.getCaller()).getId();
            call.setCaller(new UnresolvedSelector(id));
        }
        this.setNodeValue(ctx, call);
    }

    @Override
    public void exitMinIntegerLiteral(MParser.MinIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new MinIntegerLiteral());
    }

    @Override
    public void exitMinusExpression(MParser.MinusExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new MinusExpression(exp));
    }

    @Override
    public void exitModuloExpression(MParser.ModuloExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new ModuloExpression(left, right));
    }

    @Override
    public void exitMultiplyExpression(MParser.MultiplyExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new MultiplyExpression(left, right));
    }

    @Override
    public void exitMutable_category_type(MParser.Mutable_category_typeContext ctx) {
        CategoryType typ = (CategoryType)this.getNodeValue((ParseTree)ctx.category_type());
        typ.setMutable(ctx.MUTABLE() != null);
        this.setNodeValue(ctx, typ);
    }

    @Override
    public void exitMutableInstanceExpression(MParser.MutableInstanceExpressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new MutableExpression(source));
    }

    @Override
    public void exitMutableSelectableExpression(MParser.MutableSelectableExpressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new InstanceExpression(name));
    }

    @Override
    public void exitMutableSelectorExpression(MParser.MutableSelectorExpressionContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        SelectorExpression selector = (SelectorExpression)this.getNodeValue((ParseTree)ctx.selector);
        selector.setParent(parent);
        this.setNodeValue(ctx, selector);
    }

    @Override
    public void exitNamed_argument(MParser.Named_argumentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        UnresolvedParameter arg = new UnresolvedParameter(name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.literal_expression());
        arg.setDefaultExpression(exp);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitNative_category_bindings(MParser.Native_category_bindingsContext ctx) {
        NativeCategoryBindingList items = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.items);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNative_category_declaration(MParser.Native_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        NativeCategoryBindingList bindings = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.bindings);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        NativeCategoryDeclaration decl = new NativeCategoryDeclaration(name, attrs, bindings, null, methods);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitNative_widget_declaration(MParser.Native_widget_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        NativeCategoryBindingList bindings = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.bindings);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        this.setNodeValue(ctx, new NativeWidgetDeclaration(name, bindings, methods));
    }

    @Override
    public void exitNative_getter_declaration(MParser.Native_getter_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new NativeGetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitNative_member_method_declaration(MParser.Native_member_method_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitNative_method_declaration(MParser.Native_method_declarationContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ParameterList args = (ParameterList)this.getNodeValue((ParseTree)ctx.args);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new NativeMethodDeclaration(name, args, type, stmts));
    }

    @Override
    public void exitNative_resource_declaration(MParser.Native_resource_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        NativeCategoryBindingList bindings = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.bindings);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        NativeResourceDeclaration decl = new NativeResourceDeclaration(name, attrs, bindings, null, methods);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitNative_setter_declaration(MParser.Native_setter_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new NativeSetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitNative_symbol(MParser.Native_symbolContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new NativeSymbol(name, exp));
    }

    @Override
    public void exitNativeCategoryBindingList(MParser.NativeCategoryBindingListContext ctx) {
        NativeCategoryBinding item = (NativeCategoryBinding)this.getNodeValue((ParseTree)ctx.item);
        NativeCategoryBindingList items = new NativeCategoryBindingList(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNativeCategoryBindingListItem(MParser.NativeCategoryBindingListItemContext ctx) {
        NativeCategoryBinding item = (NativeCategoryBinding)this.getNodeValue((ParseTree)ctx.item);
        NativeCategoryBindingList items = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNativeCategoryDeclaration(MParser.NativeCategoryDeclarationContext ctx) {
        NativeCategoryDeclaration decl = (NativeCategoryDeclaration)this.getNodeValue((ParseTree)ctx.decl);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitNativeWidgetDeclaration(MParser.NativeWidgetDeclarationContext ctx) {
        NativeWidgetDeclaration decl = (NativeWidgetDeclaration)this.getNodeValue((ParseTree)ctx.decl);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitNative_member_method_declaration_list(MParser.Native_member_method_declaration_listContext ctx) {
        MethodDeclarationList items = new MethodDeclarationList();
        ctx.native_member_method_declaration().forEach(m -> {
            IMethodDeclaration item = (IMethodDeclaration)this.getNodeValue((ParseTree)m);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNative_statement_list(MParser.Native_statement_listContext ctx) {
        StatementList items = new StatementList();
        ctx.native_statement().forEach(s -> {
            IStatement item = (IStatement)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNative_symbol_list(MParser.Native_symbol_listContext ctx) {
        NativeSymbolList items = new NativeSymbolList();
        ctx.native_symbol().forEach(s -> {
            NativeSymbol item = (NativeSymbol)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNativeType(MParser.NativeTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.n);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitNotHasExpression(MParser.NotHasExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_HAS, right));
    }

    @Override
    public void exitNotHasAllExpression(MParser.NotHasAllExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_HAS_ALL, right));
    }

    @Override
    public void exitNotHasAnyExpression(MParser.NotHasAnyExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_HAS_ANY, right));
    }

    @Override
    public void exitNotContainsExpression(MParser.NotContainsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.NOT_CONTAINS, right));
    }

    @Override
    public void exitNotEqualsExpression(MParser.NotEqualsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.NOT_EQUALS, right));
    }

    @Override
    public void exitNotExpression(MParser.NotExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new NotExpression(exp));
    }

    @Override
    public void exitNotInExpression(MParser.NotInExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_IN, right));
    }

    @Override
    public void exitNullLiteral(MParser.NullLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, NullLiteral.instance());
    }

    @Override
    public void exitOperator_argument(MParser.Operator_argumentContext ctx) {
        IParameter arg = (IParameter)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitOperator_method_declaration(MParser.Operator_method_declarationContext ctx) {
        Operator op = (Operator)((Object)this.getNodeValue((ParseTree)ctx.op));
        IParameter arg = (IParameter)this.getNodeValue((ParseTree)ctx.arg);
        IType typ = (IType)this.getNodeValue((ParseTree)ctx.typ);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        OperatorMethodDeclaration decl = new OperatorMethodDeclaration(op, arg, typ, stmts);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitOperatorArgument(MParser.OperatorArgumentContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        IParameter arg = (IParameter)this.getNodeValue((ParseTree)ctx.arg);
        arg.setMutable(mutable);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitOperatorDivide(MParser.OperatorDivideContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.DIVIDE);
    }

    @Override
    public void exitOperatorIDivide(MParser.OperatorIDivideContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.IDIVIDE);
    }

    @Override
    public void exitOperatorMinus(MParser.OperatorMinusContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.MINUS);
    }

    @Override
    public void exitOperatorModulo(MParser.OperatorModuloContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.MODULO);
    }

    @Override
    public void exitOperatorMultiply(MParser.OperatorMultiplyContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.MULTIPLY);
    }

    @Override
    public void exitOperatorPlus(MParser.OperatorPlusContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.PLUS);
    }

    @Override
    public void exitOrder_by(MParser.Order_byContext ctx) {
        IdentifierList names = new IdentifierList();
        for (MParser.Variable_identifierContext ctx_ : ctx.variable_identifier()) {
            names.add(this.getNodeValue((ParseTree)ctx_));
        }
        OrderByClause clause = new OrderByClause(names, ctx.DESC() != null);
        this.setNodeValue(ctx, clause);
    }

    @Override
    public void exitOrder_by_list(MParser.Order_by_listContext ctx) {
        OrderByClauseList list = new OrderByClauseList();
        for (MParser.Order_byContext ctx_ : ctx.order_by()) {
            list.add(this.getNodeValue((ParseTree)ctx_));
        }
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitOrExpression(MParser.OrExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new OrExpression(left, right));
    }

    @Override
    public void exitParenthesis_expression(MParser.Parenthesis_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue(ctx, new ParenthesisExpression(exp));
    }

    @Override
    public void exitParenthesisExpression(MParser.ParenthesisExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPeriodLiteral(MParser.PeriodLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PeriodLiteral(ctx.getText()));
    }

    @Override
    public void exitPeriodType(MParser.PeriodTypeContext ctx) {
        this.setNodeValue(ctx, PeriodType.instance());
    }

    @Override
    public void exitPrimaryType(MParser.PrimaryTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.p);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitPython_category_binding(MParser.Python_category_bindingContext ctx) {
        String identifier = ctx.identifier().getText();
        PythonModule module = (PythonModule)this.getNodeValue((ParseTree)ctx.python_module());
        PythonNativeCategoryBinding map = new PythonNativeCategoryBinding(identifier, module);
        this.setNodeValue((ParseTree)ctx, map);
    }

    @Override
    public void exitPython_identifier(MParser.Python_identifierContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitPython_method_expression(MParser.Python_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonArgumentList args = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.args);
        PythonMethodExpression method = new PythonMethodExpression(name);
        method.setArguments(args);
        this.setNodeValue((ParseTree)ctx, method);
    }

    @Override
    public void exitPython_module(MParser.Python_moduleContext ctx) {
        ArrayList<String> ids = new ArrayList<String>();
        for (MParser.Python_identifierContext ic : ctx.python_identifier()) {
            ids.add(ic.getText());
        }
        PythonModule module = new PythonModule(ids);
        this.setNodeValue((ParseTree)ctx, module);
    }

    @Override
    public void exitPython_native_statement(MParser.Python_native_statementContext ctx) {
        PythonStatement stmt = (PythonStatement)this.getNodeValue((ParseTree)ctx.python_statement());
        PythonModule module = (PythonModule)this.getNodeValue((ParseTree)ctx.python_module());
        stmt.setModule(module);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitPython2CategoryBinding(MParser.Python2CategoryBindingContext ctx) {
        PythonNativeCategoryBinding map = (PythonNativeCategoryBinding)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new Python2NativeCategoryBinding(map));
    }

    @Override
    public void exitPython2NativeStatement(MParser.Python2NativeStatementContext ctx) {
        PythonStatement stmt = (PythonStatement)this.getNodeValue((ParseTree)ctx.python_native_statement());
        this.setNodeValue(ctx, new Python2NativeCall(stmt));
    }

    @Override
    public void exitPython3CategoryBinding(MParser.Python3CategoryBindingContext ctx) {
        PythonNativeCategoryBinding map = (PythonNativeCategoryBinding)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new Python3NativeCategoryBinding(map));
    }

    @Override
    public void exitPython3NativeStatement(MParser.Python3NativeStatementContext ctx) {
        PythonStatement stmt = (PythonStatement)this.getNodeValue((ParseTree)ctx.python_native_statement());
        this.setNodeValue(ctx, new Python3NativeCall(stmt));
    }

    @Override
    public void exitPythonArgumentList(MParser.PythonArgumentListContext ctx) {
        PythonArgumentList ordinal = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.ordinal);
        PythonArgumentList named = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.named);
        if (ordinal == null) {
            ordinal = new PythonArgumentList();
        }
        if (named != null) {
            ordinal.addAll(named);
        }
        this.setNodeValue((ParseTree)ctx, ordinal);
    }

    @Override
    public void exitPythonBooleanLiteral(MParser.PythonBooleanLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonBooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonCharacterLiteral(MParser.PythonCharacterLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonCharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonChildIdentifier(MParser.PythonChildIdentifierContext ctx) {
        PythonIdentifierExpression parent = (PythonIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonIdentifierExpression child = new PythonIdentifierExpression(parent, name);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitPythonDecimalLiteral(MParser.PythonDecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonDecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonGlobalMethodExpression(MParser.PythonGlobalMethodExpressionContext ctx) {
        PythonMethodExpression exp = (PythonMethodExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonIdentifier(MParser.PythonIdentifierContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new PythonIdentifierExpression(name));
    }

    @Override
    public void exitPythonIdentifierExpression(MParser.PythonIdentifierExpressionContext ctx) {
        PythonIdentifierExpression exp = (PythonIdentifierExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonIntegerLiteral(MParser.PythonIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonIntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonLiteralExpression(MParser.PythonLiteralExpressionContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonMethodExpression(MParser.PythonMethodExpressionContext ctx) {
        PythonMethodExpression exp = (PythonMethodExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonNamedArgumentList(MParser.PythonNamedArgumentListContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        PythonNamedArgument arg = new PythonNamedArgument(name, exp);
        this.setNodeValue((ParseTree)ctx, new PythonArgumentList(arg));
    }

    @Override
    public void exitPythonNamedArgumentListItem(MParser.PythonNamedArgumentListItemContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        PythonNamedArgument arg = new PythonNamedArgument(name, exp);
        PythonArgumentList items = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.items);
        items.add(arg);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitPythonNamedOnlyArgumentList(MParser.PythonNamedOnlyArgumentListContext ctx) {
        PythonArgumentList named = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.named);
        this.setNodeValue((ParseTree)ctx, named);
    }

    @Override
    public void exitPythonOrdinalArgumentList(MParser.PythonOrdinalArgumentListContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.item);
        PythonOrdinalArgument arg = new PythonOrdinalArgument(exp);
        this.setNodeValue((ParseTree)ctx, new PythonArgumentList(arg));
    }

    @Override
    public void exitPythonOrdinalArgumentListItem(MParser.PythonOrdinalArgumentListItemContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.item);
        PythonOrdinalArgument arg = new PythonOrdinalArgument(exp);
        PythonArgumentList items = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.items);
        items.add(arg);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitPythonOrdinalOnlyArgumentList(MParser.PythonOrdinalOnlyArgumentListContext ctx) {
        PythonArgumentList ordinal = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.ordinal);
        this.setNodeValue((ParseTree)ctx, ordinal);
    }

    @Override
    public void exitPythonPromptoIdentifier(MParser.PythonPromptoIdentifierContext ctx) {
        String name = ctx.DOLLAR_IDENTIFIER().getText();
        this.setNodeValue((ParseTree)ctx, new PythonIdentifierExpression(name));
    }

    @Override
    public void exitPythonPrimaryExpression(MParser.PythonPrimaryExpressionContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonReturnStatement(MParser.PythonReturnStatementContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new PythonStatement(exp, true));
    }

    @Override
    public void exitPythonSelectorExpression(MParser.PythonSelectorExpressionContext ctx) {
        PythonExpression parent = (PythonExpression)this.getNodeValue((ParseTree)ctx.parent);
        PythonSelectorExpression selector = (PythonSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        selector.setParent(parent);
        this.setNodeValue((ParseTree)ctx, selector);
    }

    @Override
    public void exitPythonSelfExpression(MParser.PythonSelfExpressionContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonSelfExpression());
    }

    @Override
    public void exitPythonStatement(MParser.PythonStatementContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new PythonStatement(exp, false));
    }

    @Override
    public void exitPythonTextLiteral(MParser.PythonTextLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonTextLiteral(ctx.getText()));
    }

    @Override
    public void exitRaise_statement(MParser.Raise_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new RaiseStatement(exp));
    }

    @Override
    public void exitRaiseStatement(MParser.RaiseStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitRange_literal(MParser.Range_literalContext ctx) {
        IExpression low = (IExpression)this.getNodeValue((ParseTree)ctx.low);
        IExpression high = (IExpression)this.getNodeValue((ParseTree)ctx.high);
        this.setNodeValue((ParseTree)ctx, new RangeLiteral(low, high));
    }

    @Override
    public void exitRead_all_expression(MParser.Read_all_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new ReadAllExpression(source));
    }

    @Override
    public void exitRead_blob_expression(MParser.Read_blob_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new ReadBlobExpression(source));
    }

    @Override
    public void exitRead_one_expression(MParser.Read_one_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new ReadOneExpression(source));
    }

    @Override
    public void exitResource_declaration(MParser.Resource_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue((ParseTree)ctx.native_resource_declaration());
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitReturn_statement(MParser.Return_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new ReturnStatement(exp));
    }

    @Override
    public void exitReturnStatement(MParser.ReturnStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitRootInstance(MParser.RootInstanceContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        this.setNodeValue((ParseTree)ctx, new VariableInstance(name));
    }

    @Override
    public void exitRoughlyEqualsExpression(MParser.RoughlyEqualsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.ROUGHLY, right));
    }

    @Override
    public void exitSelectableExpression(MParser.SelectableExpressionContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        this.setNodeValue((ParseTree)ctx, parent);
    }

    @Override
    public void exitSelectorExpression(MParser.SelectorExpressionContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        IExpression selector = (IExpression)this.getNodeValue((ParseTree)ctx.selector);
        if (selector instanceof SelectorExpression) {
            ((SelectorExpression)selector).setParent(parent);
        } else if (selector instanceof UnresolvedCall) {
            ((UnresolvedCall)selector).setParent(parent);
        }
        this.setNodeValue((ParseTree)ctx, selector);
    }

    @Override
    public void exitSet_literal(MParser.Set_literalContext ctx) {
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.expression_list());
        SetLiteral set = items == null ? new SetLiteral() : new SetLiteral(items);
        this.setNodeValue((ParseTree)ctx, set);
    }

    @Override
    public void exitSetter_method_declaration(MParser.Setter_method_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new SetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitSetType(MParser.SetTypeContext ctx) {
        IType itemType = (IType)this.getNodeValue((ParseTree)ctx.s);
        this.setNodeValue(ctx, new SetType(itemType));
    }

    @Override
    public void exitSingleton_category_declaration(MParser.Singleton_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        this.setNodeValue(ctx, new SingletonCategoryDeclaration(name, attrs, methods));
    }

    @Override
    public void exitSingletonCategoryDeclaration(MParser.SingletonCategoryDeclarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue((ParseTree)ctx.decl);
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitSliceFirstAndLast(MParser.SliceFirstAndLastContext ctx) {
        IExpression first = (IExpression)this.getNodeValue((ParseTree)ctx.first);
        IExpression last = (IExpression)this.getNodeValue((ParseTree)ctx.last);
        this.setNodeValue(ctx, new SliceSelector(first, last));
    }

    @Override
    public void exitSliceFirstOnly(MParser.SliceFirstOnlyContext ctx) {
        IExpression first = (IExpression)this.getNodeValue((ParseTree)ctx.first);
        this.setNodeValue(ctx, new SliceSelector(first, null));
    }

    @Override
    public void exitSliceLastOnly(MParser.SliceLastOnlyContext ctx) {
        IExpression last = (IExpression)this.getNodeValue((ParseTree)ctx.last);
        this.setNodeValue(ctx, new SliceSelector(null, last));
    }

    @Override
    public void exitSliceSelector(MParser.SliceSelectorContext ctx) {
        IExpression slice = (IExpression)this.getNodeValue((ParseTree)ctx.xslice);
        this.setNodeValue((ParseTree)ctx, slice);
    }

    @Override
    public void exitSorted_expression(MParser.Sorted_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        boolean descending = ctx.DESC() != null;
        IExpression key = (IExpression)this.getNodeValue((ParseTree)ctx.key);
        this.setNodeValue((ParseTree)ctx, new SortedExpression(source, descending, key));
    }

    @Override
    public void exitSorted_key(MParser.Sorted_keyContext ctx) {
        this.setNodeValue((ParseTree)ctx, this.getNodeValue(ctx.getChild(0)));
    }

    @Override
    public void exitStatement_list(MParser.Statement_listContext ctx) {
        StatementList items = new StatementList();
        ctx.statement().forEach(s -> {
            IStatement item = (IStatement)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitStore_statement(MParser.Store_statementContext ctx) {
        ExpressionList deletables = (ExpressionList)this.getNodeValue((ParseTree)ctx.to_del);
        ExpressionList storables = (ExpressionList)this.getNodeValue((ParseTree)ctx.to_add);
        StatementList andThen = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        StoreStatement stmt = new StoreStatement(deletables, storables, andThen);
        this.setNodeValue(ctx, stmt);
    }

    @Override
    public void exitStoreStatement(MParser.StoreStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitSuperExpression(MParser.SuperExpressionContext ctx) {
        this.setNodeValue(ctx, new SuperExpression());
    }

    @Override
    public void exitSwitch_statement(MParser.Switch_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        BaseSwitchStatement.SwitchCaseList cases = (BaseSwitchStatement.SwitchCaseList)this.getNodeValue((ParseTree)ctx.cases);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        SwitchStatement stmt = new SwitchStatement(exp, cases, stmts);
        this.setNodeValue(ctx, stmt);
    }

    @Override
    public void exitSwitch_case_statement_list(MParser.Switch_case_statement_listContext ctx) {
        BaseSwitchStatement.SwitchCaseList items = new BaseSwitchStatement.SwitchCaseList();
        ctx.switch_case_statement().forEach(s -> {
            SwitchCase item = (SwitchCase)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitSwitchStatement(MParser.SwitchStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitSymbol_identifier(MParser.Symbol_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitSymbolIdentifier(MParser.SymbolIdentifierContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.symbol_identifier());
        this.setNodeValue(ctx, name);
    }

    @Override
    public void exitSymbolLiteral(MParser.SymbolLiteralContext ctx) {
        this.setNodeValue(ctx, new SymbolExpression(new Identifier(ctx.getText())));
    }

    @Override
    public void exitSymbol_list(MParser.Symbol_listContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exitSymbols_token(MParser.Symbols_tokenContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitTernaryExpression(MParser.TernaryExpressionContext ctx) {
        IExpression condition = (IExpression)this.getNodeValue((ParseTree)ctx.test);
        IExpression ifTrue = (IExpression)this.getNodeValue((ParseTree)ctx.ifTrue);
        IExpression ifFalse = (IExpression)this.getNodeValue((ParseTree)ctx.ifFalse);
        TernaryExpression exp = new TernaryExpression(condition, ifTrue, ifFalse);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitTest_method_declaration(MParser.Test_method_declarationContext ctx) {
        Identifier name = new Identifier(ctx.name.getText());
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        AssertionList exps = (AssertionList)this.getNodeValue((ParseTree)ctx.exps);
        Identifier errorName = (Identifier)this.getNodeValue((ParseTree)ctx.error);
        SymbolExpression error = errorName == null ? null : new SymbolExpression(errorName);
        this.setNodeValue(ctx, new TestMethodDeclaration(name, stmts, exps, error));
    }

    @Override
    public void exitTextLiteral(MParser.TextLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new TextLiteral(ctx.getText()));
    }

    @Override
    public void exitTextType(MParser.TextTypeContext ctx) {
        this.setNodeValue(ctx, TextType.instance());
    }

    @Override
    public void exitThisExpression(MParser.ThisExpressionContext ctx) {
        this.setNodeValue(ctx, new ThisExpression());
    }

    @Override
    public void exitTimeLiteral(MParser.TimeLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new TimeLiteral(ctx.getText()));
    }

    @Override
    public void exitTimeType(MParser.TimeTypeContext ctx) {
        this.setNodeValue(ctx, TimeType.instance());
    }

    @Override
    public void exitTry_statement(MParser.Try_statementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        BaseSwitchStatement.SwitchCaseList handlers = (BaseSwitchStatement.SwitchCaseList)this.getNodeValue((ParseTree)ctx.handlers);
        StatementList anyStmts = (StatementList)this.getNodeValue((ParseTree)ctx.anyStmts);
        StatementList finalStmts = (StatementList)this.getNodeValue((ParseTree)ctx.finalStmts);
        SwitchErrorStatement stmt = new SwitchErrorStatement(name, stmts, handlers, anyStmts, finalStmts);
        this.setNodeValue(ctx, stmt);
    }

    @Override
    public void exitTryStatement(MParser.TryStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitTuple_literal(MParser.Tuple_literalContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.expression_tuple());
        TupleLiteral value = items == null ? new TupleLiteral(mutable) : new TupleLiteral(items, mutable);
        this.setNodeValue((ParseTree)ctx, value);
    }

    @Override
    public void exitType_identifier(MParser.Type_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitType_identifier_list(MParser.Type_identifier_listContext ctx) {
        IdentifierList items = new IdentifierList();
        ctx.type_identifier().forEach(i -> {
            Identifier item = (Identifier)this.getNodeValue((ParseTree)i);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitType_literal(MParser.Type_literalContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.category_or_any_type());
        this.setNodeValue(ctx, new TypeLiteral(type));
    }

    @Override
    public void exitTyped_argument(MParser.Typed_argumentContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        CategoryParameter arg = attrs == null ? new CategoryParameter(type, name) : new ExtendedParameter(type, name, attrs);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.value);
        arg.setDefaultExpression(exp);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitTypeIdentifier(MParser.TypeIdentifierContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.type_identifier());
        this.setNodeValue(ctx, name);
    }

    @Override
    public void exitTypeLiteral(MParser.TypeLiteralContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.type_literal()));
    }

    @Override
    public void exitUUIDLiteral(MParser.UUIDLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new UuidLiteral(ctx.getText()));
    }

    @Override
    public void exitUUIDType(MParser.UUIDTypeContext ctx) {
        this.setNodeValue(ctx, UuidType.instance());
    }

    @Override
    public void exitValue_token(MParser.Value_tokenContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitVariable_identifier(MParser.Variable_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitVariableIdentifier(MParser.VariableIdentifierContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        this.setNodeValue(ctx, name);
    }

    @Override
    public void exitVariable_identifier_list(MParser.Variable_identifier_listContext ctx) {
        IdentifierList list = new IdentifierList();
        for (MParser.Variable_identifierContext v : ctx.variable_identifier()) {
            Identifier item = (Identifier)this.getNodeValue((ParseTree)v);
            list.add(item);
        }
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitVersionType(MParser.VersionTypeContext ctx) {
        this.setNodeValue(ctx, VersionType.instance());
    }

    @Override
    public void exitVersionLiteral(MParser.VersionLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new VersionLiteral(ctx.getText()));
    }

    @Override
    public void exitWhile_statement(MParser.While_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new WhileStatement(exp, stmts));
    }

    @Override
    public void exitWhileStatement(MParser.WhileStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitWith_resource_statement(MParser.With_resource_statementContext ctx) {
        AssignVariableStatement stmt = (AssignVariableStatement)this.getNodeValue((ParseTree)ctx.stmt);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new WithResourceStatement(stmt, stmts));
    }

    @Override
    public void exitWith_singleton_statement(MParser.With_singleton_statementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.typ);
        CategoryType type = new CategoryType(name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new WithSingletonStatement(type, stmts));
    }

    @Override
    public void exitWithResourceStatement(MParser.WithResourceStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitWithSingletonStatement(MParser.WithSingletonStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitWrite_statement(MParser.Write_statementContext ctx) {
        IExpression what = (IExpression)this.getNodeValue((ParseTree)ctx.what);
        IExpression target = (IExpression)this.getNodeValue((ParseTree)ctx.target);
        this.setNodeValue(ctx, new WriteStatement(what, target));
    }

    @Override
    public void exitWriteStatement(MParser.WriteStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    private Token findFirstValidToken(int idx) {
        if (idx == -1) {
            idx = 0;
        }
        do {
            Token token;
            if ((token = this.readValidToken(idx++)) == null) continue;
            return token;
        } while (idx < this.input.size());
        return null;
    }

    private Token findLastValidToken(int idx) {
        if (idx == -1) {
            idx = 0;
        }
        while (idx >= 0) {
            Token token;
            if ((token = this.readValidToken(idx--)) == null) continue;
            return token;
        }
        return null;
    }

    public <T> T getNodeValue(ParseTree node) {
        return (T)this.nodeValues.get(node);
    }

    private Token readValidToken(int idx) {
        Token token = this.input.get(idx);
        String text = token.getText();
        if (text != null && text.length() > 0 && !Character.isWhitespace(text.charAt(0))) {
            return token;
        }
        return null;
    }

    public void setNodeValue(ParserRuleContext node, Section value) {
        this.nodeValues.put((ParseTree)node, (Object)value);
        this.buildSection(node, value);
    }

    public void setNodeValue(ParseTree node, Object value) {
        this.nodeValues.put(node, value);
    }
}

