/*
 * Decompiled with CFR 0.152.
 */
package prompto.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import prompto.constraint.IAttributeConstraint;
import prompto.constraint.MatchingCollectionConstraint;
import prompto.constraint.MatchingExpressionConstraint;
import prompto.constraint.MatchingPatternConstraint;
import prompto.csharp.CSharpBooleanLiteral;
import prompto.csharp.CSharpCharacterLiteral;
import prompto.csharp.CSharpDecimalLiteral;
import prompto.csharp.CSharpExpression;
import prompto.csharp.CSharpExpressionList;
import prompto.csharp.CSharpIdentifierExpression;
import prompto.csharp.CSharpIntegerLiteral;
import prompto.csharp.CSharpMethodExpression;
import prompto.csharp.CSharpNativeCall;
import prompto.csharp.CSharpNativeCategoryBinding;
import prompto.csharp.CSharpSelectorExpression;
import prompto.csharp.CSharpStatement;
import prompto.csharp.CSharpTextLiteral;
import prompto.csharp.CSharpThisExpression;
import prompto.css.CssCode;
import prompto.css.CssExpression;
import prompto.css.CssField;
import prompto.css.CssText;
import prompto.css.ICssValue;
import prompto.declaration.AbstractMethodDeclaration;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.ConcreteMethodDeclaration;
import prompto.declaration.ConcreteWidgetDeclaration;
import prompto.declaration.DeclarationList;
import prompto.declaration.EnumeratedCategoryDeclaration;
import prompto.declaration.EnumeratedNativeDeclaration;
import prompto.declaration.GetterMethodDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.NativeGetterMethodDeclaration;
import prompto.declaration.NativeMethodDeclaration;
import prompto.declaration.NativeResourceDeclaration;
import prompto.declaration.NativeSetterMethodDeclaration;
import prompto.declaration.NativeWidgetDeclaration;
import prompto.declaration.OperatorMethodDeclaration;
import prompto.declaration.SetterMethodDeclaration;
import prompto.declaration.SingletonCategoryDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.expression.AndExpression;
import prompto.expression.ArrowExpression;
import prompto.expression.BlobExpression;
import prompto.expression.CastExpression;
import prompto.expression.CategorySymbol;
import prompto.expression.CodeExpression;
import prompto.expression.CompareExpression;
import prompto.expression.ConstructorExpression;
import prompto.expression.ContainsExpression;
import prompto.expression.DivideExpression;
import prompto.expression.DocumentExpression;
import prompto.expression.EqualsExpression;
import prompto.expression.ExecuteExpression;
import prompto.expression.FetchManyExpression;
import prompto.expression.FetchOneExpression;
import prompto.expression.FilteredExpression;
import prompto.expression.IExpression;
import prompto.expression.InstanceExpression;
import prompto.expression.IntDivideExpression;
import prompto.expression.ItemSelector;
import prompto.expression.IteratorExpression;
import prompto.expression.MemberSelector;
import prompto.expression.MethodExpression;
import prompto.expression.MinusExpression;
import prompto.expression.ModuloExpression;
import prompto.expression.MultiplyExpression;
import prompto.expression.MutableExpression;
import prompto.expression.NativeSymbol;
import prompto.expression.NotExpression;
import prompto.expression.OrExpression;
import prompto.expression.ParenthesisExpression;
import prompto.expression.PlusExpression;
import prompto.expression.ReadAllExpression;
import prompto.expression.ReadBlobExpression;
import prompto.expression.ReadOneExpression;
import prompto.expression.SelectorExpression;
import prompto.expression.SliceSelector;
import prompto.expression.SortedExpression;
import prompto.expression.SubtractExpression;
import prompto.expression.SuperExpression;
import prompto.expression.SymbolExpression;
import prompto.expression.TernaryExpression;
import prompto.expression.ThisExpression;
import prompto.expression.TypeExpression;
import prompto.expression.UnresolvedIdentifier;
import prompto.expression.UnresolvedSelector;
import prompto.grammar.Annotation;
import prompto.grammar.Argument;
import prompto.grammar.ArgumentList;
import prompto.grammar.CategorySymbolList;
import prompto.grammar.CmpOp;
import prompto.grammar.ContOp;
import prompto.grammar.EqOp;
import prompto.grammar.Identifier;
import prompto.grammar.MethodDeclarationList;
import prompto.grammar.NativeCategoryBinding;
import prompto.grammar.NativeCategoryBindingList;
import prompto.grammar.NativeSymbolList;
import prompto.grammar.Operator;
import prompto.grammar.OrderByClause;
import prompto.grammar.OrderByClauseList;
import prompto.grammar.ParameterList;
import prompto.instance.IAssignableInstance;
import prompto.instance.IAssignableSelector;
import prompto.instance.ItemInstance;
import prompto.instance.MemberInstance;
import prompto.instance.VariableInstance;
import prompto.java.JavaBooleanLiteral;
import prompto.java.JavaCharacterLiteral;
import prompto.java.JavaDecimalLiteral;
import prompto.java.JavaExpression;
import prompto.java.JavaExpressionList;
import prompto.java.JavaIdentifierExpression;
import prompto.java.JavaIntegerLiteral;
import prompto.java.JavaItemExpression;
import prompto.java.JavaMethodExpression;
import prompto.java.JavaNativeCall;
import prompto.java.JavaNativeCategoryBinding;
import prompto.java.JavaSelectorExpression;
import prompto.java.JavaStatement;
import prompto.java.JavaTextLiteral;
import prompto.java.JavaThisExpression;
import prompto.javascript.JavaScriptBooleanLiteral;
import prompto.javascript.JavaScriptCharacterLiteral;
import prompto.javascript.JavaScriptDecimalLiteral;
import prompto.javascript.JavaScriptExpression;
import prompto.javascript.JavaScriptExpressionList;
import prompto.javascript.JavaScriptIdentifierExpression;
import prompto.javascript.JavaScriptIntegerLiteral;
import prompto.javascript.JavaScriptItemExpression;
import prompto.javascript.JavaScriptMemberExpression;
import prompto.javascript.JavaScriptMethodExpression;
import prompto.javascript.JavaScriptModule;
import prompto.javascript.JavaScriptNativeCall;
import prompto.javascript.JavaScriptNativeCategoryBinding;
import prompto.javascript.JavaScriptNewExpression;
import prompto.javascript.JavaScriptSelectorExpression;
import prompto.javascript.JavaScriptStatement;
import prompto.javascript.JavaScriptTextLiteral;
import prompto.javascript.JavaScriptThisExpression;
import prompto.jsx.IJsxExpression;
import prompto.jsx.IJsxValue;
import prompto.jsx.JsxClosing;
import prompto.jsx.JsxCode;
import prompto.jsx.JsxElement;
import prompto.jsx.JsxExpression;
import prompto.jsx.JsxFragment;
import prompto.jsx.JsxLiteral;
import prompto.jsx.JsxProperty;
import prompto.jsx.JsxSelfClosing;
import prompto.jsx.JsxText;
import prompto.literal.BooleanLiteral;
import prompto.literal.CharacterLiteral;
import prompto.literal.DateLiteral;
import prompto.literal.DateTimeLiteral;
import prompto.literal.DecimalLiteral;
import prompto.literal.DictEntry;
import prompto.literal.DictEntryList;
import prompto.literal.DictIdentifierKey;
import prompto.literal.DictKey;
import prompto.literal.DictLiteral;
import prompto.literal.DictTextKey;
import prompto.literal.DocEntryList;
import prompto.literal.DocumentLiteral;
import prompto.literal.HexaLiteral;
import prompto.literal.IntegerLiteral;
import prompto.literal.ListLiteral;
import prompto.literal.MaxIntegerLiteral;
import prompto.literal.MinIntegerLiteral;
import prompto.literal.NullLiteral;
import prompto.literal.PeriodLiteral;
import prompto.literal.RangeLiteral;
import prompto.literal.SetLiteral;
import prompto.literal.TextLiteral;
import prompto.literal.TimeLiteral;
import prompto.literal.TupleLiteral;
import prompto.literal.TypeLiteral;
import prompto.literal.UuidLiteral;
import prompto.literal.VersionLiteral;
import prompto.param.CategoryParameter;
import prompto.param.CodeParameter;
import prompto.param.ExtendedParameter;
import prompto.param.IParameter;
import prompto.param.UnresolvedParameter;
import prompto.parser.Assertion;
import prompto.parser.Dialect;
import prompto.parser.OCleverParser;
import prompto.parser.OParser;
import prompto.parser.OParserBaseListener;
import prompto.parser.ParserUtils;
import prompto.parser.Section;
import prompto.python.Python2NativeCall;
import prompto.python.Python2NativeCategoryBinding;
import prompto.python.Python3NativeCall;
import prompto.python.Python3NativeCategoryBinding;
import prompto.python.PythonArgumentList;
import prompto.python.PythonBooleanLiteral;
import prompto.python.PythonCharacterLiteral;
import prompto.python.PythonDecimalLiteral;
import prompto.python.PythonExpression;
import prompto.python.PythonIdentifierExpression;
import prompto.python.PythonIntegerLiteral;
import prompto.python.PythonMethodExpression;
import prompto.python.PythonModule;
import prompto.python.PythonNamedArgument;
import prompto.python.PythonNativeCategoryBinding;
import prompto.python.PythonOrdinalArgument;
import prompto.python.PythonSelectorExpression;
import prompto.python.PythonSelfExpression;
import prompto.python.PythonStatement;
import prompto.python.PythonTextLiteral;
import prompto.statement.AssignInstanceStatement;
import prompto.statement.AssignTupleStatement;
import prompto.statement.AssignVariableStatement;
import prompto.statement.AtomicSwitchCase;
import prompto.statement.BaseSwitchStatement;
import prompto.statement.BreakStatement;
import prompto.statement.CollectionSwitchCase;
import prompto.statement.CommentStatement;
import prompto.statement.DeclarationStatement;
import prompto.statement.DoWhileStatement;
import prompto.statement.FetchManyStatement;
import prompto.statement.FetchOneStatement;
import prompto.statement.FlushStatement;
import prompto.statement.ForEachStatement;
import prompto.statement.IStatement;
import prompto.statement.IfStatement;
import prompto.statement.RaiseStatement;
import prompto.statement.RemoteCall;
import prompto.statement.ReturnStatement;
import prompto.statement.StatementList;
import prompto.statement.StoreStatement;
import prompto.statement.SwitchCase;
import prompto.statement.SwitchErrorStatement;
import prompto.statement.SwitchStatement;
import prompto.statement.UnresolvedCall;
import prompto.statement.WhileStatement;
import prompto.statement.WithResourceStatement;
import prompto.statement.WithSingletonStatement;
import prompto.statement.WriteStatement;
import prompto.type.AnyType;
import prompto.type.BlobType;
import prompto.type.BooleanType;
import prompto.type.CategoryType;
import prompto.type.CharacterType;
import prompto.type.CodeType;
import prompto.type.CssType;
import prompto.type.DateTimeType;
import prompto.type.DateType;
import prompto.type.DecimalType;
import prompto.type.DictType;
import prompto.type.DocumentType;
import prompto.type.HtmlType;
import prompto.type.IType;
import prompto.type.ImageType;
import prompto.type.IntegerType;
import prompto.type.IteratorType;
import prompto.type.ListType;
import prompto.type.NativeType;
import prompto.type.PeriodType;
import prompto.type.SetType;
import prompto.type.TextType;
import prompto.type.TimeType;
import prompto.type.UuidType;
import prompto.type.VersionType;
import prompto.utils.AssertionList;
import prompto.utils.ExpressionList;
import prompto.utils.IdentifierList;

public class OPromptoBuilder
extends OParserBaseListener {
    ParseTreeProperty<Object> nodeValues = new ParseTreeProperty();
    BufferedTokenStream input;
    String path = "";

    public OPromptoBuilder(OCleverParser parser) {
        this.input = (BufferedTokenStream)parser.getTokenStream();
        this.path = parser.getPath();
    }

    protected String getHiddenTokensAfter(TerminalNode node) {
        return this.getHiddenTokensAfter(node.getSymbol());
    }

    protected String getHiddenTokensAfter(Token token) {
        return this.getHiddenTokens(token, arg_0 -> ((BufferedTokenStream)this.input).getHiddenTokensToRight(arg_0));
    }

    protected String getHiddenTokens(Token token, Function<Integer, List<Token>> reader) {
        List<Token> hidden = reader.apply(token.getTokenIndex());
        if (hidden == null || hidden.isEmpty()) {
            return null;
        }
        return hidden.stream().map(Token::getText).collect(Collectors.joining());
    }

    protected String getHiddenTokensBefore(TerminalNode node) {
        return this.getHiddenTokensBefore(node.getSymbol());
    }

    protected String getHiddenTokensBefore(Token token) {
        return this.getHiddenTokens(token, arg_0 -> ((BufferedTokenStream)this.input).getHiddenTokensToLeft(arg_0));
    }

    public void buildSection(ParserRuleContext node, Section section) {
        Token first = this.findFirstValidToken(node.start.getTokenIndex());
        Token last = this.findLastValidToken(node.stop.getTokenIndex());
        section.setFrom(this.path, first, last, Dialect.O);
    }

    private List<Annotation> readAnnotations(List<? extends ParseTree> contexts) {
        List<Annotation> annotations = contexts.stream().map(cx -> (Annotation)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        return annotations.isEmpty() ? null : annotations;
    }

    private List<CommentStatement> readComments(List<? extends ParseTree> contexts) {
        List<CommentStatement> comments = contexts.stream().map(cx -> (CommentStatement)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        return comments.isEmpty() ? null : comments;
    }

    @Override
    public void exitAbstract_method_declaration(OParser.Abstract_method_declarationContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        if (type instanceof CategoryType) {
            ((CategoryType)type).setMutable(ctx.MUTABLE() != null);
        }
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ParameterList args = (ParameterList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new AbstractMethodDeclaration(name, args, type));
    }

    @Override
    public void exitAddExpression(OParser.AddExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        IExpression exp = ctx.op.getType() == 28 ? new PlusExpression(left, right) : new SubtractExpression(left, right);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitAn_expression(OParser.An_expressionContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitAndExpression(OParser.AndExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new AndExpression(left, right));
    }

    @Override
    public void exitAnnotation_constructor(OParser.Annotation_constructorContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        DictEntryList args = new DictEntryList();
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        if (exp != null) {
            args.add(new DictEntry(null, exp));
        }
        ctx.annotation_argument().forEach(argCtx -> {
            DictEntry arg = (DictEntry)this.getNodeValue((ParseTree)argCtx);
            args.add(arg);
        });
        this.setNodeValue(ctx, new Annotation(name, args));
    }

    @Override
    public void exitAnnotation_argument(OParser.Annotation_argumentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new DictEntry(new DictIdentifierKey(name), exp));
    }

    @Override
    public void exitAnnotation_identifier(OParser.Annotation_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitAnnotation_argument_name(OParser.Annotation_argument_nameContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitAnnotationLiteralValue(OParser.AnnotationLiteralValueContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitAnnotationTypeValue(OParser.AnnotationTypeValueContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        this.setNodeValue((ParseTree)ctx, new TypeExpression(type));
    }

    @Override
    public void exitAnyDictType(OParser.AnyDictTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.any_type());
        this.setNodeValue(ctx, new DictType(type));
    }

    @Override
    public void exitAnyListType(OParser.AnyListTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.any_type());
        this.setNodeValue(ctx, new ListType(type));
    }

    @Override
    public void exitAnyType(OParser.AnyTypeContext ctx) {
        this.setNodeValue(ctx, AnyType.instance());
    }

    @Override
    public void exitArgument_assignment(OParser.Argument_assignmentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        UnresolvedParameter arg = new UnresolvedParameter(name);
        Argument item = new Argument(arg, exp);
        this.setNodeValue((ParseTree)ctx, item);
    }

    @Override
    public void exitArgument_list(OParser.Argument_listContext ctx) {
        ParameterList items = new ParameterList();
        ctx.argument().forEach(a -> {
            IParameter item = (IParameter)this.getNodeValue((ParseTree)a);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitArgumentAssignmentList(OParser.ArgumentAssignmentListContext ctx) {
        Argument item = (Argument)this.getNodeValue((ParseTree)ctx.item);
        ArgumentList items = new ArgumentList((Collection<Argument>)Collections.singletonList(item));
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitArgumentAssignmentListItem(OParser.ArgumentAssignmentListItemContext ctx) {
        Argument item = (Argument)this.getNodeValue((ParseTree)ctx.item);
        ArgumentList items = (ArgumentList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitArrow_prefix(OParser.Arrow_prefixContext ctx) {
        IdentifierList args = (IdentifierList)this.getNodeValue((ParseTree)ctx.arrow_args());
        String argsSuite = this.getHiddenTokensBefore(ctx.EGT());
        String arrowSuite = this.getHiddenTokensAfter(ctx.EGT());
        this.setNodeValue(ctx, new ArrowExpression(args, argsSuite, arrowSuite));
    }

    @Override
    public void exitArrowExpression(OParser.ArrowExpressionContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.exp));
    }

    @Override
    public void exitArrowExpressionBody(OParser.ArrowExpressionBodyContext ctx) {
        ArrowExpression arrow = (ArrowExpression)this.getNodeValue((ParseTree)ctx.arrow_prefix());
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        arrow.setExpression(exp);
        this.setNodeValue(ctx, arrow);
    }

    @Override
    public void exitArrowListArg(OParser.ArrowListArgContext ctx) {
        IdentifierList list = (IdentifierList)this.getNodeValue((ParseTree)ctx.variable_identifier_list());
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitArrowSingleArg(OParser.ArrowSingleArgContext ctx) {
        Identifier arg = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        this.setNodeValue((ParseTree)ctx, new IdentifierList(arg));
    }

    @Override
    public void exitArrowStatementsBody(OParser.ArrowStatementsBodyContext ctx) {
        ArrowExpression arrow = (ArrowExpression)this.getNodeValue((ParseTree)ctx.arrow_prefix());
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.statement_list());
        arrow.setStatements(stmts);
        this.setNodeValue(ctx, arrow);
    }

    @Override
    public void exitAssertion(OParser.AssertionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new Assertion(exp));
    }

    @Override
    public void exitAssertion_list(OParser.Assertion_listContext ctx) {
        AssertionList items = new AssertionList();
        ctx.assertion().forEach(a -> {
            Assertion item = (Assertion)this.getNodeValue((ParseTree)a);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitAssign_instance_statement(OParser.Assign_instance_statementContext ctx) {
        IAssignableInstance inst = (IAssignableInstance)this.getNodeValue((ParseTree)ctx.inst);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new AssignInstanceStatement(inst, exp));
    }

    @Override
    public void exitAssign_tuple_statement(OParser.Assign_tuple_statementContext ctx) {
        IdentifierList items = (IdentifierList)this.getNodeValue((ParseTree)ctx.items);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new AssignTupleStatement(items, exp));
    }

    @Override
    public void exitAssign_variable_statement(OParser.Assign_variable_statementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue(ctx, new AssignVariableStatement(name, exp));
    }

    @Override
    public void exitAssignInstanceStatement(OParser.AssignInstanceStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitAssignTupleStatement(OParser.AssignTupleStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitAtomicSwitchCase(OParser.AtomicSwitchCaseContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new AtomicSwitchCase(exp, stmts));
    }

    @Override
    public void exitAttribute_declaration(OParser.Attribute_declarationContext ctx) {
        IdentifierList indices;
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        IAttributeConstraint match = (IAttributeConstraint)this.getNodeValue((ParseTree)ctx.match);
        IdentifierList identifierList = indices = ctx.INDEX() != null ? new IdentifierList() : null;
        if (ctx.indices != null) {
            indices.addAll((Collection)this.getNodeValue((ParseTree)ctx.indices));
        }
        AttributeDeclaration decl = new AttributeDeclaration(name, type, match, indices);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitAttribute_identifier(OParser.Attribute_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitAttribute_identifier_list(OParser.Attribute_identifier_listContext ctx) {
        IdentifierList list = new IdentifierList();
        for (OParser.Attribute_identifierContext v : ctx.attribute_identifier()) {
            Identifier item = (Identifier)this.getNodeValue((ParseTree)v);
            list.add(item);
        }
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitBlob_expression(OParser.Blob_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue((ParseTree)ctx, new BlobExpression(exp));
    }

    @Override
    public void exitBlobType(OParser.BlobTypeContext ctx) {
        this.setNodeValue(ctx, BlobType.instance());
    }

    @Override
    public void exitBooleanLiteral(OParser.BooleanLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new BooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitBooleanType(OParser.BooleanTypeContext ctx) {
        this.setNodeValue(ctx, BooleanType.instance());
    }

    @Override
    public void exitBreakStatement(OParser.BreakStatementContext ctx) {
        this.setNodeValue(ctx, new BreakStatement());
    }

    @Override
    public void exitCastExpression(OParser.CastExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IType type = (IType)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new CastExpression(exp, type, ctx.MUTABLE() != null));
    }

    @Override
    public void exitCatch_statement_list(OParser.Catch_statement_listContext ctx) {
        BaseSwitchStatement.SwitchCaseList items = new BaseSwitchStatement.SwitchCaseList();
        ctx.catch_statement().forEach(s -> {
            SwitchCase item = (SwitchCase)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCatchAtomicStatement(OParser.CatchAtomicStatementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new AtomicSwitchCase(new SymbolExpression(name), stmts));
    }

    @Override
    public void exitCatchCollectionStatement(OParser.CatchCollectionStatementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new CollectionSwitchCase(exp, stmts));
    }

    @Override
    public void exitCategory_or_any_type(OParser.Category_or_any_typeContext ctx) {
        IType type = (IType)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitCategory_symbol(OParser.Category_symbolContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new CategorySymbol(name, args));
    }

    @Override
    public void exitCategory_symbol_list(OParser.Category_symbol_listContext ctx) {
        CategorySymbolList items = new CategorySymbolList();
        ctx.category_symbol().forEach(s -> {
            CategorySymbol item = (CategorySymbol)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCategory_type(OParser.Category_typeContext ctx) {
        Identifier name = new Identifier(ctx.getText());
        this.setNodeValue(ctx, new CategoryType(name));
    }

    @Override
    public void exitCategoryType(OParser.CategoryTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.c);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitCharacterLiteral(OParser.CharacterLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitCharacterType(OParser.CharacterTypeContext ctx) {
        this.setNodeValue(ctx, CharacterType.instance());
    }

    @Override
    public void exitChildInstance(OParser.ChildInstanceContext ctx) {
        IAssignableInstance parent = (IAssignableInstance)this.getNodeValue((ParseTree)ctx.assignable_instance());
        IAssignableSelector child = (IAssignableSelector)this.getNodeValue((ParseTree)ctx.child_instance());
        child.setParent(parent);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitClosure_expression(OParser.Closure_expressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new MethodExpression(name));
    }

    @Override
    public void exitClosureExpression(OParser.ClosureExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitClosureStatement(OParser.ClosureStatementContext ctx) {
        ConcreteMethodDeclaration decl = (ConcreteMethodDeclaration)this.getNodeValue((ParseTree)ctx.decl);
        this.setNodeValue(ctx, new DeclarationStatement<ConcreteMethodDeclaration>(decl));
    }

    @Override
    public void exitCode_argument(OParser.Code_argumentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new CodeParameter(name));
    }

    @Override
    public void exitCode_type(OParser.Code_typeContext ctx) {
        this.setNodeValue(ctx, CodeType.instance());
    }

    @Override
    public void exitCodeArgument(OParser.CodeArgumentContext ctx) {
        IParameter arg = (IParameter)this.getNodeValue((ParseTree)ctx.arg);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitCodeExpression(OParser.CodeExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CodeExpression(exp));
    }

    @Override
    public void exitCodeType(OParser.CodeTypeContext ctx) {
        this.setNodeValue(ctx, CodeType.instance());
    }

    @Override
    public void exitCollection_literal(OParser.Collection_literalContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCollectionSwitchCase(OParser.CollectionSwitchCaseContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new CollectionSwitchCase(exp, stmts));
    }

    @Override
    public void exitCommentStatement(OParser.CommentStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.comment_statement()));
    }

    @Override
    public void exitComment_statement(OParser.Comment_statementContext ctx) {
        this.setNodeValue(ctx, new CommentStatement(ctx.getText()));
    }

    @Override
    public void exitConcrete_category_declaration(OParser.Concrete_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        IdentifierList derived = (IdentifierList)this.getNodeValue((ParseTree)ctx.derived);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        ConcreteCategoryDeclaration decl = new ConcreteCategoryDeclaration(name, attrs, derived, methods);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitConcrete_method_declaration(OParser.Concrete_method_declarationContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        if (type instanceof CategoryType) {
            ((CategoryType)type).setMutable(ctx.MUTABLE() != null);
        }
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ParameterList args = (ParameterList)this.getNodeValue((ParseTree)ctx.args);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new ConcreteMethodDeclaration(name, args, type, stmts));
    }

    @Override
    public void exitConcrete_widget_declaration(OParser.Concrete_widget_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        Identifier derived = (Identifier)this.getNodeValue((ParseTree)ctx.derived);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        ConcreteWidgetDeclaration decl = new ConcreteWidgetDeclaration(name, derived, methods);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitConcreteCategoryDeclaration(OParser.ConcreteCategoryDeclarationContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.decl));
    }

    @Override
    public void exitConcreteWidgetDeclaration(OParser.ConcreteWidgetDeclarationContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.decl));
    }

    @Override
    public void exitConstructorFrom(OParser.ConstructorFromContext ctx) {
        CategoryType type = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression copyFrom = (IExpression)this.getNodeValue((ParseTree)ctx.copyExp);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new ConstructorExpression(type, copyFrom, args, true));
    }

    @Override
    public void exitConstructorNoFrom(OParser.ConstructorNoFromContext ctx) {
        CategoryType type = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new ConstructorExpression(type, null, args, true));
    }

    @Override
    public void exitCopy_from(OParser.Copy_fromContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.exp));
    }

    @Override
    public void exitCssType(OParser.CssTypeContext ctx) {
        this.setNodeValue(ctx, CssType.instance());
    }

    @Override
    public void exitHasExpression(OParser.HasExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.HAS, right));
    }

    @Override
    public void exitHasAllExpression(OParser.HasAllExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.HAS_ALL, right));
    }

    @Override
    public void exitHasAnyExpression(OParser.HasAnyExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.HAS_ANY, right));
    }

    @Override
    public void exitContainsExpression(OParser.ContainsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.CONTAINS, right));
    }

    @Override
    public void exitCsharp_identifier(OParser.Csharp_identifierContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitCsharp_method_expression(OParser.Csharp_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        CSharpExpressionList args = (CSharpExpressionList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue((ParseTree)ctx, new CSharpMethodExpression(name, args));
    }

    @Override
    public void exitCsharp_primary_expression(OParser.Csharp_primary_expressionContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCsharp_this_expression(OParser.Csharp_this_expressionContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpThisExpression());
    }

    @Override
    public void exitCSharpArgumentList(OParser.CSharpArgumentListContext ctx) {
        CSharpExpression item = (CSharpExpression)this.getNodeValue((ParseTree)ctx.item);
        this.setNodeValue((ParseTree)ctx, new CSharpExpressionList(item));
    }

    @Override
    public void exitCSharpArgumentListItem(OParser.CSharpArgumentListItemContext ctx) {
        CSharpExpression item = (CSharpExpression)this.getNodeValue((ParseTree)ctx.item);
        CSharpExpressionList items = (CSharpExpressionList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCSharpBooleanLiteral(OParser.CSharpBooleanLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpBooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpCategoryBinding(OParser.CSharpCategoryBindingContext ctx) {
        CSharpIdentifierExpression map = (CSharpIdentifierExpression)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new CSharpNativeCategoryBinding(map));
    }

    @Override
    public void exitCSharpCharacterLiteral(OParser.CSharpCharacterLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpCharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpChildIdentifier(OParser.CSharpChildIdentifierContext ctx) {
        CSharpIdentifierExpression parent = (CSharpIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        CSharpIdentifierExpression child = new CSharpIdentifierExpression(parent, name);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitCSharpDecimalLiteral(OParser.CSharpDecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpDecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpIdentifier(OParser.CSharpIdentifierContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new CSharpIdentifierExpression(name));
    }

    @Override
    public void exitCSharpIntegerLiteral(OParser.CSharpIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpIntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitCSharpMethodExpression(OParser.CSharpMethodExpressionContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCSharpNativeStatement(OParser.CSharpNativeStatementContext ctx) {
        CSharpStatement stmt = (CSharpStatement)this.getNodeValue((ParseTree)ctx.csharp_statement());
        this.setNodeValue(ctx, new CSharpNativeCall(stmt));
    }

    @Override
    public void exitCSharpPromptoIdentifier(OParser.CSharpPromptoIdentifierContext ctx) {
        String name = ctx.DOLLAR_IDENTIFIER().getText();
        this.setNodeValue((ParseTree)ctx, new CSharpIdentifierExpression(name));
    }

    @Override
    public void exitCSharpPrimaryExpression(OParser.CSharpPrimaryExpressionContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitCSharpReturnStatement(OParser.CSharpReturnStatementContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CSharpStatement(exp, true));
    }

    @Override
    public void exitCSharpSelectorExpression(OParser.CSharpSelectorExpressionContext ctx) {
        CSharpExpression parent = (CSharpExpression)this.getNodeValue((ParseTree)ctx.parent);
        CSharpSelectorExpression child = (CSharpSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        child.setParent(parent);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitCSharpStatement(OParser.CSharpStatementContext ctx) {
        CSharpExpression exp = (CSharpExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CSharpStatement(exp, false));
    }

    @Override
    public void exitCSharpTextLiteral(OParser.CSharpTextLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new CSharpTextLiteral(ctx.getText()));
    }

    @Override
    public void exitCssExpression(OParser.CssExpressionContext ctx) {
        this.setNodeValue(ctx, (CssExpression)this.getNodeValue((ParseTree)ctx.exp));
    }

    @Override
    public void exitCss_expression(OParser.Css_expressionContext ctx) {
        CssExpression exp = new CssExpression();
        ctx.css_field().forEach(cx -> {
            CssField field = (CssField)this.getNodeValue((ParseTree)cx);
            exp.addField(field);
        });
        this.setNodeValue(ctx, exp);
    }

    @Override
    public void exitCss_field(OParser.Css_fieldContext ctx) {
        String name = ctx.name.getText();
        ICssValue value = (ICssValue)this.getNodeValue((ParseTree)ctx.value);
        this.setNodeValue((ParseTree)ctx, new CssField(name, value));
    }

    @Override
    public void exitCssText(OParser.CssTextContext ctx) {
        String text = this.input.getText(ctx.text.start, ctx.text.stop);
        this.setNodeValue((ParseTree)ctx, new CssText(text));
    }

    @Override
    public void exitCssValue(OParser.CssValueContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new CssCode(exp));
    }

    @Override
    public void exitCurlyCategoryMethodList(OParser.CurlyCategoryMethodListContext ctx) {
        MethodDeclarationList items = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.items);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitCurlyStatementList(OParser.CurlyStatementListContext ctx) {
        this.setNodeValue((ParseTree)ctx, this.getNodeValue((ParseTree)ctx.items));
    }

    @Override
    public void exitCursorType(OParser.CursorTypeContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exitDateLiteral(OParser.DateLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new DateLiteral(ctx.getText()));
    }

    @Override
    public void exitDateTimeLiteral(OParser.DateTimeLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new DateTimeLiteral(ctx.getText()));
    }

    @Override
    public void exitDateTimeType(OParser.DateTimeTypeContext ctx) {
        this.setNodeValue(ctx, DateTimeType.instance());
    }

    @Override
    public void exitDateType(OParser.DateTypeContext ctx) {
        this.setNodeValue(ctx, DateType.instance());
    }

    @Override
    public void exitDecimalLiteral(OParser.DecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new DecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitDecimalType(OParser.DecimalTypeContext ctx) {
        this.setNodeValue(ctx, DecimalType.instance());
    }

    @Override
    public void exitDeclaration(OParser.DeclarationContext ctx) {
        List<CommentStatement> comments = this.readComments(ctx.comment_statement());
        List<Annotation> annotations = this.readAnnotations(ctx.annotation_constructor());
        ParseTree ctx_ = ctx.getChild(ctx.getChildCount() - 1);
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx_);
        if (decl != null) {
            decl.setComments(comments);
            decl.setAnnotations(annotations);
            this.setNodeValue((ParseTree)ctx, decl);
        }
    }

    @Override
    public void exitDeclarations(OParser.DeclarationsContext ctx) {
        DeclarationList items = new DeclarationList();
        ctx.declaration().forEach(d -> {
            IDeclaration item = (IDeclaration)this.getNodeValue((ParseTree)d);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitDerivedList(OParser.DerivedListContext ctx) {
        Identifier item = (Identifier)this.getNodeValue((ParseTree)ctx.item);
        this.setNodeValue((ParseTree)ctx, new IdentifierList(item));
    }

    @Override
    public void exitDerivedListItem(OParser.DerivedListItemContext ctx) {
        IdentifierList items = (IdentifierList)this.getNodeValue((ParseTree)ctx.items);
        Identifier item = (Identifier)this.getNodeValue((ParseTree)ctx.item);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitDict_entry(OParser.Dict_entryContext ctx) {
        DictKey key = (DictKey)this.getNodeValue((ParseTree)ctx.key);
        IExpression value = (IExpression)this.getNodeValue((ParseTree)ctx.value);
        DictEntry entry = new DictEntry(key, value);
        this.setNodeValue((ParseTree)ctx, entry);
    }

    @Override
    public void exitDict_literal(OParser.Dict_literalContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        DictEntryList items = (DictEntryList)this.getNodeValue((ParseTree)ctx.dict_entry_list());
        DictLiteral value = items == null ? new DictLiteral(mutable) : new DictLiteral(items, mutable);
        this.setNodeValue((ParseTree)ctx, value);
    }

    @Override
    public void exitDict_entry_list(OParser.Dict_entry_listContext ctx) {
        DictEntryList items = new DictEntryList();
        ctx.dict_entry().forEach(e -> {
            DictEntry item = (DictEntry)this.getNodeValue((ParseTree)e);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitDictKeyIdentifier(OParser.DictKeyIdentifierContext ctx) {
        String text = ctx.name.getText();
        this.setNodeValue(ctx, new DictIdentifierKey(new Identifier(text)));
    }

    @Override
    public void exitDictKeyText(OParser.DictKeyTextContext ctx) {
        String text = ctx.name.getText();
        this.setNodeValue(ctx, new DictTextKey(text));
    }

    @Override
    public void exitDictType(OParser.DictTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.d);
        this.setNodeValue(ctx, new DictType(type));
    }

    @Override
    public void exitDivideExpression(OParser.DivideExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new DivideExpression(left, right));
    }

    @Override
    public void exitDo_while_statement(OParser.Do_while_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new DoWhileStatement(exp, stmts));
    }

    @Override
    public void exitDocument_expression(OParser.Document_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue((ParseTree)ctx, new DocumentExpression(exp));
    }

    @Override
    public void exitDocumentType(OParser.DocumentTypeContext ctx) {
        this.setNodeValue(ctx, DocumentType.instance());
    }

    @Override
    public void exitDocument_literal(OParser.Document_literalContext ctx) {
        DictEntryList entries = (DictEntryList)this.getNodeValue((ParseTree)ctx.dict_entry_list());
        DocEntryList items = entries != null ? new DocEntryList(entries) : new DocEntryList();
        this.setNodeValue((ParseTree)ctx, new DocumentLiteral(items));
    }

    @Override
    public void exitDoWhileStatement(OParser.DoWhileStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitElseIfStatementList(OParser.ElseIfStatementListContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        IfStatement.IfElement elem = new IfStatement.IfElement(exp, stmts);
        this.setNodeValue((ParseTree)ctx, new IfStatement.IfElementList(elem));
    }

    @Override
    public void exitElseIfStatementListItem(OParser.ElseIfStatementListItemContext ctx) {
        IfStatement.IfElementList items = (IfStatement.IfElementList)this.getNodeValue((ParseTree)ctx.items);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        IfStatement.IfElement elem = new IfStatement.IfElement(exp, stmts);
        items.add(elem);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitEmptyCategoryMethodList(OParser.EmptyCategoryMethodListContext ctx) {
        this.setNodeValue((ParseTree)ctx, new MethodDeclarationList());
    }

    @Override
    public void exitEnum_category_declaration(OParser.Enum_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        Identifier parent = (Identifier)this.getNodeValue((ParseTree)ctx.derived);
        IdentifierList derived = parent == null ? null : new IdentifierList(parent);
        CategorySymbolList symbols = (CategorySymbolList)this.getNodeValue((ParseTree)ctx.symbols);
        this.setNodeValue(ctx, new EnumeratedCategoryDeclaration(name, attrs, derived, symbols));
    }

    @Override
    public void exitEnum_native_declaration(OParser.Enum_native_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        NativeType type = (NativeType)this.getNodeValue((ParseTree)ctx.typ);
        NativeSymbolList symbols = (NativeSymbolList)this.getNodeValue((ParseTree)ctx.symbols);
        this.setNodeValue(ctx, new EnumeratedNativeDeclaration(name, type, symbols));
    }

    @Override
    public void exitEnum_declaration(OParser.Enum_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitEqualsExpression(OParser.EqualsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.EQUALS, right));
    }

    @Override
    public void exitExecuteExpression(OParser.ExecuteExpressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue(ctx, new ExecuteExpression(name));
    }

    @Override
    public void exitExpression_list(OParser.Expression_listContext ctx) {
        ExpressionList items = new ExpressionList();
        ctx.expression().forEach(e -> {
            IExpression item = (IExpression)this.getNodeValue((ParseTree)e);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitExpression_tuple(OParser.Expression_tupleContext ctx) {
        ExpressionList items = new ExpressionList();
        ctx.expression().forEach(e -> {
            IExpression item = (IExpression)this.getNodeValue((ParseTree)e);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitExpressionAssignmentList(OParser.ExpressionAssignmentListContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        Argument item = new Argument(null, exp);
        ArgumentList items = new ArgumentList((Collection<Argument>)Collections.singletonList(item));
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitFetchStatement(OParser.FetchStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitFetchOne(OParser.FetchOneContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        this.setNodeValue(ctx, new FetchOneExpression(category, filter));
    }

    @Override
    public void exitFetchOneAsync(OParser.FetchOneAsyncContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new FetchOneStatement(category, filter, name, stmts));
    }

    @Override
    public void exitFetchMany(OParser.FetchManyContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression start = (IExpression)this.getNodeValue((ParseTree)ctx.xstart);
        IExpression stop = (IExpression)this.getNodeValue((ParseTree)ctx.xstop);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        OrderByClauseList orderBy = (OrderByClauseList)this.getNodeValue((ParseTree)ctx.orderby);
        this.setNodeValue(ctx, new FetchManyExpression(category, start, stop, filter, orderBy));
    }

    @Override
    public void exitFetchManyAsync(OParser.FetchManyAsyncContext ctx) {
        CategoryType category = (CategoryType)this.getNodeValue((ParseTree)ctx.typ);
        IExpression start = (IExpression)this.getNodeValue((ParseTree)ctx.xstart);
        IExpression stop = (IExpression)this.getNodeValue((ParseTree)ctx.xstop);
        IExpression predicate = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        OrderByClauseList orderBy = (OrderByClauseList)this.getNodeValue((ParseTree)ctx.orderby);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new FetchManyStatement(category, start, stop, predicate, orderBy, name, stmts));
    }

    @Override
    public void exitFiltered_list_expression(OParser.Filtered_list_expressionContext ctx) {
        Identifier itemName = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        IExpression filter = (IExpression)this.getNodeValue((ParseTree)ctx.predicate);
        this.setNodeValue(ctx, new FilteredExpression(itemName, source, filter));
    }

    @Override
    public void exitFlush_statement(OParser.Flush_statementContext ctx) {
        this.setNodeValue(ctx, new FlushStatement());
    }

    @Override
    public void exitFlushStatement(OParser.FlushStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitFor_each_statement(OParser.For_each_statementContext ctx) {
        Identifier name1 = (Identifier)this.getNodeValue((ParseTree)ctx.name1);
        Identifier name2 = (Identifier)this.getNodeValue((ParseTree)ctx.name2);
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new ForEachStatement(name1, name2, source, stmts));
    }

    @Override
    public void exitForEachStatement(OParser.ForEachStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitFullDeclarationList(OParser.FullDeclarationListContext ctx) {
        DeclarationList items = (DeclarationList)this.getNodeValue((ParseTree)ctx.declarations());
        if (items == null) {
            items = new DeclarationList();
        }
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitGetter_method_declaration(OParser.Getter_method_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new GetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitGreaterThanExpression(OParser.GreaterThanExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.GT, right));
    }

    @Override
    public void exitGreaterThanOrEqualExpression(OParser.GreaterThanOrEqualExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.GTE, right));
    }

    @Override
    public void exitHexadecimalLiteral(OParser.HexadecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new HexaLiteral(ctx.getText()));
    }

    @Override
    public void exitHtmlType(OParser.HtmlTypeContext ctx) {
        this.setNodeValue(ctx, HtmlType.instance());
    }

    @Override
    public void exitIdentifierExpression(OParser.IdentifierExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitIf_statement(OParser.If_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        IfStatement.IfElementList elseIfs = (IfStatement.IfElementList)this.getNodeValue((ParseTree)ctx.elseIfs);
        StatementList elseStmts = (StatementList)this.getNodeValue((ParseTree)ctx.elseStmts);
        this.setNodeValue(ctx, new IfStatement(exp, stmts, elseIfs, elseStmts));
    }

    @Override
    public void exitIfStatement(OParser.IfStatementContext ctx) {
        this.setNodeValue((ParseTree)ctx, this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitImageType(OParser.ImageTypeContext ctx) {
        this.setNodeValue(ctx, ImageType.instance());
    }

    @Override
    public void exitInExpression(OParser.InExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.IN, right));
    }

    @Override
    public void exitInstanceExpression(OParser.InstanceExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitIntDivideExpression(OParser.IntDivideExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new IntDivideExpression(left, right));
    }

    @Override
    public void exitIntegerLiteral(OParser.IntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new IntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitIntegerType(OParser.IntegerTypeContext ctx) {
        this.setNodeValue(ctx, IntegerType.instance());
    }

    @Override
    public void exitIsAnExpression(OParser.IsAnExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IType type = (IType)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.IS_A, new TypeExpression(type)));
    }

    @Override
    public void exitIsATypeExpression(OParser.IsATypeExpressionContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.category_or_any_type());
        TypeExpression exp = new TypeExpression(type);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitIsExpression(OParser.IsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        EqOp op = right instanceof TypeExpression ? EqOp.IS_A : EqOp.IS;
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, op, right));
    }

    @Override
    public void exitIsNotAnExpression(OParser.IsNotAnExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IType type = (IType)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.IS_NOT_A, new TypeExpression(type)));
    }

    @Override
    public void exitIsNotExpression(OParser.IsNotExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        EqOp op = right instanceof TypeExpression ? EqOp.IS_NOT_A : EqOp.IS_NOT;
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, op, right));
    }

    @Override
    public void exitIsOtherExpression(OParser.IsOtherExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitItemInstance(OParser.ItemInstanceContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new ItemInstance(exp));
    }

    @Override
    public void exitItemSelector(OParser.ItemSelectorContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new ItemSelector(exp));
    }

    @Override
    public void exitIteratorExpression(OParser.IteratorExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new IteratorExpression(name, source, exp));
    }

    @Override
    public void exitIteratorType(OParser.IteratorTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.i);
        this.setNodeValue(ctx, new IteratorType(type));
    }

    @Override
    public void exitJava_identifier(OParser.Java_identifierContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitJava_item_expression(OParser.Java_item_expressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new JavaItemExpression(exp));
    }

    @Override
    public void exitJava_method_expression(OParser.Java_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        JavaExpressionList args = (JavaExpressionList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new JavaMethodExpression(name, args));
    }

    @Override
    public void exitJava_parenthesis_expression(OParser.Java_parenthesis_expressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJava_primary_expression(OParser.Java_primary_expressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJava_this_expression(OParser.Java_this_expressionContext ctx) {
        this.setNodeValue(ctx, new JavaThisExpression());
    }

    @Override
    public void exitJavaArgumentList(OParser.JavaArgumentListContext ctx) {
        JavaExpression item = (JavaExpression)this.getNodeValue((ParseTree)ctx.item);
        this.setNodeValue((ParseTree)ctx, new JavaExpressionList(item));
    }

    @Override
    public void exitJavaArgumentListItem(OParser.JavaArgumentListItemContext ctx) {
        JavaExpression item = (JavaExpression)this.getNodeValue((ParseTree)ctx.item);
        JavaExpressionList items = (JavaExpressionList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitJavaBooleanLiteral(OParser.JavaBooleanLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaBooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaCategoryBinding(OParser.JavaCategoryBindingContext ctx) {
        JavaIdentifierExpression map = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new JavaNativeCategoryBinding(map));
    }

    @Override
    public void exitJavaCharacterLiteral(OParser.JavaCharacterLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaCharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaChildClassIdentifier(OParser.JavaChildClassIdentifierContext ctx) {
        JavaIdentifierExpression parent = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        JavaIdentifierExpression child = new JavaIdentifierExpression(parent, ctx.name.getText());
        this.setNodeValue(ctx, child);
    }

    @Override
    public void exitJavaChildIdentifier(OParser.JavaChildIdentifierContext ctx) {
        JavaIdentifierExpression parent = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        JavaIdentifierExpression child = new JavaIdentifierExpression(parent, name);
        this.setNodeValue(ctx, child);
    }

    @Override
    public void exitJavaClassIdentifier(OParser.JavaClassIdentifierContext ctx) {
        JavaIdentifierExpression klass = (JavaIdentifierExpression)this.getNodeValue((ParseTree)ctx.klass);
        this.setNodeValue(ctx, klass);
    }

    @Override
    public void exitJavaDecimalLiteral(OParser.JavaDecimalLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaDecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaIdentifier(OParser.JavaIdentifierContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue(ctx, new JavaIdentifierExpression(name));
    }

    @Override
    public void exitJavaIntegerLiteral(OParser.JavaIntegerLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaIntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitJavaItemExpression(OParser.JavaItemExpressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaMethodExpression(OParser.JavaMethodExpressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaNativeStatement(OParser.JavaNativeStatementContext ctx) {
        JavaStatement stmt = (JavaStatement)this.getNodeValue((ParseTree)ctx.java_statement());
        this.setNodeValue(ctx, new JavaNativeCall(stmt));
    }

    @Override
    public void exitJavaPrimaryExpression(OParser.JavaPrimaryExpressionContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaReturnStatement(OParser.JavaReturnStatementContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaStatement(exp, true));
    }

    @Override
    public void exitJavascript_category_binding(OParser.Javascript_category_bindingContext ctx) {
        String identifier = ctx.javascript_identifier().stream().map(cx -> cx.getText()).collect(Collectors.joining("."));
        JavaScriptModule module = (JavaScriptModule)this.getNodeValue((ParseTree)ctx.javascript_module());
        JavaScriptNativeCategoryBinding map = new JavaScriptNativeCategoryBinding(identifier, module);
        this.setNodeValue((ParseTree)ctx, map);
    }

    @Override
    public void exitJavascript_identifier(OParser.Javascript_identifierContext ctx) {
        String name = ctx.getText();
        this.setNodeValue((ParseTree)ctx, name);
    }

    @Override
    public void exitJavascript_identifier_expression(OParser.Javascript_identifier_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new JavaScriptIdentifierExpression(name));
    }

    @Override
    public void exitJavascript_method_expression(OParser.Javascript_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        JavaScriptMethodExpression method = new JavaScriptMethodExpression(name);
        JavaScriptExpressionList args = (JavaScriptExpressionList)this.getNodeValue((ParseTree)ctx.args);
        method.setArguments(args);
        this.setNodeValue((ParseTree)ctx, method);
    }

    @Override
    public void exitJavascript_module(OParser.Javascript_moduleContext ctx) {
        ArrayList<String> ids = new ArrayList<String>();
        for (OParser.Javascript_identifierContext ic : ctx.javascript_identifier()) {
            ids.add(ic.getText());
        }
        JavaScriptModule module = new JavaScriptModule(ids);
        this.setNodeValue((ParseTree)ctx, module);
    }

    @Override
    public void exitJavascript_native_statement(OParser.Javascript_native_statementContext ctx) {
        JavaScriptStatement stmt = (JavaScriptStatement)this.getNodeValue((ParseTree)ctx.javascript_statement());
        JavaScriptModule module = (JavaScriptModule)this.getNodeValue((ParseTree)ctx.javascript_module());
        stmt.setModule(module);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitJavascript_new_expression(OParser.Javascript_new_expressionContext ctx) {
        JavaScriptMethodExpression exp = (JavaScriptMethodExpression)this.getNodeValue((ParseTree)ctx.javascript_method_expression());
        this.setNodeValue((ParseTree)ctx, new JavaScriptNewExpression(exp));
    }

    @Override
    public void exitJavascript_primary_expression(OParser.Javascript_primary_expressionContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavascript_this_expression(OParser.Javascript_this_expressionContext ctx) {
        this.setNodeValue((ParseTree)ctx, new JavaScriptThisExpression());
    }

    @Override
    public void exitJavascriptArgumentList(OParser.JavascriptArgumentListContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.item);
        JavaScriptExpressionList list = new JavaScriptExpressionList(exp);
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitJavascriptArgumentListItem(OParser.JavascriptArgumentListItemContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.item);
        JavaScriptExpressionList list = (JavaScriptExpressionList)this.getNodeValue((ParseTree)ctx.items);
        list.add(exp);
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitJavascriptBooleanLiteral(OParser.JavascriptBooleanLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptBooleanLiteral(text));
    }

    @Override
    public void exitJavaScriptCategoryBinding(OParser.JavaScriptCategoryBindingContext ctx) {
        JavaScriptNativeCategoryBinding binding = (JavaScriptNativeCategoryBinding)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, binding);
    }

    @Override
    public void exitJavascriptCharacterLiteral(OParser.JavascriptCharacterLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptCharacterLiteral(text));
    }

    @Override
    public void exitJavascriptDecimalLiteral(OParser.JavascriptDecimalLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptDecimalLiteral(text));
    }

    @Override
    public void exitJavascriptIntegerLiteral(OParser.JavascriptIntegerLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptIntegerLiteral(text));
    }

    @Override
    public void exitJavaScriptItemExpression(OParser.JavaScriptItemExpressionContext ctx) {
        JavaScriptExpression item = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaScriptItemExpression(item));
    }

    @Override
    public void exitJavaScriptMemberExpression(OParser.JavaScriptMemberExpressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new JavaScriptMemberExpression(name));
    }

    @Override
    public void exitJavaScriptMethodExpression(OParser.JavaScriptMethodExpressionContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.method);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavaScriptNativeStatement(OParser.JavaScriptNativeStatementContext ctx) {
        JavaScriptStatement stmt = (JavaScriptStatement)this.getNodeValue((ParseTree)ctx.javascript_native_statement());
        this.setNodeValue(ctx, new JavaScriptNativeCall(stmt));
    }

    @Override
    public void exitJavascriptPrimaryExpression(OParser.JavascriptPrimaryExpressionContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJavascriptReturnStatement(OParser.JavascriptReturnStatementContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaScriptStatement(exp, true));
    }

    @Override
    public void exitJavascriptSelectorExpression(OParser.JavascriptSelectorExpressionContext ctx) {
        JavaScriptExpression parent = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.parent);
        JavaScriptSelectorExpression child = (JavaScriptSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        child.setParent(parent);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitJavascriptStatement(OParser.JavascriptStatementContext ctx) {
        JavaScriptExpression exp = (JavaScriptExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaScriptStatement(exp, false));
    }

    @Override
    public void exitJavascriptTextLiteral(OParser.JavascriptTextLiteralContext ctx) {
        String text = ctx.t.getText();
        this.setNodeValue((ParseTree)ctx, new JavaScriptTextLiteral(text));
    }

    @Override
    public void exitJavaSelectorExpression(OParser.JavaSelectorExpressionContext ctx) {
        JavaExpression parent = (JavaExpression)this.getNodeValue((ParseTree)ctx.parent);
        JavaSelectorExpression child = (JavaSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        child.setParent(parent);
        this.setNodeValue(ctx, child);
    }

    @Override
    public void exitJavaStatement(OParser.JavaStatementContext ctx) {
        JavaExpression exp = (JavaExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JavaStatement(exp, false));
    }

    @Override
    public void exitJavaTextLiteral(OParser.JavaTextLiteralContext ctx) {
        this.setNodeValue(ctx, new JavaTextLiteral(ctx.getText()));
    }

    @Override
    public void exitJsxChild(OParser.JsxChildContext ctx) {
        Object jsx = this.getNodeValue((ParseTree)ctx.jsx);
        this.setNodeValue((ParseTree)ctx, jsx);
    }

    @Override
    public void exitJsxCode(OParser.JsxCodeContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JsxCode(exp));
    }

    @Override
    public void exitJsxExpression(OParser.JsxExpressionContext ctx) {
        Object exp = this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitJsxElement(OParser.JsxElementContext ctx) {
        JsxElement element = (JsxElement)this.getNodeValue((ParseTree)ctx.opening);
        JsxClosing closing = (JsxClosing)this.getNodeValue((ParseTree)ctx.closing);
        element.setClosing(closing);
        List children = (List)this.getNodeValue((ParseTree)ctx.children_);
        element.setChildren(children);
        this.setNodeValue(ctx, element);
    }

    @Override
    public void exitJsxSelfClosing(OParser.JsxSelfClosingContext ctx) {
        JsxSelfClosing jsx = (JsxSelfClosing)this.getNodeValue((ParseTree)ctx.jsx);
        this.setNodeValue(ctx, jsx);
    }

    @Override
    public void exitJsxText(OParser.JsxTextContext ctx) {
        String text = ParserUtils.getFullText(ctx.text);
        this.setNodeValue((ParseTree)ctx, new JsxText(text));
    }

    @Override
    public void exitJsxValue(OParser.JsxValueContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new JsxExpression(exp));
    }

    @Override
    public void exitJsx_attribute(OParser.Jsx_attributeContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IJsxValue value = (IJsxValue)this.getNodeValue((ParseTree)ctx.value);
        Token stop = value != null ? ctx.value.getStop() : ctx.name.getStop();
        String suite = value == null ? null : this.getHiddenTokensAfter(stop);
        this.setNodeValue(ctx, new JsxProperty(name, value, suite));
    }

    @Override
    public void exitJsx_children(OParser.Jsx_childrenContext ctx) {
        List list = ctx.jsx_child().stream().map(cx -> (IJsxExpression)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitJsx_element_name(OParser.Jsx_element_nameContext ctx) {
        String name = ctx.getText();
        this.setNodeValue(ctx, new Identifier(name));
    }

    @Override
    public void exitJsx_expression(OParser.Jsx_expressionContext ctx) {
        Object jsx = this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, jsx);
    }

    @Override
    public void exitJsx_identifier(OParser.Jsx_identifierContext ctx) {
        String name = ctx.getText();
        this.setNodeValue(ctx, new Identifier(name));
    }

    @Override
    public void exitJsx_fragment(OParser.Jsx_fragmentContext ctx) {
        String openingSuite = this.getHiddenTokensAfter(ctx.jsx_fragment_start().getStop());
        JsxFragment fragment = new JsxFragment(openingSuite);
        List children = (List)this.getNodeValue((ParseTree)ctx.children_);
        fragment.setChildren(children);
        this.setNodeValue(ctx, fragment);
    }

    @Override
    public void exitJsxLiteral(OParser.JsxLiteralContext ctx) {
        String text = ctx.getText();
        this.setNodeValue((ParseTree)ctx, new JsxLiteral(text));
    }

    @Override
    public void exitJsx_opening(OParser.Jsx_openingContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        String nameSuite = this.getHiddenTokensAfter(ctx.name.getStop());
        List<JsxProperty> attributes = ctx.jsx_attribute().stream().map(cx -> (JsxProperty)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        String openingSuite = this.getHiddenTokensAfter(ctx.GT());
        this.setNodeValue(ctx, new JsxElement(name, nameSuite, attributes, openingSuite));
    }

    @Override
    public void exitJsx_closing(OParser.Jsx_closingContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        String suite = this.getHiddenTokensAfter(ctx.GT());
        this.setNodeValue((ParseTree)ctx, new JsxClosing(name, suite));
    }

    @Override
    public void exitJsx_self_closing(OParser.Jsx_self_closingContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        String nameSuite = this.getHiddenTokensAfter(ctx.name.getStop());
        List<JsxProperty> attributes = ctx.jsx_attribute().stream().map(cx -> (JsxProperty)this.getNodeValue((ParseTree)cx)).collect(Collectors.toList());
        String openingSuite = this.getHiddenTokensAfter(ctx.GT());
        this.setNodeValue(ctx, new JsxSelfClosing(name, nameSuite, attributes, openingSuite));
    }

    @Override
    public void exitKey_token(OParser.Key_tokenContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitLessThanExpression(OParser.LessThanExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.LT, right));
    }

    @Override
    public void exitLessThanOrEqualExpression(OParser.LessThanOrEqualExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new CompareExpression(left, CmpOp.LTE, right));
    }

    @Override
    public void exitList_literal(OParser.List_literalContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.expression_list());
        ListLiteral value = items == null ? new ListLiteral(mutable) : new ListLiteral(items, mutable);
        this.setNodeValue((ParseTree)ctx, value);
    }

    @Override
    public void exitListType(OParser.ListTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.l);
        this.setNodeValue(ctx, new ListType(type));
    }

    @Override
    public void exitLiteral_expression(OParser.Literal_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitLiteral_list_literal(OParser.Literal_list_literalContext ctx) {
        ExpressionList items = new ExpressionList();
        ctx.atomic_literal().forEach(l -> {
            IExpression item = (IExpression)this.getNodeValue((ParseTree)l);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitLiteralExpression(OParser.LiteralExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitLiteralListLiteral(OParser.LiteralListLiteralContext ctx) {
        ExpressionList exp = (ExpressionList)this.getNodeValue((ParseTree)ctx.literal_list_literal());
        this.setNodeValue((ParseTree)ctx, new ListLiteral(exp, false));
    }

    @Override
    public void exitLiteralRangeLiteral(OParser.LiteralRangeLiteralContext ctx) {
        IExpression low = (IExpression)this.getNodeValue((ParseTree)ctx.low);
        IExpression high = (IExpression)this.getNodeValue((ParseTree)ctx.high);
        this.setNodeValue((ParseTree)ctx, new RangeLiteral(low, high));
    }

    @Override
    public void exitLiteralSetLiteral(OParser.LiteralSetLiteralContext ctx) {
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.literal_list_literal());
        this.setNodeValue((ParseTree)ctx, new SetLiteral(items));
    }

    @Override
    public void exitMatchingExpression(OParser.MatchingExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new MatchingExpressionConstraint(exp));
    }

    @Override
    public void exitMatchingList(OParser.MatchingListContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue(ctx, new MatchingCollectionConstraint(exp));
    }

    @Override
    public void exitMatchingPattern(OParser.MatchingPatternContext ctx) {
        this.setNodeValue(ctx, new MatchingPatternConstraint(new TextLiteral(ctx.text.getText())));
    }

    @Override
    public void exitMatchingRange(OParser.MatchingRangeContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue(ctx, new MatchingCollectionConstraint(exp));
    }

    @Override
    public void exitMatchingSet(OParser.MatchingSetContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue(ctx, new MatchingCollectionConstraint(exp));
    }

    @Override
    public void exitMaxIntegerLiteral(OParser.MaxIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new MaxIntegerLiteral());
    }

    @Override
    public void exitMember_method_declaration(OParser.Member_method_declarationContext ctx) {
        List<CommentStatement> comments = this.readComments(ctx.comment_statement());
        List<Annotation> annotations = this.readAnnotations(ctx.annotation_constructor());
        ParseTree ctx_ = ctx.getChild(ctx.getChildCount() - 1);
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx_);
        if (decl != null) {
            decl.setComments(comments);
            decl.setAnnotations(annotations);
            this.setNodeValue((ParseTree)ctx, decl);
        }
    }

    @Override
    public void exitMember_method_declaration_list(OParser.Member_method_declaration_listContext ctx) {
        MethodDeclarationList items = new MethodDeclarationList();
        ctx.member_method_declaration().forEach(m -> {
            IMethodDeclaration item = (IMethodDeclaration)this.getNodeValue((ParseTree)m);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitMember_identifier(OParser.Member_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitMemberInstance(OParser.MemberInstanceContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new MemberInstance(name));
    }

    @Override
    public void exitMemberSelector(OParser.MemberSelectorContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue(ctx, new MemberSelector(name));
    }

    @Override
    public void exitMethod_call_expression(OParser.Method_call_expressionContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        UnresolvedIdentifier caller = new UnresolvedIdentifier(name);
        ArgumentList args = (ArgumentList)this.getNodeValue((ParseTree)ctx.args);
        this.setNodeValue(ctx, new UnresolvedCall(caller, args));
    }

    @Override
    public void exitMethod_call_statement(OParser.Method_call_statementContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        UnresolvedCall call = (UnresolvedCall)this.getNodeValue((ParseTree)ctx.method);
        call.setParent(parent);
        Identifier resultName = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        if (resultName != null || stmts != null) {
            this.setNodeValue(ctx, new RemoteCall(call, resultName, stmts));
        } else {
            this.setNodeValue(ctx, call);
        }
    }

    @Override
    public void exitMethod_declaration(OParser.Method_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitMethod_expression(OParser.Method_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitMethod_identifier(OParser.Method_identifierContext ctx) {
        Object id = this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, id);
    }

    @Override
    public void exitMethodCallStatement(OParser.MethodCallStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitMethodExpression(OParser.MethodExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitMethodSelector(OParser.MethodSelectorContext ctx) {
        UnresolvedCall call = (UnresolvedCall)this.getNodeValue((ParseTree)ctx.method);
        if (call.getCaller() instanceof UnresolvedIdentifier) {
            Identifier id = ((UnresolvedIdentifier)call.getCaller()).getId();
            call.setCaller(new UnresolvedSelector(id));
        }
        this.setNodeValue(ctx, call);
    }

    @Override
    public void exitMinIntegerLiteral(OParser.MinIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new MinIntegerLiteral());
    }

    @Override
    public void exitMinusExpression(OParser.MinusExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new MinusExpression(exp));
    }

    @Override
    public void exitModuloExpression(OParser.ModuloExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new ModuloExpression(left, right));
    }

    @Override
    public void exitMultiplyExpression(OParser.MultiplyExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new MultiplyExpression(left, right));
    }

    @Override
    public void exitMutable_category_type(OParser.Mutable_category_typeContext ctx) {
        CategoryType type = (CategoryType)this.getNodeValue((ParseTree)ctx.category_type());
        type.setMutable(ctx.MUTABLE() != null);
        this.setNodeValue(ctx, type);
    }

    @Override
    public void exitMutableInstanceExpression(OParser.MutableInstanceExpressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new MutableExpression(source));
    }

    @Override
    public void exitMutableSelectableExpression(OParser.MutableSelectableExpressionContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.exp));
    }

    @Override
    public void exitMutableSelectorExpression(OParser.MutableSelectorExpressionContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        SelectorExpression selector = (SelectorExpression)this.getNodeValue((ParseTree)ctx.selector);
        selector.setParent(parent);
        this.setNodeValue(ctx, selector);
    }

    @Override
    public void exitNamed_argument(OParser.Named_argumentContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        UnresolvedParameter arg = new UnresolvedParameter(name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.literal_expression());
        arg.setDefaultExpression(exp);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitNative_category_bindings(OParser.Native_category_bindingsContext ctx) {
        NativeCategoryBindingList items = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.items);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNative_category_declaration(OParser.Native_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        NativeCategoryBindingList bindings = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.bindings);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        NativeCategoryDeclaration decl = new NativeCategoryDeclaration(name, attrs, bindings, null, methods);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitNative_widget_declaration(OParser.Native_widget_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        NativeCategoryBindingList bindings = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.bindings);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        this.setNodeValue(ctx, new NativeWidgetDeclaration(name, bindings, methods));
    }

    @Override
    public void exitNative_getter_declaration(OParser.Native_getter_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new NativeGetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitNative_member_method_declaration(OParser.Native_member_method_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitNative_method_declaration(OParser.Native_method_declarationContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        ParameterList args = (ParameterList)this.getNodeValue((ParseTree)ctx.args);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new NativeMethodDeclaration(name, args, type, stmts));
    }

    @Override
    public void exitNative_resource_declaration(OParser.Native_resource_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        NativeCategoryBindingList bindings = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.bindings);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        NativeResourceDeclaration decl = new NativeResourceDeclaration(name, attrs, bindings, null, methods);
        decl.setStorable(ctx.STORABLE() != null);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitNative_setter_declaration(OParser.Native_setter_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new NativeSetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitNative_symbol(OParser.Native_symbolContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new NativeSymbol(name, exp));
    }

    @Override
    public void exitNativeCategoryBindingList(OParser.NativeCategoryBindingListContext ctx) {
        NativeCategoryBinding item = (NativeCategoryBinding)this.getNodeValue((ParseTree)ctx.item);
        NativeCategoryBindingList items = new NativeCategoryBindingList(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNativeCategoryBindingListItem(OParser.NativeCategoryBindingListItemContext ctx) {
        NativeCategoryBinding item = (NativeCategoryBinding)this.getNodeValue((ParseTree)ctx.item);
        NativeCategoryBindingList items = (NativeCategoryBindingList)this.getNodeValue((ParseTree)ctx.items);
        items.add(item);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNativeCategoryDeclaration(OParser.NativeCategoryDeclarationContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.decl));
    }

    @Override
    public void exitNativeWidgetDeclaration(OParser.NativeWidgetDeclarationContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.decl));
    }

    @Override
    public void exitNative_member_method_declaration_list(OParser.Native_member_method_declaration_listContext ctx) {
        MethodDeclarationList items = new MethodDeclarationList();
        ctx.native_member_method_declaration().forEach(m -> {
            IMethodDeclaration item = (IMethodDeclaration)this.getNodeValue((ParseTree)m);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNative_statement_list(OParser.Native_statement_listContext ctx) {
        StatementList items = new StatementList();
        ctx.native_statement().forEach(s -> {
            IStatement item = (IStatement)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNative_symbol_list(OParser.Native_symbol_listContext ctx) {
        NativeSymbolList items = new NativeSymbolList();
        ctx.native_symbol().forEach(s -> {
            NativeSymbol item = (NativeSymbol)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitNativeType(OParser.NativeTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.n);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitNotHasExpression(OParser.NotHasExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_HAS, right));
    }

    @Override
    public void exitNotHasAllExpression(OParser.NotHasAllExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_HAS_ALL, right));
    }

    @Override
    public void exitNotHasAnyExpression(OParser.NotHasAnyExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_HAS_ANY, right));
    }

    @Override
    public void exitNotContainsExpression(OParser.NotContainsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.NOT_CONTAINS, right));
    }

    @Override
    public void exitNotEqualsExpression(OParser.NotEqualsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.NOT_EQUALS, right));
    }

    @Override
    public void exitNotExpression(OParser.NotExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new NotExpression(exp));
    }

    @Override
    public void exitNotInExpression(OParser.NotInExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue(ctx, new ContainsExpression(left, ContOp.NOT_IN, right));
    }

    @Override
    public void exitNullLiteral(OParser.NullLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, NullLiteral.instance());
    }

    @Override
    public void exitOperator_argument(OParser.Operator_argumentContext ctx) {
        IParameter arg = (IParameter)this.getNodeValue(ctx.getChild(0));
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitOperator_method_declaration(OParser.Operator_method_declarationContext ctx) {
        Operator op = (Operator)((Object)this.getNodeValue((ParseTree)ctx.op));
        IParameter arg = (IParameter)this.getNodeValue((ParseTree)ctx.arg);
        IType typ = (IType)this.getNodeValue((ParseTree)ctx.typ);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        OperatorMethodDeclaration decl = new OperatorMethodDeclaration(op, arg, typ, stmts);
        this.setNodeValue(ctx, decl);
    }

    @Override
    public void exitOperatorArgument(OParser.OperatorArgumentContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        IParameter arg = (IParameter)this.getNodeValue((ParseTree)ctx.arg);
        arg.setMutable(mutable);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitOperatorDivide(OParser.OperatorDivideContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.DIVIDE);
    }

    @Override
    public void exitOperatorIDivide(OParser.OperatorIDivideContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.IDIVIDE);
    }

    @Override
    public void exitOperatorMinus(OParser.OperatorMinusContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.MINUS);
    }

    @Override
    public void exitOperatorModulo(OParser.OperatorModuloContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.MODULO);
    }

    @Override
    public void exitOperatorMultiply(OParser.OperatorMultiplyContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.MULTIPLY);
    }

    @Override
    public void exitOperatorPlus(OParser.OperatorPlusContext ctx) {
        this.setNodeValue((ParseTree)ctx, (Object)Operator.PLUS);
    }

    @Override
    public void exitOrder_by(OParser.Order_byContext ctx) {
        IdentifierList names = new IdentifierList();
        for (OParser.Variable_identifierContext ctx_ : ctx.variable_identifier()) {
            names.add(this.getNodeValue((ParseTree)ctx_));
        }
        OrderByClause clause = new OrderByClause(names, ctx.DESC() != null);
        this.setNodeValue(ctx, clause);
    }

    @Override
    public void exitOrder_by_list(OParser.Order_by_listContext ctx) {
        OrderByClauseList list = new OrderByClauseList();
        for (OParser.Order_byContext ctx_ : ctx.order_by()) {
            list.add(this.getNodeValue((ParseTree)ctx_));
        }
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitOrExpression(OParser.OrExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new OrExpression(left, right));
    }

    @Override
    public void exitParenthesis_expression(OParser.Parenthesis_expressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.expression());
        this.setNodeValue(ctx, new ParenthesisExpression(exp));
    }

    @Override
    public void exitParenthesisExpression(OParser.ParenthesisExpressionContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPeriodLiteral(OParser.PeriodLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PeriodLiteral(ctx.getText()));
    }

    @Override
    public void exitPeriodType(OParser.PeriodTypeContext ctx) {
        this.setNodeValue(ctx, PeriodType.instance());
    }

    @Override
    public void exitPrimaryType(OParser.PrimaryTypeContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.p);
        this.setNodeValue((ParseTree)ctx, type);
    }

    @Override
    public void exitPython_category_binding(OParser.Python_category_bindingContext ctx) {
        String identifier = ctx.identifier().getText();
        PythonModule module = (PythonModule)this.getNodeValue((ParseTree)ctx.python_module());
        PythonNativeCategoryBinding map = new PythonNativeCategoryBinding(identifier, module);
        this.setNodeValue((ParseTree)ctx, map);
    }

    @Override
    public void exitPython_identifier(OParser.Python_identifierContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitPython_method_expression(OParser.Python_method_expressionContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonArgumentList args = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.args);
        PythonMethodExpression method = new PythonMethodExpression(name);
        method.setArguments(args);
        this.setNodeValue((ParseTree)ctx, method);
    }

    @Override
    public void exitPython_module(OParser.Python_moduleContext ctx) {
        ArrayList<String> ids = new ArrayList<String>();
        for (OParser.Python_identifierContext ic : ctx.python_identifier()) {
            ids.add(ic.getText());
        }
        PythonModule module = new PythonModule(ids);
        this.setNodeValue((ParseTree)ctx, module);
    }

    @Override
    public void exitPython_native_statement(OParser.Python_native_statementContext ctx) {
        PythonStatement stmt = (PythonStatement)this.getNodeValue((ParseTree)ctx.python_statement());
        PythonModule module = (PythonModule)this.getNodeValue((ParseTree)ctx.python_module());
        stmt.setModule(module);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitPython2CategoryBinding(OParser.Python2CategoryBindingContext ctx) {
        PythonNativeCategoryBinding map = (PythonNativeCategoryBinding)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new Python2NativeCategoryBinding(map));
    }

    @Override
    public void exitPython2NativeStatement(OParser.Python2NativeStatementContext ctx) {
        PythonStatement stmt = (PythonStatement)this.getNodeValue((ParseTree)ctx.python_native_statement());
        this.setNodeValue(ctx, new Python2NativeCall(stmt));
    }

    @Override
    public void exitPython3CategoryBinding(OParser.Python3CategoryBindingContext ctx) {
        PythonNativeCategoryBinding map = (PythonNativeCategoryBinding)this.getNodeValue((ParseTree)ctx.binding);
        this.setNodeValue((ParseTree)ctx, new Python3NativeCategoryBinding(map));
    }

    @Override
    public void exitPython3NativeStatement(OParser.Python3NativeStatementContext ctx) {
        PythonStatement stmt = (PythonStatement)this.getNodeValue((ParseTree)ctx.python_native_statement());
        this.setNodeValue(ctx, new Python3NativeCall(stmt));
    }

    @Override
    public void exitPythonArgumentList(OParser.PythonArgumentListContext ctx) {
        PythonArgumentList ordinal = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.ordinal);
        PythonArgumentList named = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.named);
        if (ordinal == null) {
            ordinal = new PythonArgumentList();
        }
        if (named != null) {
            ordinal.addAll(named);
        }
        this.setNodeValue((ParseTree)ctx, ordinal);
    }

    @Override
    public void exitPythonBooleanLiteral(OParser.PythonBooleanLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonBooleanLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonCharacterLiteral(OParser.PythonCharacterLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonCharacterLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonChildIdentifier(OParser.PythonChildIdentifierContext ctx) {
        PythonIdentifierExpression parent = (PythonIdentifierExpression)this.getNodeValue((ParseTree)ctx.parent);
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonIdentifierExpression child = new PythonIdentifierExpression(parent, name);
        this.setNodeValue((ParseTree)ctx, child);
    }

    @Override
    public void exitPythonDecimalLiteral(OParser.PythonDecimalLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonDecimalLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonGlobalMethodExpression(OParser.PythonGlobalMethodExpressionContext ctx) {
        PythonMethodExpression exp = (PythonMethodExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonIdentifier(OParser.PythonIdentifierContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        this.setNodeValue((ParseTree)ctx, new PythonIdentifierExpression(name));
    }

    @Override
    public void exitPythonIdentifierExpression(OParser.PythonIdentifierExpressionContext ctx) {
        PythonIdentifierExpression exp = (PythonIdentifierExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonIntegerLiteral(OParser.PythonIntegerLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonIntegerLiteral(ctx.getText()));
    }

    @Override
    public void exitPythonLiteralExpression(OParser.PythonLiteralExpressionContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonMethodExpression(OParser.PythonMethodExpressionContext ctx) {
        PythonMethodExpression exp = (PythonMethodExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonNamedArgumentList(OParser.PythonNamedArgumentListContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        PythonNamedArgument arg = new PythonNamedArgument(name, exp);
        this.setNodeValue((ParseTree)ctx, new PythonArgumentList(arg));
    }

    @Override
    public void exitPythonNamedArgumentListItem(OParser.PythonNamedArgumentListItemContext ctx) {
        String name = (String)this.getNodeValue((ParseTree)ctx.name);
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        PythonNamedArgument arg = new PythonNamedArgument(name, exp);
        PythonArgumentList items = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.items);
        items.add(arg);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitPythonNamedOnlyArgumentList(OParser.PythonNamedOnlyArgumentListContext ctx) {
        PythonArgumentList named = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.named);
        this.setNodeValue((ParseTree)ctx, named);
    }

    @Override
    public void exitPythonOrdinalArgumentList(OParser.PythonOrdinalArgumentListContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.item);
        PythonOrdinalArgument arg = new PythonOrdinalArgument(exp);
        this.setNodeValue((ParseTree)ctx, new PythonArgumentList(arg));
    }

    @Override
    public void exitPythonOrdinalArgumentListItem(OParser.PythonOrdinalArgumentListItemContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.item);
        PythonOrdinalArgument arg = new PythonOrdinalArgument(exp);
        PythonArgumentList items = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.items);
        items.add(arg);
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitPythonOrdinalOnlyArgumentList(OParser.PythonOrdinalOnlyArgumentListContext ctx) {
        PythonArgumentList ordinal = (PythonArgumentList)this.getNodeValue((ParseTree)ctx.ordinal);
        this.setNodeValue((ParseTree)ctx, ordinal);
    }

    @Override
    public void exitPythonPromptoIdentifier(OParser.PythonPromptoIdentifierContext ctx) {
        String name = ctx.DOLLAR_IDENTIFIER().getText();
        this.setNodeValue((ParseTree)ctx, new PythonIdentifierExpression(name));
    }

    @Override
    public void exitPythonPrimaryExpression(OParser.PythonPrimaryExpressionContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitPythonReturnStatement(OParser.PythonReturnStatementContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new PythonStatement(exp, true));
    }

    @Override
    public void exitPythonSelectorExpression(OParser.PythonSelectorExpressionContext ctx) {
        PythonExpression parent = (PythonExpression)this.getNodeValue((ParseTree)ctx.parent);
        PythonSelectorExpression selector = (PythonSelectorExpression)this.getNodeValue((ParseTree)ctx.child);
        selector.setParent(parent);
        this.setNodeValue((ParseTree)ctx, selector);
    }

    @Override
    public void exitPythonSelfExpression(OParser.PythonSelfExpressionContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonSelfExpression());
    }

    @Override
    public void exitPythonStatement(OParser.PythonStatementContext ctx) {
        PythonExpression exp = (PythonExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue((ParseTree)ctx, new PythonStatement(exp, false));
    }

    @Override
    public void exitPythonTextLiteral(OParser.PythonTextLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new PythonTextLiteral(ctx.getText()));
    }

    @Override
    public void exitRaise_statement(OParser.Raise_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new RaiseStatement(exp));
    }

    @Override
    public void exitRaiseStatement(OParser.RaiseStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitRange_literal(OParser.Range_literalContext ctx) {
        IExpression low = (IExpression)this.getNodeValue((ParseTree)ctx.low);
        IExpression high = (IExpression)this.getNodeValue((ParseTree)ctx.high);
        this.setNodeValue((ParseTree)ctx, new RangeLiteral(low, high));
    }

    @Override
    public void exitRead_all_expression(OParser.Read_all_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new ReadAllExpression(source));
    }

    @Override
    public void exitRead_blob_expression(OParser.Read_blob_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new ReadBlobExpression(source));
    }

    @Override
    public void exitRead_one_expression(OParser.Read_one_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        this.setNodeValue((ParseTree)ctx, new ReadOneExpression(source));
    }

    @Override
    public void exitResource_declaration(OParser.Resource_declarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue((ParseTree)ctx.native_resource_declaration());
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitReturn_statement(OParser.Return_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        this.setNodeValue(ctx, new ReturnStatement(exp));
    }

    @Override
    public void exitReturnStatement(OParser.ReturnStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitRootInstance(OParser.RootInstanceContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        this.setNodeValue((ParseTree)ctx, new VariableInstance(name));
    }

    @Override
    public void exitRoughlyEqualsExpression(OParser.RoughlyEqualsExpressionContext ctx) {
        IExpression left = (IExpression)this.getNodeValue((ParseTree)ctx.left);
        IExpression right = (IExpression)this.getNodeValue((ParseTree)ctx.right);
        this.setNodeValue((ParseTree)ctx, new EqualsExpression(left, EqOp.ROUGHLY, right));
    }

    @Override
    public void exitSelectableExpression(OParser.SelectableExpressionContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.selectable_expression());
        this.setNodeValue((ParseTree)ctx, parent);
    }

    @Override
    public void exitSelectorExpression(OParser.SelectorExpressionContext ctx) {
        IExpression parent = (IExpression)this.getNodeValue((ParseTree)ctx.parent);
        IExpression selector = (IExpression)this.getNodeValue((ParseTree)ctx.selector);
        if (selector instanceof SelectorExpression) {
            ((SelectorExpression)selector).setParent(parent);
        } else if (selector instanceof UnresolvedCall) {
            ((UnresolvedCall)selector).setParent(parent);
        }
        this.setNodeValue((ParseTree)ctx, selector);
    }

    @Override
    public void exitSet_literal(OParser.Set_literalContext ctx) {
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.expression_list());
        SetLiteral set = items == null ? new SetLiteral() : new SetLiteral(items);
        this.setNodeValue((ParseTree)ctx, set);
    }

    @Override
    public void exitSetter_method_declaration(OParser.Setter_method_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new SetterMethodDeclaration(name, stmts));
    }

    @Override
    public void exitSetType(OParser.SetTypeContext ctx) {
        IType itemType = (IType)this.getNodeValue((ParseTree)ctx.s);
        this.setNodeValue(ctx, new SetType(itemType));
    }

    @Override
    public void exitSingleStatement(OParser.SingleStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, new StatementList(stmt));
    }

    @Override
    public void exitSingleton_category_declaration(OParser.Singleton_category_declarationContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        MethodDeclarationList methods = (MethodDeclarationList)this.getNodeValue((ParseTree)ctx.methods);
        this.setNodeValue(ctx, new SingletonCategoryDeclaration(name, attrs, methods));
    }

    @Override
    public void exitSingletonCategoryDeclaration(OParser.SingletonCategoryDeclarationContext ctx) {
        IDeclaration decl = (IDeclaration)this.getNodeValue((ParseTree)ctx.decl);
        this.setNodeValue((ParseTree)ctx, decl);
    }

    @Override
    public void exitSliceFirstAndLast(OParser.SliceFirstAndLastContext ctx) {
        IExpression first = (IExpression)this.getNodeValue((ParseTree)ctx.first);
        IExpression last = (IExpression)this.getNodeValue((ParseTree)ctx.last);
        this.setNodeValue(ctx, new SliceSelector(first, last));
    }

    @Override
    public void exitSliceFirstOnly(OParser.SliceFirstOnlyContext ctx) {
        IExpression first = (IExpression)this.getNodeValue((ParseTree)ctx.first);
        this.setNodeValue(ctx, new SliceSelector(first, null));
    }

    @Override
    public void exitSliceLastOnly(OParser.SliceLastOnlyContext ctx) {
        IExpression last = (IExpression)this.getNodeValue((ParseTree)ctx.last);
        this.setNodeValue(ctx, new SliceSelector(null, last));
    }

    @Override
    public void exitSliceSelector(OParser.SliceSelectorContext ctx) {
        IExpression slice = (IExpression)this.getNodeValue((ParseTree)ctx.xslice);
        this.setNodeValue((ParseTree)ctx, slice);
    }

    @Override
    public void exitSorted_expression(OParser.Sorted_expressionContext ctx) {
        IExpression source = (IExpression)this.getNodeValue((ParseTree)ctx.source);
        boolean descending = ctx.DESC() != null;
        IExpression key = (IExpression)this.getNodeValue((ParseTree)ctx.key);
        this.setNodeValue((ParseTree)ctx, new SortedExpression(source, descending, key));
    }

    @Override
    public void exitSorted_key(OParser.Sorted_keyContext ctx) {
        this.setNodeValue((ParseTree)ctx, this.getNodeValue(ctx.getChild(0)));
    }

    @Override
    public void exitStatement_list(OParser.Statement_listContext ctx) {
        StatementList items = new StatementList();
        ctx.statement().forEach(s -> {
            IStatement item = (IStatement)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitStore_statement(OParser.Store_statementContext ctx) {
        ExpressionList deletables = (ExpressionList)this.getNodeValue((ParseTree)ctx.to_del);
        ExpressionList storables = (ExpressionList)this.getNodeValue((ParseTree)ctx.to_add);
        StatementList andThen = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        StoreStatement stmt = new StoreStatement(deletables, storables, andThen);
        this.setNodeValue(ctx, stmt);
    }

    @Override
    public void exitStoreStatement(OParser.StoreStatementContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitSuperExpression(OParser.SuperExpressionContext ctx) {
        this.setNodeValue(ctx, new SuperExpression());
    }

    @Override
    public void exitSwitch_statement(OParser.Switch_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        BaseSwitchStatement.SwitchCaseList cases = (BaseSwitchStatement.SwitchCaseList)this.getNodeValue((ParseTree)ctx.cases);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        SwitchStatement stmt = new SwitchStatement(exp, cases, stmts);
        this.setNodeValue(ctx, stmt);
    }

    @Override
    public void exitSwitch_case_statement_list(OParser.Switch_case_statement_listContext ctx) {
        BaseSwitchStatement.SwitchCaseList items = new BaseSwitchStatement.SwitchCaseList();
        ctx.switch_case_statement().forEach(s -> {
            SwitchCase item = (SwitchCase)this.getNodeValue((ParseTree)s);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitSwitchStatement(OParser.SwitchStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitSymbol_identifier(OParser.Symbol_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitSymbolIdentifier(OParser.SymbolIdentifierContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.symbol_identifier());
        this.setNodeValue(ctx, new SymbolExpression(name));
    }

    @Override
    public void exitSymbolLiteral(OParser.SymbolLiteralContext ctx) {
        this.setNodeValue(ctx, new SymbolExpression(new Identifier(ctx.getText())));
    }

    @Override
    public void exitSymbol_list(OParser.Symbol_listContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exitTernaryExpression(OParser.TernaryExpressionContext ctx) {
        IExpression condition = (IExpression)this.getNodeValue((ParseTree)ctx.test);
        IExpression ifTrue = (IExpression)this.getNodeValue((ParseTree)ctx.ifTrue);
        IExpression ifFalse = (IExpression)this.getNodeValue((ParseTree)ctx.ifFalse);
        TernaryExpression exp = new TernaryExpression(condition, ifTrue, ifFalse);
        this.setNodeValue((ParseTree)ctx, exp);
    }

    @Override
    public void exitTest_method_declaration(OParser.Test_method_declarationContext ctx) {
        Identifier name = new Identifier(ctx.name.getText());
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        AssertionList exps = (AssertionList)this.getNodeValue((ParseTree)ctx.exps);
        Identifier errorName = (Identifier)this.getNodeValue((ParseTree)ctx.error);
        SymbolExpression error = errorName == null ? null : new SymbolExpression(errorName);
        this.setNodeValue(ctx, new TestMethodDeclaration(name, stmts, exps, error));
    }

    @Override
    public void exitTextLiteral(OParser.TextLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new TextLiteral(ctx.getText()));
    }

    @Override
    public void exitTextType(OParser.TextTypeContext ctx) {
        this.setNodeValue(ctx, TextType.instance());
    }

    @Override
    public void exitThisExpression(OParser.ThisExpressionContext ctx) {
        this.setNodeValue(ctx, new ThisExpression());
    }

    @Override
    public void exitTimeLiteral(OParser.TimeLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new TimeLiteral(ctx.getText()));
    }

    @Override
    public void exitTimeType(OParser.TimeTypeContext ctx) {
        this.setNodeValue(ctx, TimeType.instance());
    }

    @Override
    public void exitTry_statement(OParser.Try_statementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        BaseSwitchStatement.SwitchCaseList handlers = (BaseSwitchStatement.SwitchCaseList)this.getNodeValue((ParseTree)ctx.handlers);
        StatementList anyStmts = (StatementList)this.getNodeValue((ParseTree)ctx.anyStmts);
        StatementList finalStmts = (StatementList)this.getNodeValue((ParseTree)ctx.finalStmts);
        SwitchErrorStatement stmt = new SwitchErrorStatement(name, stmts, handlers, anyStmts, finalStmts);
        this.setNodeValue(ctx, stmt);
    }

    @Override
    public void exitTryStatement(OParser.TryStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitTuple_literal(OParser.Tuple_literalContext ctx) {
        boolean mutable = ctx.MUTABLE() != null;
        ExpressionList items = (ExpressionList)this.getNodeValue((ParseTree)ctx.expression_tuple());
        TupleLiteral value = items == null ? new TupleLiteral(mutable) : new TupleLiteral(items, mutable);
        this.setNodeValue((ParseTree)ctx, value);
    }

    @Override
    public void exitType_identifier(OParser.Type_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitType_identifier_list(OParser.Type_identifier_listContext ctx) {
        IdentifierList items = new IdentifierList();
        ctx.type_identifier().forEach(i -> {
            Identifier item = (Identifier)this.getNodeValue((ParseTree)i);
            items.add(item);
        });
        this.setNodeValue((ParseTree)ctx, items);
    }

    @Override
    public void exitType_literal(OParser.Type_literalContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.category_or_any_type());
        this.setNodeValue(ctx, new TypeLiteral(type));
    }

    @Override
    public void exitTyped_argument(OParser.Typed_argumentContext ctx) {
        IType type = (IType)this.getNodeValue((ParseTree)ctx.typ);
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.name);
        IdentifierList attrs = (IdentifierList)this.getNodeValue((ParseTree)ctx.attrs);
        CategoryParameter arg = attrs == null ? new CategoryParameter(type, name) : new ExtendedParameter(type, name, attrs);
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.value);
        arg.setDefaultExpression(exp);
        this.setNodeValue((ParseTree)ctx, arg);
    }

    @Override
    public void exitTypeIdentifier(OParser.TypeIdentifierContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.type_identifier());
        this.setNodeValue(ctx, new UnresolvedIdentifier(name));
    }

    @Override
    public void exitTypeLiteral(OParser.TypeLiteralContext ctx) {
        this.setNodeValue(ctx, (Section)this.getNodeValue((ParseTree)ctx.type_literal()));
    }

    @Override
    public void exitUUIDLiteral(OParser.UUIDLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new UuidLiteral(ctx.getText()));
    }

    @Override
    public void exitUUIDType(OParser.UUIDTypeContext ctx) {
        this.setNodeValue(ctx, UuidType.instance());
    }

    @Override
    public void exitValue_token(OParser.Value_tokenContext ctx) {
        this.setNodeValue((ParseTree)ctx, ctx.getText());
    }

    @Override
    public void exitVariable_identifier(OParser.Variable_identifierContext ctx) {
        this.setNodeValue(ctx, new Identifier(ctx.getText()));
    }

    @Override
    public void exitVariableIdentifier(OParser.VariableIdentifierContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.variable_identifier());
        this.setNodeValue(ctx, new InstanceExpression(name));
    }

    @Override
    public void exitVariable_identifier_list(OParser.Variable_identifier_listContext ctx) {
        IdentifierList list = new IdentifierList();
        for (OParser.Variable_identifierContext v : ctx.variable_identifier()) {
            Identifier item = (Identifier)this.getNodeValue((ParseTree)v);
            list.add(item);
        }
        this.setNodeValue((ParseTree)ctx, list);
    }

    @Override
    public void exitVersionType(OParser.VersionTypeContext ctx) {
        this.setNodeValue(ctx, VersionType.instance());
    }

    @Override
    public void exitVersionLiteral(OParser.VersionLiteralContext ctx) {
        this.setNodeValue((ParseTree)ctx, new VersionLiteral(ctx.getText()));
    }

    @Override
    public void exitWhile_statement(OParser.While_statementContext ctx) {
        IExpression exp = (IExpression)this.getNodeValue((ParseTree)ctx.exp);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new WhileStatement(exp, stmts));
    }

    @Override
    public void exitWhileStatement(OParser.WhileStatementContext ctx) {
        this.setNodeValue((ParseTree)ctx, this.getNodeValue((ParseTree)ctx.stmt));
    }

    @Override
    public void exitWith_resource_statement(OParser.With_resource_statementContext ctx) {
        AssignVariableStatement stmt = (AssignVariableStatement)this.getNodeValue((ParseTree)ctx.stmt);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new WithResourceStatement(stmt, stmts));
    }

    @Override
    public void exitWith_singleton_statement(OParser.With_singleton_statementContext ctx) {
        Identifier name = (Identifier)this.getNodeValue((ParseTree)ctx.typ);
        CategoryType type = new CategoryType(name);
        StatementList stmts = (StatementList)this.getNodeValue((ParseTree)ctx.stmts);
        this.setNodeValue(ctx, new WithSingletonStatement(type, stmts));
    }

    @Override
    public void exitWithResourceStatement(OParser.WithResourceStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitWithSingletonStatement(OParser.WithSingletonStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    @Override
    public void exitWrite_statement(OParser.Write_statementContext ctx) {
        IExpression what = (IExpression)this.getNodeValue((ParseTree)ctx.what);
        IExpression target = (IExpression)this.getNodeValue((ParseTree)ctx.target);
        this.setNodeValue(ctx, new WriteStatement(what, target));
    }

    @Override
    public void exitWriteStatement(OParser.WriteStatementContext ctx) {
        IStatement stmt = (IStatement)this.getNodeValue((ParseTree)ctx.stmt);
        this.setNodeValue((ParseTree)ctx, stmt);
    }

    private Token findFirstValidToken(int idx) {
        if (idx == -1) {
            idx = 0;
        }
        do {
            Token token;
            if ((token = this.readValidToken(idx++)) == null) continue;
            return token;
        } while (idx < this.input.size());
        return null;
    }

    private Token findLastValidToken(int idx) {
        if (idx == -1) {
            idx = 0;
        }
        while (idx >= 0) {
            Token token;
            if ((token = this.readValidToken(idx--)) == null) continue;
            return token;
        }
        return null;
    }

    public <T> T getNodeValue(ParseTree node) {
        return (T)this.nodeValues.get(node);
    }

    private Token readValidToken(int idx) {
        Token token = this.input.get(idx);
        String text = token.getText();
        if (text != null && text.length() > 0 && !Character.isWhitespace(text.charAt(0))) {
            return token;
        }
        return null;
    }

    public void setNodeValue(ParserRuleContext node, Section value) {
        this.nodeValues.put((ParseTree)node, (Object)value);
        this.buildSection(node, value);
    }

    public void setNodeValue(ParseTree node, Object value) {
        this.nodeValues.put(node, value);
    }
}

