/*
 * Decompiled with CFR 0.152.
 */
package prompto.parser;

import java.util.Objects;
import org.antlr.v4.runtime.Token;
import prompto.parser.Dialect;
import prompto.parser.ISection;
import prompto.parser.Location;

public class Section
implements ISection {
    String path;
    Location start;
    Location end;
    Dialect dialect;
    boolean breakpoint;

    public Section() {
    }

    public Section(ISection section) {
        this.setFrom(section);
    }

    public Section(String path, Location start, Location end, Dialect dialect, boolean breakpoint) {
        this.path = path;
        this.start = start;
        this.end = end;
        this.dialect = dialect;
        this.breakpoint = breakpoint;
    }

    public void setFrom(ISection section) {
        this.path = section.getPath();
        this.start = section.getStart() == null ? null : new Location(section.getStart());
        this.end = section.getEnd() == null ? null : new Location(section.getEnd());
        this.dialect = section.getDialect();
        this.breakpoint = section.isBreakpoint();
    }

    public void setFrom(String path, Token start, Token end, Dialect dialect) {
        this.path = path;
        this.start = new Location(start);
        this.end = new Location(end, true);
        this.dialect = dialect;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Location getStart() {
        return this.start;
    }

    @Override
    public Location getEnd() {
        return this.end;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public void setAsBreakpoint(boolean set) {
        this.breakpoint = set;
    }

    @Override
    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    @Override
    public boolean isOrContains(ISection section) {
        return this.dialect == section.getDialect() && Objects.equals(this.path, section.getPath()) && this.start.isNotAfter(section.getStart()) && this.end.isNotBefore(section.getEnd());
    }
}

