/*
 * Decompiled with CFR 0.152.
 */
package prompto.problem;

import java.util.BitSet;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.parser.ISection;
import prompto.parser.MissingTokenException;
import prompto.parser.UnwantedTokenException;
import prompto.problem.AmbiguousIdentifierError;
import prompto.problem.DuplicateProblem;
import prompto.problem.DuplicatePropertyProblem;
import prompto.problem.IProblem;
import prompto.problem.IProblemListener;
import prompto.problem.IllegalAnnotation;
import prompto.problem.IllegalAssignmentProblem;
import prompto.problem.IllegalComparisonProblem;
import prompto.problem.IllegalOperationProblem;
import prompto.problem.IllegalRemoteCallProblem;
import prompto.problem.IllegalReturnProblem;
import prompto.problem.IllegalValueProblem;
import prompto.problem.InputMismatchProblem;
import prompto.problem.LexerNoViableAltProblem;
import prompto.problem.MissingPropertyProblem;
import prompto.problem.MissingTokenProblem;
import prompto.problem.NoMatchingPrototypeProblem;
import prompto.problem.NoSuperCategoryProblem;
import prompto.problem.NotMutableProblem;
import prompto.problem.NotStorableProblem;
import prompto.problem.ParserNoViableAltProblem;
import prompto.problem.UnknowAnnotationProblem;
import prompto.problem.UnknowAttributeProblem;
import prompto.problem.UnknowPropertyProblem;
import prompto.problem.UnknownCategoryProblem;
import prompto.problem.UnknownIdentifierProblem;
import prompto.problem.UnknownMemberProblem;
import prompto.problem.UnknownMethodProblem;
import prompto.problem.UnwantedTokenProblem;
import prompto.type.IType;

public abstract class ProblemListenerBase
implements ANTLRErrorListener,
IProblemListener {
    Stack<IDeclaration> stack = new Stack();

    @Override
    public void pushDeclaration(IDeclaration declaration) {
        this.stack.push(declaration);
    }

    @Override
    public IDeclaration popDeclaration() {
        return this.stack.pop();
    }

    @Override
    public String getEnclosingDeclaration() {
        if (this.stack.empty()) {
            return "";
        }
        IDeclaration top = this.stack.peek();
        if (top instanceof IMethodDeclaration) {
            CategoryDeclaration parent = ((IMethodDeclaration)top).getMemberOf();
            if (parent == null) {
                return " in method '" + top.getName() + "'";
            }
            return " in method '" + top.getName() + "' of category or widget '" + parent.getName() + "'";
        }
        if (top instanceof CategoryDeclaration) {
            return " in category or widget '" + top.getName() + "'";
        }
        return " in '" + top.getName() + "'";
    }

    abstract void addProblem(IProblem var1);

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int column, String msg, RecognitionException e) {
        String path = recognizer.getInputStream().getSourceName();
        if (e instanceof LexerNoViableAltException) {
            this.addProblem(new LexerNoViableAltProblem(path, line, column, (LexerNoViableAltException)e));
        } else if (e instanceof UnwantedTokenException) {
            this.addProblem(new UnwantedTokenProblem(path, line, column, (UnwantedTokenException)e));
        } else if (e instanceof MissingTokenException) {
            this.addProblem(new MissingTokenProblem(path, line, column, (MissingTokenException)e));
        } else if (e instanceof NoViableAltException) {
            this.addProblem(new ParserNoViableAltProblem(path, line, column, (NoViableAltException)e));
        } else if (e instanceof InputMismatchException) {
            this.addProblem(new InputMismatchProblem(path, line, column, (InputMismatchException)e));
        } else {
            throw e;
        }
    }

    @Override
    public void reportDuplicate(ISection section, String name, ISection existing) {
        this.addProblem(new DuplicateProblem(name, section, existing));
    }

    @Override
    public void reportNotMutable(ISection section, String name) {
        this.addProblem(new NotMutableProblem(name, section));
    }

    @Override
    public void reportNotStorable(ISection section, String name) {
        this.addProblem(new NotStorableProblem(name, section));
    }

    @Override
    public void reportIllegalAssignment(ISection section, IType expected, IType actual) {
        this.addProblem(new IllegalAssignmentProblem(section, expected, actual));
    }

    @Override
    public void reportIllegalAssignment(ISection section, Set<IType> expected, IType actual) {
        this.addProblem(new IllegalAssignmentProblem(section, expected, actual));
    }

    @Override
    public void reportIllegalReturn(ISection section) {
        this.addProblem(new IllegalReturnProblem(section));
    }

    @Override
    public void reportUnknownIdentifier(ISection section, String name) {
        this.addProblem(new UnknownIdentifierProblem(name, section));
    }

    @Override
    public void reportAmbiguousIdentifier(ISection section, String name) {
        this.addProblem(new AmbiguousIdentifierError(name, section));
    }

    @Override
    public void reportUnknownAttribute(ISection section, String name, String hint) {
        this.addProblem(new UnknowAttributeProblem(name, hint, section));
    }

    @Override
    public void reportUnknownProperty(ISection section, String name) {
        this.addProblem(new UnknowPropertyProblem(name, section));
    }

    @Override
    public void reportDuplicateProperty(ISection section, String name) {
        this.addProblem(new DuplicatePropertyProblem(name, section));
    }

    @Override
    public void reportMissingProperty(ISection section, String name) {
        this.addProblem(new MissingPropertyProblem(name, section));
    }

    @Override
    public void reportUnknownAnnotation(ISection section, String name) {
        this.addProblem(new UnknowAnnotationProblem(name, section));
    }

    @Override
    public void reportUnknownMethod(ISection section, String name) {
        this.addProblem(new UnknownMethodProblem(name, section));
    }

    @Override
    public void reportUnknownCategory(ISection section, String name) {
        this.addProblem(new UnknownCategoryProblem(name, section));
    }

    @Override
    public void reportNoMatchingPrototype(ISection section, String proto) {
        this.addProblem(new NoMatchingPrototypeProblem(proto, section));
    }

    @Override
    public void reportIllegalComparison(ISection section, IType type, IType other) {
        this.addProblem(new IllegalComparisonProblem(type, other, section));
    }

    @Override
    public void reportUnknownMember(ISection section, String name) {
        this.addProblem(new UnknownMemberProblem(name, section));
    }

    @Override
    public void reportIllegalOperation(ISection section, String message) {
        this.addProblem(new IllegalOperationProblem(message, section));
    }

    @Override
    public void reportIllegalRemoteCall(ISection section, String message) {
        this.addProblem(new IllegalRemoteCallProblem(message, section));
    }

    @Override
    public void reportIllegalAnnotation(ISection section, String message) {
        this.addProblem(new IllegalAnnotation(message, section));
    }

    @Override
    public void reportIllegalValue(ISection section, String message) {
        this.addProblem(new IllegalValueProblem(message, section));
    }

    @Override
    public void reportNoSuperType(ISection section, IType actual) {
        this.addProblem(new NoSuperCategoryProblem(actual, section));
    }
}

