/*
 * Decompiled with CFR 0.152.
 */
package prompto.processor;

import java.util.Set;
import java.util.stream.Collectors;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.IWidgetDeclaration;
import prompto.error.InternalError;
import prompto.expression.IExpression;
import prompto.grammar.Annotation;
import prompto.grammar.Identifier;
import prompto.literal.BooleanLiteral;
import prompto.literal.DictEntry;
import prompto.literal.DocEntryList;
import prompto.literal.DocumentLiteral;
import prompto.literal.SetLiteral;
import prompto.literal.TextLiteral;
import prompto.literal.TypeLiteral;
import prompto.processor.AnnotationProcessor;
import prompto.property.Property;
import prompto.property.PropertyMap;
import prompto.property.TypeSetValidator;
import prompto.property.TypeValidator;
import prompto.property.ValueSetValidator;
import prompto.runtime.Context;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.PropertiesType;
import prompto.type.TextType;
import prompto.type.TypeType;
import prompto.value.BooleanValue;
import prompto.value.IValue;
import prompto.value.NullValue;
import prompto.value.SetValue;
import prompto.value.TextValue;
import prompto.value.TypeValue;

public class WidgetPropertiesProcessor
extends AnnotationProcessor {
    @Override
    public void processCategory(Annotation annotation, Context context, CategoryDeclaration declaration) {
        if (declaration.isAWidget(context)) {
            this.doProcessCategory(annotation, context, declaration);
        } else {
            context.getProblemListener().reportIllegalAnnotation(annotation, "WidgetProperties is only applicable to widgets");
        }
    }

    private void doProcessCategory(Annotation annotation, Context context, CategoryDeclaration declaration) {
        IWidgetDeclaration widget = declaration.asWidget();
        Object value = annotation.getDefaultArgument();
        PropertyMap properties = this.checkProperties(annotation, context, value);
        if (properties != null) {
            widget.setProperties(properties);
            Annotation widgetField = this.findWidgetPropertiesFieldAnnotation(context, declaration);
            if (widgetField != null) {
                this.overrideWidgetFieldType(context, widgetField, new PropertiesType(properties));
            }
        }
    }

    private void overrideWidgetFieldType(Context context, Annotation widgetField, IType type) {
        Object value = widgetField.getArgument("name");
        if (!(value instanceof TextLiteral)) {
            return;
        }
        String name = ((TextLiteral)value).toString();
        Context.InstanceContext instance = context.getClosestInstanceContext();
        if (instance == null) {
            throw new InternalError("Expected an instance context. Please report this bug.");
        }
        instance.overrideWidgetFieldType(new Identifier(name.substring(1, name.length() - 1)), type, this);
    }

    private Annotation findWidgetPropertiesFieldAnnotation(Context context, CategoryDeclaration declaration) {
        return declaration.getAllAnnotationsAsStream(context).filter(a -> a.isNamed("@WidgetField")).filter(a -> {
            Object value = a.getArgument("isProperties");
            return value instanceof BooleanLiteral && ((BooleanValue)((BooleanLiteral)value).getValue()).getValue();
        }).findFirst().orElse(null);
    }

    private PropertyMap checkProperties(Annotation annotation, Context context, Object value) {
        if (!(value instanceof DocumentLiteral)) {
            context.getProblemListener().reportIllegalAnnotation(annotation, "WidgetProperties expects a Document of types as unique parameter");
            return null;
        }
        return this.loadProperties(annotation, context, ((DocumentLiteral)value).getEntries());
    }

    public PropertyMap loadProperties(Annotation annotation, Context context, DocEntryList entries) {
        PropertyMap props = new PropertyMap();
        for (DictEntry entry : entries) {
            Property prop = this.loadProperty(annotation, context, entry);
            if (prop == null) continue;
            if (props.containsKey(prop.getName())) {
                context.getProblemListener().reportIllegalAnnotation(entry.getKey(), "Duplicate property: " + prop.getName());
                continue;
            }
            props.put(prop.getName(), prop);
        }
        return props;
    }

    private Property loadProperty(Annotation annotation, Context context, DictEntry entry) {
        Property prop = new Property();
        prop.setName(entry.getKey().toString());
        IExpression value = entry.getValue();
        if (value instanceof TypeLiteral) {
            return this.loadProperty(annotation, context, entry, prop, (TypeLiteral)value);
        }
        if (value instanceof SetLiteral) {
            return this.loadProperty(annotation, context, entry, prop, (SetLiteral)value);
        }
        if (value instanceof DocumentLiteral) {
            return this.loadProperty(annotation, context, entry, prop, (DocumentLiteral)value);
        }
        context.getProblemListener().reportIllegalAnnotation(annotation, "WidgetProperties expects a Document of types as unique parameter");
        return null;
    }

    private Property loadProperty(Annotation annotation, Context context, DictEntry entry, Property prop, DocumentLiteral doc) {
        block14: for (DictEntry child : doc.getEntries()) {
            String name = child.getKey().toString();
            IExpression value = child.getValue();
            switch (name) {
                case "required": {
                    if (value instanceof BooleanLiteral) {
                        prop.setRequired(((BooleanLiteral)value).interpret(context) == BooleanValue.TRUE);
                        continue block14;
                    }
                    context.getProblemListener().reportIllegalAnnotation(child.getKey(), "Expected a Boolean value for 'required'.");
                    return null;
                }
                case "help": {
                    if (value instanceof TextLiteral) {
                        prop.setHelp(((TextValue)((TextLiteral)value).getValue()).getStorableData());
                        continue block14;
                    }
                    context.getProblemListener().reportIllegalAnnotation(child.getKey(), "Expected a Text value for 'help'.");
                    return null;
                }
                case "type": {
                    PropertyMap embedded;
                    if (value instanceof TypeLiteral) {
                        IType type2 = ((TypeLiteral)value).getType().resolve(context, t -> context.getProblemListener().reportIllegalAnnotation(annotation, "Unkown type: " + t.getTypeName()));
                        if (type2 == null) {
                            return null;
                        }
                        prop.setValidator(new TypeValidator(type2));
                        continue block14;
                    }
                    if (value instanceof DocumentLiteral && (embedded = this.loadProperties(annotation, context, ((DocumentLiteral)value).getEntries())) != null) {
                        prop.setValidator(new TypeValidator(new PropertiesType(embedded)));
                        continue block14;
                    }
                    context.getProblemListener().reportIllegalAnnotation(child.getKey(), "Expected a Type value for 'type'.");
                    return null;
                }
                case "types": {
                    SetValue values;
                    if (value instanceof SetLiteral && (values = ((SetLiteral)value).interpret(context)).getItemType() instanceof TypeType) {
                        Set<IType> types = values.getItems().stream().filter(v -> v != NullValue.instance()).map(v -> (TypeValue)v).map(TypeValue::getValue).map(type -> type.resolve(context, t -> context.getProblemListener().reportIllegalAnnotation(annotation, "Unkown type: " + t.getTypeName()))).collect(Collectors.toSet());
                        if (types.contains(null)) {
                            return null;
                        }
                        prop.setValidator(new TypeSetValidator(types));
                        prop.setRequired((long)types.size() == values.getLength());
                        continue block14;
                    }
                    context.getProblemListener().reportIllegalAnnotation(child.getKey(), "Expected a Set of types for 'types'.");
                    return null;
                }
                case "values": {
                    SetValue values;
                    if (value instanceof SetLiteral) {
                        values = ((SetLiteral)value).interpret(context);
                        Set<String> texts = values.getItems().stream().filter(v -> v != NullValue.instance()).map(IValue::getStorableData).map(String::valueOf).collect(Collectors.toSet());
                        prop.setValidator(new ValueSetValidator(texts));
                        prop.setRequired((long)texts.size() == values.getLength());
                        continue block14;
                    }
                    context.getProblemListener().reportIllegalAnnotation(child.getKey(), "Expected a Set value for 'values'.");
                    return null;
                }
            }
            context.getProblemListener().reportIllegalAnnotation(child.getKey(), "Unknown property attribute: " + name);
            return null;
        }
        return prop;
    }

    private Property loadProperty(Annotation annotation, Context context, DictEntry entry, Property prop, SetLiteral literal) {
        SetValue values = literal.interpret(context);
        IType itemType = values.getItemType();
        if (itemType instanceof TypeType) {
            Set<IType> types = values.getItems().stream().filter(v -> v != NullValue.instance()).map(v -> (TypeValue)v).map(TypeValue::getValue).map(type -> type.resolve(context, t -> context.getProblemListener().reportIllegalAnnotation(annotation, "Unkown type: " + t.getTypeName()))).collect(Collectors.toSet());
            if (types.contains(null)) {
                return null;
            }
            prop.setValidator(new TypeSetValidator(types));
            prop.setRequired((long)types.size() == values.getLength());
            return prop;
        }
        if (itemType == AnyType.instance() || itemType == TextType.instance()) {
            Set<String> texts = values.getItems().stream().filter(v -> v != NullValue.instance()).map(Object::toString).collect(Collectors.toSet());
            prop.setValidator(new ValueSetValidator(texts));
            prop.setRequired((long)texts.size() == values.getLength());
            return prop;
        }
        context.getProblemListener().reportIllegalAnnotation(entry.getKey(), "Expected a set of Types.");
        return null;
    }

    private Property loadProperty(Annotation annotation, Context context, DictEntry entry, Property prop, TypeLiteral value) {
        IType type = value.getType().resolve(context, t -> context.getProblemListener().reportIllegalAnnotation(annotation, "Unkown type: " + t.getTypeName()));
        if (type == null) {
            return null;
        }
        prop.setValidator(new TypeValidator(type));
        return prop;
    }
}

