/*
 * Decompiled with CFR 0.152.
 */
package prompto.property;

import java.io.IOException;
import java.io.Writer;
import prompto.jsx.JsxProperty;
import prompto.property.AlwaysValidator;
import prompto.property.IPropertyValidator;
import prompto.runtime.Context;
import prompto.utils.StringUtils;

public class Property {
    String name;
    String help;
    IPropertyValidator validator = AlwaysValidator.INSTANCE;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRequired() {
        return this.validator.isRequired();
    }

    public void setRequired(boolean set) {
        this.validator = set ? this.validator.required() : this.validator.optional();
    }

    public void setRequiredForAccessibility(boolean set) {
        this.validator = set ? this.validator.requiredForAccessibility() : this.validator.optionalForAccessibility();
    }

    public IPropertyValidator getValidator() {
        return this.validator;
    }

    public void setValidator(IPropertyValidator validator) {
        this.validator = this.validator.isRequired() ? validator.required() : validator.optional();
    }

    public Property withValidator(IPropertyValidator validator) {
        this.setValidator(validator);
        return this;
    }

    public void validate(Context context, JsxProperty prop) {
        this.validator.validate(context, prop);
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String toString() {
        return "name=" + this.name + ", type=" + this.validator + ", help=" + this.help;
    }

    public void toLiteral(Writer writer) {
        try {
            writer.append(this.nameToKey()).append(": ");
            if (this.help != null || this.validator.isRequired()) {
                writer.append("{ ").append(this.validator.getKeyName()).append(": ").append(this.validator.toLiteral());
                if (this.help != null) {
                    String escaped = this.help.replaceAll("\"", "'");
                    writer.append(", help: \"").append(escaped).append("\"");
                }
                if (this.validator.isRequired()) {
                    writer.append(", required: true");
                }
                writer.append('}');
            } else {
                writer.append(this.getValidator().toLiteral());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String nameToKey() {
        String value = StringUtils.trimEnclosingQuotes(this.name);
        if (value.contains("-")) {
            return '\"' + value + '\"';
        }
        return value;
    }
}

