/*
 * Decompiled with CFR 0.152.
 */
package prompto.property;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import prompto.declaration.IMethodDeclaration;
import prompto.jsx.JsxProperty;
import prompto.parser.ISection;
import prompto.property.IPropertyValidator;
import prompto.runtime.Context;
import prompto.type.AnyType;
import prompto.type.IType;
import prompto.type.MethodType;

public class TypeSetValidator
implements IPropertyValidator {
    Set<IType> types;

    public TypeSetValidator(Set<IType> types) {
        this.types = types;
    }

    @Override
    public IType getType(Context context) {
        return AnyType.instance();
    }

    @Override
    public void validate(Context context, JsxProperty property) {
        IType actual = property.check(context);
        if (!this.types.stream().anyMatch(t -> t.isAssignableFrom(context, actual))) {
            context.getProblemListener().reportIllegalAssignment((ISection)property, this.types, actual);
        }
    }

    @Override
    public String getKeyName() {
        return "types";
    }

    @Override
    public String toLiteral() {
        return "<" + this.types.stream().map(String::valueOf).collect(Collectors.joining(", ")) + ">";
    }

    @Override
    public Set<MethodType> getMethodTypes(Context context) {
        return this.types.stream().filter(type -> type instanceof MethodType).map(type -> (MethodType)type).collect(Collectors.toSet());
    }

    @Override
    public Set<IMethodDeclaration> getMethodDeclarations(Context context) {
        return this.types.stream().filter(type -> type instanceof MethodType).map(type -> this.getMethods(context, (IType)type)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Collection<IMethodDeclaration> getMethods(Context context, IType type) {
        Context.MethodDeclarationMap maps = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, type.getTypeNameId());
        return maps.values();
    }
}

