/*
 * Decompiled with CFR 0.152.
 */
package prompto.property;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import prompto.declaration.IMethodDeclaration;
import prompto.jsx.JsxProperty;
import prompto.parser.ISection;
import prompto.property.IPropertyValidator;
import prompto.runtime.Context;
import prompto.type.IType;
import prompto.type.MethodType;

public class TypeValidator
implements IPropertyValidator {
    IType type;

    public TypeValidator(IType type) {
        this.type = type;
    }

    @Override
    public IType getType(Context context) {
        return this.type;
    }

    @Override
    public void validate(Context context, JsxProperty property) {
        IType actual;
        IType iType = actual = this.type instanceof MethodType ? property.checkProto(context, (MethodType)this.type) : property.check(context);
        if (!this.type.isAssignableFrom(context, actual)) {
            context.getProblemListener().reportIllegalAssignment((ISection)property, this.type, actual);
        }
    }

    @Override
    public String getKeyName() {
        return "type";
    }

    @Override
    public String toLiteral() {
        return this.type.getTypeName();
    }

    @Override
    public Set<MethodType> getMethodTypes(Context context) {
        return this.type instanceof MethodType ? Collections.singleton((MethodType)this.type) : IPropertyValidator.super.getMethodTypes(context);
    }

    @Override
    public Set<IMethodDeclaration> getMethodDeclarations(Context context) {
        Context.MethodDeclarationMap decls;
        if (this.type instanceof MethodType && (decls = context.getRegisteredDeclaration(Context.MethodDeclarationMap.class, this.type.getTypeNameId())) != null) {
            return new HashSet<IMethodDeclaration>(decls.values());
        }
        return IPropertyValidator.super.getMethodDeclarations(context);
    }
}

