/*
 * Decompiled with CFR 0.152.
 */
package prompto.python;

import prompto.python.PythonExpression;
import prompto.utils.CodeWriter;

public class PythonIdentifierExpression
implements PythonExpression {
    PythonIdentifierExpression parent;
    String identifier;

    public static PythonIdentifierExpression parse(String ids) {
        String[] parts = ids.split("\\.");
        PythonIdentifierExpression result = null;
        for (String part : parts) {
            result = new PythonIdentifierExpression(result, part);
        }
        return result;
    }

    public PythonIdentifierExpression(String identifier) {
        this.identifier = identifier;
    }

    public PythonIdentifierExpression(PythonIdentifierExpression parent, String identifier) {
        this.parent = parent;
        this.identifier = identifier;
    }

    public PythonIdentifierExpression getParent() {
        return this.parent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        if (this.parent == null) {
            return this.identifier;
        }
        return this.parent.toString() + "." + this.identifier;
    }

    @Override
    public void toDialect(CodeWriter writer) {
        if (this.parent != null) {
            this.parent.toDialect(writer);
            writer.append('.');
        }
        writer.append(this.identifier);
    }
}

