/*
 * Decompiled with CFR 0.152.
 */
package prompto.remoting;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.security.InvalidParameterException;
import java.util.Map;
import prompto.declaration.AttributeDeclaration;
import prompto.error.PromptoError;
import prompto.expression.ValueExpression;
import prompto.grammar.Argument;
import prompto.grammar.Identifier;
import prompto.param.CategoryParameter;
import prompto.runtime.Context;
import prompto.store.DataStore;
import prompto.type.IType;
import prompto.utils.TypeUtils;
import prompto.value.IValue;

public class RemoteArgument {
    private String name;
    private IType type;
    private IValue value;

    public static RemoteArgument read(Context context, JsonNode jsonParam, Map<String, byte[]> parts) throws Exception {
        if (!jsonParam.isObject()) {
            throw new InvalidParameterException("Expecting a JSON object!");
        }
        RemoteArgument param = new RemoteArgument();
        JsonNode field = jsonParam.get("name");
        if (field == null) {
            throw new InvalidParameterException("Expecting a 'name' field!");
        }
        param.setName(field.asText());
        if ("dbId".equals(param.getName())) {
            param.setType(TypeUtils.typeToIType(DataStore.getInstance().getDbIdClass()));
        } else {
            field = jsonParam.get("type");
            if (field != null) {
                param.setType(IType.fromTypeName(context, field.asText()));
            } else {
                AttributeDeclaration decl = context.findAttribute(param.getName());
                if (decl == null) {
                    throw new InvalidParameterException("Expecting a 'type' field!");
                }
                param.setType(decl.getType());
            }
        }
        field = jsonParam.get("value");
        if (field == null) {
            throw new InvalidParameterException("Expecting a 'value' field!");
        }
        param.setValue(new ValueExpression(param.getType(), param.getType().readJSONValue(context, field, parts)));
        return param;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType type) {
        this.type = type;
    }

    public IValue getValue() {
        return this.value;
    }

    public void setValue(IValue value) {
        this.value = value;
    }

    public Class<?> toJavaType(Context context, ClassLoader classLoader) {
        Type type = this.type.getJavaType(context);
        if (type instanceof Class) {
            return (Class)type;
        }
        try {
            return classLoader.loadClass(type.getTypeName().replace('.', '/'));
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e);
        }
    }

    public Object toJavaValue(Context context) {
        return this.value.convertTo(context, (Type)((Object)Object.class));
    }

    public Argument toAssignment(Context context) {
        CategoryParameter argument = new CategoryParameter(this.type, new Identifier(this.name));
        return new Argument(argument, new ValueExpression(this.type, this.value));
    }

    public void toJson(Context context, JsonGenerator generator) throws IOException, PromptoError {
        generator.writeStartObject();
        generator.writeStringField("name", this.name.toString());
        generator.writeStringField("type", this.type.toString());
        if (this.value == null) {
            generator.writeNullField("value");
        } else {
            generator.writeFieldName("value");
            this.value.toJsonStream(context, generator, null, null, true, null);
        }
        generator.writeEndObject();
    }
}

