/*
 * Decompiled with CFR 0.152.
 */
package prompto.runtime;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.code.BinaryResource;
import prompto.code.ICodeStore;
import prompto.code.Resource;
import prompto.code.TextResource;
import prompto.debug.IDebugEvent;
import prompto.debug.ProcessDebugger;
import prompto.debug.WorkerDebugger;
import prompto.declaration.AttributeDeclaration;
import prompto.declaration.CategoryDeclaration;
import prompto.declaration.ConcreteCategoryDeclaration;
import prompto.declaration.IDeclaration;
import prompto.declaration.IMethodDeclaration;
import prompto.declaration.NativeCategoryDeclaration;
import prompto.declaration.SingletonCategoryDeclaration;
import prompto.declaration.TestMethodDeclaration;
import prompto.error.PromptoError;
import prompto.error.SyntaxError;
import prompto.expression.Symbol;
import prompto.expression.ValueExpression;
import prompto.grammar.Annotation;
import prompto.grammar.INamed;
import prompto.grammar.Identifier;
import prompto.intrinsic.PromptoBinary;
import prompto.intrinsic.PromptoList;
import prompto.parser.Dialect;
import prompto.parser.ILocation;
import prompto.parser.ISection;
import prompto.parser.Section;
import prompto.problem.IProblemListener;
import prompto.problem.ProblemListener;
import prompto.runtime.IContext;
import prompto.runtime.LinkedValue;
import prompto.runtime.Variable;
import prompto.runtime.WidgetField;
import prompto.statement.CommentStatement;
import prompto.statement.IStatement;
import prompto.type.CategoryType;
import prompto.type.DecimalType;
import prompto.type.IType;
import prompto.type.MethodType;
import prompto.type.NativeType;
import prompto.utils.CodeWriter;
import prompto.utils.ObjectUtils;
import prompto.utils.SectionLocator;
import prompto.value.ClosureValue;
import prompto.value.ConcreteInstance;
import prompto.value.DecimalValue;
import prompto.value.DocumentValue;
import prompto.value.IInstance;
import prompto.value.IValue;
import prompto.value.IntegerValue;

public class Context
implements IContext {
    Context globals;
    Context calling;
    Context parent;
    WorkerDebugger debugger;
    IProblemListener problemListener;
    Map<Identifier, IDeclaration> declarations = new HashMap<Identifier, IDeclaration>();
    Map<Identifier, TestMethodDeclaration> tests = new HashMap<Identifier, TestMethodDeclaration>();
    Instances instances = new Instances();
    Map<Identifier, IValue> values = new HashMap<Identifier, IValue>();
    Map<Type, NativeCategoryDeclaration> nativeBindings = new HashMap<Type, NativeCategoryDeclaration>();

    public static Context newGlobalsContext() {
        Context context;
        context.globals = context = new Context();
        context.calling = null;
        context.parent = null;
        context.debugger = null;
        context.problemListener = new ProblemListener();
        return context;
    }

    protected Context() {
    }

    public Context getGlobalsContext() {
        return this.globals;
    }

    public boolean isGlobalsContext() {
        return this == this.globals;
    }

    public void setDebugger(WorkerDebugger debugger) {
        this.debugger = debugger;
    }

    public WorkerDebugger getDebugger() {
        return this.debugger;
    }

    public void setProblemListener(IProblemListener problemListener) {
        this.problemListener = problemListener;
    }

    public IProblemListener getProblemListener() {
        return this.problemListener;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this != this.globals) {
            sb.append("globals:");
            sb.append(this.globals);
        }
        sb.append(",calling:");
        sb.append(this.calling);
        sb.append(",parent:");
        sb.append(this.parent);
        sb.append(",declarations:");
        sb.append(this.declarations);
        sb.append(",instances:");
        sb.append(this.instances);
        sb.append(",values:");
        sb.append(this.values);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Context getCallingContext() {
        return this.calling;
    }

    public InstanceContext getClosestInstanceContext() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getClosestInstanceContext();
    }

    public Context getParentMostContext() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getParentMostContext();
    }

    public Context getParentContext() {
        return this.parent;
    }

    public void setParentContext(Context parent) {
        this.parent = parent;
    }

    public Context newResourceContext() {
        ResourceContext context = new ResourceContext();
        context.globals = this.globals;
        context.calling = this.calling;
        context.parent = this;
        context.debugger = this.debugger;
        context.problemListener = this.problemListener;
        return context;
    }

    public Context newLocalContext() {
        Context context = new Context();
        context.globals = this.globals;
        context.calling = this;
        context.parent = null;
        context.debugger = this.debugger;
        context.problemListener = this.problemListener;
        return context;
    }

    public Context newBuiltInContext(IValue value) {
        return this.initInstanceContext(new BuiltInContext(value), false);
    }

    public Context newBuiltInContext(NativeType type) {
        return this.initInstanceContext(new BuiltInContext(type), false);
    }

    public Context newInstanceContext(IInstance instance, boolean isChild) {
        InstanceContext context = this.initInstanceContext(new InstanceContext(instance), isChild);
        CategoryDeclaration decl = context.getDeclaration();
        if (decl != null) {
            decl.processAnnotations(context, true);
        }
        return context;
    }

    public Context newInstanceContext(CategoryType type, boolean isChild) {
        InstanceContext context = this.initInstanceContext(new InstanceContext(type), isChild);
        CategoryDeclaration decl = context.getDeclaration();
        if (decl != null) {
            decl.processAnnotations(context, true);
        }
        return context;
    }

    public Context newDocumentContext(boolean isChild) {
        return this.initInstanceContext(new DocumentContext(null), isChild);
    }

    public Context newDocumentContext(DocumentValue document, boolean isChild) {
        return this.initInstanceContext(new DocumentContext(document), isChild);
    }

    public Context newClosureContext(MethodType type) {
        return this.initInstanceContext(new ClosureContext(type), true);
    }

    public Context newMemberContext(CategoryType type) {
        return this.newInstanceContext(type, false).newChildContext();
    }

    private <T extends Context> T initInstanceContext(T context, boolean isChild) {
        context.globals = this.globals;
        context.calling = isChild ? this.calling : this;
        context.parent = isChild ? this : null;
        context.debugger = this.debugger;
        context.problemListener = this.problemListener;
        return context;
    }

    public Context newChildContext() {
        Context context = new Context();
        context.globals = this.globals;
        context.calling = this.calling;
        context.parent = this;
        context.debugger = this.debugger;
        context.problemListener = this.problemListener;
        return context;
    }

    public boolean isEmpty() {
        if (this.globals != this) {
            return this.globals.isEmpty();
        }
        return this.declarations.isEmpty() && this.tests.isEmpty() && this.instances.isEmpty() && this.values.isEmpty();
    }

    public void unregister(String path) {
        this.unregisterDeclarations(path);
        this.unregisterValues(path);
        this.unregisterTests(path);
    }

    private void unregisterValues(String path) {
        ArrayList<Identifier> toRemove = new ArrayList<Identifier>();
        for (Identifier id : this.instances.keySet()) {
            if (!path.equals(id.getPath())) continue;
            toRemove.add(id);
        }
        for (Identifier id : toRemove) {
            this.instances.remove(id);
            this.values.remove(id);
        }
    }

    private void unregisterTests(String path) {
        ArrayList<TestMethodDeclaration> toRemove = new ArrayList<TestMethodDeclaration>();
        for (TestMethodDeclaration decl : this.tests.values()) {
            if (!path.equals(decl.getPath())) continue;
            toRemove.add(decl);
        }
        for (TestMethodDeclaration decl : toRemove) {
            this.tests.remove(decl.getId());
        }
    }

    private void unregisterDeclarations(String path) {
        ArrayList<IDeclaration> toRemove = new ArrayList<IDeclaration>();
        for (IDeclaration decl : this.declarations.values()) {
            if (path.equals(decl.getPath())) {
                toRemove.add(decl);
                continue;
            }
            if (!(decl instanceof MethodDeclarationMap)) continue;
            ((MethodDeclarationMap)decl).unregister(path);
        }
        for (IDeclaration decl : toRemove) {
            Class<?> klass;
            this.declarations.remove(decl.getId());
            if (!(decl instanceof NativeCategoryDeclaration) || (klass = ((NativeCategoryDeclaration)decl).getBoundClass(false)) == null) continue;
            this.nativeBindings.remove(klass);
        }
    }

    public AttributeDeclaration findAttribute(String name) {
        return this.getRegisteredDeclaration(AttributeDeclaration.class, new Identifier(name));
    }

    public PromptoList<AttributeDeclaration> getAllAttributes() {
        if (this.globals != this) {
            return this.globals.getAllAttributes();
        }
        PromptoList<AttributeDeclaration> list = new PromptoList<AttributeDeclaration>(false);
        for (IDeclaration decl : this.declarations.values()) {
            if (!(decl instanceof AttributeDeclaration)) continue;
            list.add((AttributeDeclaration)decl);
        }
        return list;
    }

    public INamed getRegistered(Identifier name) {
        INamed actual = this.declarations.get(name);
        if (actual != null) {
            return actual;
        }
        actual = this.instances.get(name);
        if (actual != null) {
            return actual;
        }
        if (this.parent != null) {
            return this.parent.getRegistered(name);
        }
        if (this.globals != this) {
            return this.globals.getRegistered(name);
        }
        return null;
    }

    public <T extends IDeclaration> T getLocalDeclaration(Class<T> klass, Identifier id) {
        IDeclaration actual = this.declarations.get(id);
        if (actual != null) {
            return (T)((IDeclaration)ObjectUtils.downcast(klass, actual));
        }
        if (this.parent != null) {
            return this.parent.getLocalDeclaration(klass, id);
        }
        return null;
    }

    public <T extends IDeclaration> T getRegisteredDeclaration(Class<T> klass, Identifier id) {
        return this.getRegisteredDeclaration(klass, id, true);
    }

    public <T extends IDeclaration> T getRegisteredDeclaration(Class<T> klass, Identifier id, boolean lookInStore) {
        IDeclaration actual = this.declarations.get(id);
        if (actual != null) {
            return (T)((IDeclaration)ObjectUtils.downcast(klass, actual));
        }
        if (this.parent != null) {
            actual = this.parent.getRegisteredDeclaration(klass, id, lookInStore);
        }
        if (actual != null) {
            return (T)((IDeclaration)ObjectUtils.downcast(klass, actual));
        }
        if (this.globals != this) {
            actual = this.globals.getRegisteredDeclaration(klass, id, lookInStore);
        }
        if (actual != null) {
            return (T)((IDeclaration)ObjectUtils.downcast(klass, actual));
        }
        if (lookInStore && this.globals == this) {
            actual = this.fetchAndRegisterDeclaration(id);
        }
        if (actual != null) {
            return (T)((IDeclaration)ObjectUtils.downcast(klass, actual));
        }
        return null;
    }

    public Symbol getRegisteredSymbol(Identifier id, boolean lookInStore) {
        Symbol symbol = this.getRegisteredValue(Symbol.class, id);
        if (symbol != null || !lookInStore) {
            return symbol;
        }
        if (this.globals != this) {
            return this.globals.getRegisteredSymbol(id, lookInStore);
        }
        if (lookInStore) {
            return this.fetchAndRegisterSymbol(id);
        }
        return null;
    }

    private Symbol fetchAndRegisterSymbol(Identifier id) {
        ICodeStore store = ICodeStore.getInstance();
        if (store == null) {
            return null;
        }
        Context context = this;
        synchronized (context) {
            Symbol symbol = this.getRegisteredValue(Symbol.class, id);
            if (symbol != null) {
                return symbol;
            }
            try {
                IDeclaration decl = store.fetchLatestSymbol(id.toString());
                if (decl == null) {
                    return null;
                }
                decl.register(this);
                return this.getRegisteredValue(Symbol.class, id);
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchAndRegisterAllDeclarations() {
        ICodeStore store = ICodeStore.getInstance();
        if (store == null) {
            return;
        }
        Context context = this;
        synchronized (context) {
            Collection<String> names = store.fetchDeclarationNames();
            names.stream().map(Identifier::new).forEach(this::fetchAndRegisterDeclaration);
        }
    }

    private IDeclaration fetchAndRegisterDeclaration(Identifier id) {
        ICodeStore store = ICodeStore.getInstance();
        if (store == null) {
            return null;
        }
        Context context = this;
        synchronized (context) {
            IDeclaration decl = this.declarations.get(id);
            if (decl != null) {
                return decl;
            }
            try {
                Iterable<IDeclaration> decls = store.fetchLatestDeclarations(id.toString());
                if (decls == null) {
                    return null;
                }
                decls.forEach(d -> {
                    if (d instanceof MethodDeclarationMap) {
                        MethodDeclarationMap map = (MethodDeclarationMap)d;
                        for (Map.Entry entry : map.entrySet()) {
                            ((IMethodDeclaration)entry.getValue()).register(this);
                        }
                    } else {
                        d.register(this);
                    }
                });
                return this.declarations.get(id);
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void registerDeclaration(IDeclaration declaration) {
        if (this.checkDuplicateDeclaration(declaration)) {
            this.declarations.put(declaration.getId(), declaration);
        }
    }

    private boolean checkDuplicateDeclaration(IDeclaration declaration) {
        IDeclaration current = this.getRegisteredDeclaration(IDeclaration.class, declaration.getId(), false);
        if (current != null && current != declaration) {
            this.problemListener.reportDuplicate(declaration, declaration.getId().toString(), current.getId());
        }
        return current == null;
    }

    public void registerDeclaration(IMethodDeclaration declaration) {
        MethodDeclarationMap current = this.checkDuplicate(declaration);
        if (current == null) {
            current = new MethodDeclarationMap(declaration.getId());
            this.declarations.put(declaration.getId(), current);
        }
        current.register(declaration, this);
    }

    public void registerDeclarationIfMissing(IMethodDeclaration declaration) {
        MethodDeclarationMap current = this.getRegisteredDeclaration(MethodDeclarationMap.class, declaration.getId());
        if (current == null) {
            current = new MethodDeclarationMap(declaration.getId());
            this.declarations.put(declaration.getId(), current);
        }
        current.registerIfMissing(declaration, this);
    }

    private MethodDeclarationMap checkDuplicate(IMethodDeclaration declaration) {
        INamed current = this.getRegistered(declaration.getId());
        if (current != null && !(current instanceof MethodDeclarationMap)) {
            this.problemListener.reportDuplicate(declaration, declaration.getId().toString(), (ISection)((Object)current));
        }
        return (MethodDeclarationMap)current;
    }

    public void registerDeclaration(TestMethodDeclaration declaration) {
        if (this.checkDuplicate(declaration)) {
            this.tests.put(declaration.getId(), declaration);
        }
    }

    private boolean checkDuplicate(TestMethodDeclaration declaration) {
        TestMethodDeclaration current = this.tests.get(declaration.getId());
        if (current != null) {
            this.problemListener.reportDuplicate(declaration, declaration.getId().toString(), current);
        }
        return current == null;
    }

    public <T extends INamed> T getRegisteredValue(Class<T> klass, Identifier name) {
        Context context = this.contextForValue(name);
        if (context == null) {
            return null;
        }
        return context.readRegisteredValue(klass, name);
    }

    protected <T extends INamed> T readRegisteredValue(Class<T> klass, Identifier name) {
        INamed actual = this.instances.get(name);
        if (actual != null) {
            return (T)((INamed)ObjectUtils.downcast(klass, actual));
        }
        return null;
    }

    public void registerValue(INamed value) {
        this.registerValue(value, true);
    }

    public void registerValue(INamed value, boolean checkDuplicate) {
        if (checkDuplicate && this.instances.get(value.getId()) != null) {
            throw new SyntaxError("Duplicate name: \"" + value.getId() + "\"");
        }
        this.instances.put(value.getId(), value);
    }

    public Stream<INamed> getInstancesStream(boolean includeParent) {
        if (this.parent == null || !includeParent) {
            return this.instances.values().stream();
        }
        return Stream.concat(this.parent.getInstancesStream(true), this.instances.values().stream());
    }

    public INamed getInstance(String name, boolean includeParent) {
        return this.getInstance(new Identifier(name), includeParent);
    }

    public INamed getInstance(Identifier id, boolean includeParent) {
        INamed named = this.parent == null || !includeParent ? null : this.parent.getInstance(id, true);
        return named != null ? named : this.instances.get(id);
    }

    public boolean hasValue(Identifier id) {
        return this.contextForValue(id) != null;
    }

    public IValue getValue(Identifier id) throws PromptoError {
        return this.getValue(id, () -> null);
    }

    public IValue getValue(Identifier id, Supplier<IValue> supplier) throws PromptoError {
        Context context = this.contextForValue(id);
        if (context == null) {
            context = this.globals;
        }
        return context.readValue(id, supplier);
    }

    protected IValue readValue(Identifier id, Supplier<IValue> supplier) throws PromptoError {
        IValue value = this.values.get(id);
        if (value == null && (value = supplier.get()) != null) {
            this.values.put(id, value);
        }
        if (value == null) {
            throw new SyntaxError(id + " has no value");
        }
        if (value instanceof LinkedValue) {
            return ((LinkedValue)value).getContext().getValue(id);
        }
        return value;
    }

    public void setValue(Identifier name, IValue value) throws PromptoError {
        Context context = this.contextForValue(name);
        if (context == null) {
            throw new SyntaxError(name + " is not defined");
        }
        context.writeValue(name, value);
    }

    protected void writeValue(Identifier name, IValue value) throws PromptoError {
        value = this.autocast(name, value);
        IValue current = this.values.get(name);
        if (current instanceof LinkedValue) {
            ((LinkedValue)current).getContext().setValue(name, value);
        } else {
            this.values.put(name, value);
        }
    }

    private IValue autocast(Identifier name, IValue value) {
        if (value != null) {
            INamed actual;
            if (value instanceof ValueExpression) {
                value = ((ValueExpression)value).getValue();
            }
            if (value instanceof IntegerValue && (actual = this.instances.get(name)).getType(this) == DecimalType.instance()) {
                value = new DecimalValue(((IntegerValue)value).doubleValue());
            }
        }
        return value;
    }

    public Context contextForValue(Identifier name) {
        INamed actual = this.instances.get(name);
        if (actual != null) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.contextForValue(name);
        }
        if (this.globals != this) {
            return this.globals.contextForValue(name);
        }
        return null;
    }

    public void enterTest(TestMethodDeclaration test) throws PromptoError {
        if (this.debugger != null) {
            this.debugger.enterTest(this, test);
        }
    }

    public void enterMethod(IMethodDeclaration method) throws PromptoError {
        if (this.debugger != null) {
            this.debugger.enterMethod(this, method);
        }
    }

    public void leaveSection(ISection section) throws PromptoError {
        if (this.debugger != null) {
            this.debugger.leaveSection(this, section);
        }
    }

    public void enterStatement(IStatement statement) throws PromptoError {
        if (this.debugger != null) {
            this.debugger.enterStatement(this, statement);
        }
    }

    public void leaveStatement(IStatement statement) throws PromptoError {
        if (this.debugger != null) {
            this.debugger.leaveStatement(this, statement);
        }
    }

    public void notifyCompleted() {
        if (this.debugger != null) {
            IDebugEvent.Completed completed = new IDebugEvent.Completed(ProcessDebugger.DebuggedWorker.wrap(Thread.currentThread()));
            this.debugger.notifyCompleted(completed);
        }
    }

    public ConcreteInstance loadSingleton(CategoryType type) throws PromptoError {
        if (this == this.globals) {
            IValue value = this.values.get(type.getTypeNameId());
            if (value == null) {
                IDeclaration decl = this.declarations.get(type.getTypeNameId());
                if (decl == null) {
                    decl = this.fetchAndRegisterDeclaration(type.getTypeNameId());
                }
                if (!(decl instanceof SingletonCategoryDeclaration)) {
                    throw new InternalError("No such singleton:" + type.getTypeName());
                }
                value = new ConcreteInstance(this, (ConcreteCategoryDeclaration)decl);
                ((IInstance)value).setMutable(true);
                this.values.put(type.getTypeNameId(), value);
            }
            if (value instanceof ConcreteInstance) {
                return (ConcreteInstance)value;
            }
            throw new InternalError("Not a concrete instance:" + value.getClass().getSimpleName());
        }
        return this.globals.loadSingleton(type);
    }

    public boolean hasTests() {
        return this.tests.size() > 0;
    }

    public Collection<TestMethodDeclaration> getTests() {
        if (this.globals != this) {
            return this.globals.getTests();
        }
        return this.tests.values();
    }

    public TestMethodDeclaration getTest(Identifier name, boolean lookInStore) {
        if (this.globals != this) {
            return this.globals.getTest(name, lookInStore);
        }
        IDeclaration test = this.tests.get(name);
        if (test == null && lookInStore) {
            test = this.fetchAndRegisterTest(name);
        }
        if (test instanceof TestMethodDeclaration) {
            return (TestMethodDeclaration)test;
        }
        return null;
    }

    private IDeclaration fetchAndRegisterTest(Identifier name) {
        ICodeStore store = ICodeStore.getInstance();
        if (store == null) {
            return null;
        }
        Context context = this;
        synchronized (context) {
            IDeclaration decl = this.tests.get(name);
            if (decl != null) {
                return decl;
            }
            try {
                Iterable<IDeclaration> decls = store.fetchLatestDeclarations(name.toString());
                if (decls == null) {
                    return null;
                }
                decls.forEach(d -> {
                    if (d instanceof MethodDeclarationMap) {
                        MethodDeclarationMap map = (MethodDeclarationMap)d;
                        for (Map.Entry entry : map.entrySet()) {
                            ((IMethodDeclaration)entry.getValue()).register(this);
                        }
                    } else {
                        d.register(this);
                    }
                });
                return this.tests.get(name);
            }
            catch (PromptoError e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ISection locateSection(ISection section) {
        if (this.globals != this) {
            return this.globals.locateSection(section);
        }
        String path = section.getPath();
        if (path.startsWith("store:/")) {
            return this.locateStoreSection(section);
        }
        return this.locateFileSection(section, this.declarations.values());
    }

    ISection locateStoreSection(ISection section) {
        IDeclaration declaration = this.locateStoreDeclarationAtPath(section.getPath());
        if (declaration == null) {
            return null;
        }
        Section converted = new Section(section);
        converted.setPath(declaration.getPath());
        return this.locateFileSection(converted, Collections.singletonList(declaration));
    }

    private IDeclaration locateStoreDeclarationAtPath(String path) {
        path = path.substring("store:/".length());
        int idx = path.indexOf("/");
        String type = path.substring(0, idx);
        String name = path.substring(idx + 1);
        switch (type) {
            case "test": {
                return this.getTest(new Identifier(name), true);
            }
            case "method": {
                idx = name.indexOf("/");
                String proto = name.substring(idx + 1);
                name = name.substring(0, idx);
                MethodDeclarationMap methods = this.getRegisteredDeclaration(MethodDeclarationMap.class, new Identifier(name), true);
                if (methods == null) {
                    return null;
                }
                return (IDeclaration)methods.get(proto);
            }
        }
        return this.getRegisteredDeclaration(IDeclaration.class, new Identifier(name), true);
    }

    ISection locateFileSection(ISection section, Collection<IDeclaration> declarations) {
        ISection result = SectionLocator.locateSection(declarations, section);
        if (result != null) {
            return result;
        }
        ICodeStore store = ICodeStore.getInstance();
        if (store != null) {
            return store.findSection(section);
        }
        return null;
    }

    public void registerNativeBinding(Type type, NativeCategoryDeclaration declaration) {
        if (this == this.globals) {
            this.nativeBindings.put(type, declaration);
        } else {
            this.globals.registerNativeBinding(type, declaration);
        }
    }

    public NativeCategoryDeclaration getNativeBinding(Type type) {
        if (this == this.globals) {
            return this.nativeBindings.get(type);
        }
        return this.globals.getNativeBinding(type);
    }

    public String fetchTextResource(String path) {
        Resource resource = ICodeStore.getInstance().fetchLatestResource(path);
        if (resource == null) {
            return null;
        }
        if (resource instanceof TextResource) {
            return ((TextResource)resource).getBody();
        }
        return "Not a Text resource: " + path;
    }

    public PromptoBinary fetchBinaryResource(String path) {
        Resource resource = ICodeStore.getInstance().fetchLatestResource(path);
        if (resource == null) {
            return null;
        }
        if (resource instanceof BinaryResource) {
            return ((BinaryResource)resource).getData();
        }
        return null;
    }

    public static class ClosureContext
    extends InstanceContext {
        public ClosureContext(MethodType type) {
            super(type);
        }

        @Override
        public Context contextForValue(Identifier name) {
            return this.superContextForValue(name);
        }

        @Override
        public InstanceContext getClosestInstanceContext() {
            return this.parent.getClosestInstanceContext();
        }
    }

    public static class InstanceContext
    extends Context {
        CategoryDeclaration declaration;
        IInstance instance;
        IType type;
        Map<Identifier, WidgetField> widgetFields;

        InstanceContext(IInstance instance) {
            this(instance.getType());
            this.instance = instance;
        }

        InstanceContext(IType type) {
            this.type = type;
        }

        @Override
        public InstanceContext getClosestInstanceContext() {
            return this;
        }

        public IInstance getInstance() {
            return this.instance;
        }

        public IType getInstanceType() {
            return this.type;
        }

        @Override
        public INamed getRegistered(Identifier id) {
            WidgetField field;
            if (this.widgetFields != null && (field = this.widgetFields.get(id)) != null) {
                return field;
            }
            INamed actual = super.getRegistered(id);
            if (actual != null) {
                return actual;
            }
            CategoryDeclaration decl = this.getDeclaration();
            MethodDeclarationMap methods = decl.getMemberMethods(this, id);
            if (methods != null && !methods.isEmpty()) {
                return methods;
            }
            if (decl.hasAttribute(this, id)) {
                return this.getRegisteredDeclaration(AttributeDeclaration.class, id);
            }
            return null;
        }

        @Override
        public <T extends IDeclaration> T getRegisteredDeclaration(Class<T> klass, Identifier id, boolean lookInStore) {
            MethodDeclarationMap methods;
            CategoryDeclaration decl;
            if (klass == MethodDeclarationMap.class && (decl = this.getDeclaration()) != null && (methods = decl.getMemberMethods(this, id)) != null && !methods.isEmpty()) {
                return (T)methods;
            }
            return super.getRegisteredDeclaration(klass, id, lookInStore);
        }

        @Override
        protected <T extends INamed> T readRegisteredValue(Class<T> klass, Identifier name) {
            AttributeDeclaration attr;
            INamed actual = this.instances.get(name);
            if (actual == null && (attr = this.getRegisteredDeclaration(AttributeDeclaration.class, name)) != null) {
                IType type = attr.getType();
                actual = new Variable(name, type);
                this.instances.put(name, actual);
            }
            return (T)((INamed)ObjectUtils.downcast(klass, actual));
        }

        @Override
        public Context contextForValue(Identifier id) {
            if ("this".equals(id.toString())) {
                return this;
            }
            if (this.widgetFields != null && this.widgetFields.containsKey(id)) {
                return this;
            }
            Context context = super.contextForValue(id);
            if (context != null) {
                return context;
            }
            CategoryDeclaration decl = this.getDeclaration();
            if (decl.hasAttribute(this, id) || decl.hasMethod(this, id)) {
                return this;
            }
            return null;
        }

        Context superContextForValue(Identifier name) {
            return super.contextForValue(name);
        }

        private CategoryDeclaration getDeclaration() {
            if (this.declaration == null) {
                this.declaration = this.instance != null ? this.instance.getDeclaration() : (CategoryDeclaration)this.getRegisteredDeclaration(ConcreteCategoryDeclaration.class, this.type.getTypeNameId());
            }
            return this.declaration;
        }

        @Override
        protected IValue readValue(Identifier name, Supplier<IValue> supplier) throws PromptoError {
            if ("this".equals(name.toString())) {
                return this.instance;
            }
            CategoryDeclaration decl = this.getDeclaration();
            if (decl.hasAttribute(this, name)) {
                IValue value = this.instance.getMember(this.calling, name, false);
                return value != null ? value : supplier.get();
            }
            if (decl.hasMethod(this, name)) {
                IMethodDeclaration method = decl.getMemberMethods(this, name).getFirst();
                MethodType type = new MethodType(method);
                return new ClosureValue(this, type);
            }
            return supplier.get();
        }

        @Override
        protected void writeValue(Identifier name, IValue value) throws PromptoError {
            this.instance.setMember(this.calling, name, value);
        }

        @Override
        public Stream<INamed> getInstancesStream(boolean includeParent) {
            return Stream.concat(Stream.of(new Variable(new Identifier("this"), this.instance.getType())), super.getInstancesStream(includeParent));
        }

        @Override
        public INamed getInstance(Identifier name, boolean includeParent) {
            if ("this".equals(name.toString())) {
                return new Variable(new Identifier("this"), this.instance.getType());
            }
            return super.getInstance(name, includeParent);
        }

        public void registerWidgetField(Identifier identifier, IType type, Object createdBy) {
            WidgetField widgetField;
            if (this.widgetFields == null) {
                this.widgetFields = new HashMap<Identifier, WidgetField>();
            }
            if ((widgetField = this.widgetFields.get(identifier)) != null) {
                if (widgetField.createdBy == createdBy) {
                    return;
                }
                Identifier existing = this.widgetFields.keySet().stream().filter(id -> id.equals(identifier)).findFirst().orElse(null);
                this.getProblemListener().reportDuplicate(identifier, identifier.toString(), existing);
            } else {
                this.widgetFields.put(identifier, new WidgetField(identifier, type, createdBy));
            }
        }

        public void overrideWidgetFieldType(Identifier identifier, IType type, Object updatedBy) {
            WidgetField widgetField;
            WidgetField widgetField2 = widgetField = this.widgetFields == null ? null : this.widgetFields.get(identifier);
            if (widgetField == null) {
                this.getProblemListener().reportUnknownIdentifier(identifier, identifier.toString());
            } else {
                widgetField.type = type;
                widgetField.updatedBy = updatedBy;
            }
        }
    }

    public static class BuiltInContext
    extends Context {
        IValue value;
        NativeType type;

        public BuiltInContext(IValue value) {
            this.value = value;
            this.type = (NativeType)value.getType();
        }

        public BuiltInContext(NativeType type) {
            this.type = type;
        }

        public IValue getValue() {
            return this.value;
        }
    }

    public static class DocumentContext
    extends Context {
        DocumentValue document;

        DocumentContext(DocumentValue document) {
            this.document = document;
        }

        public DocumentValue getDocument() {
            return this.document;
        }

        @Override
        public Context contextForValue(Identifier name) {
            Context context = super.contextForValue(name);
            if (context != null) {
                return context;
            }
            return this;
        }

        @Override
        protected IValue readValue(Identifier name, Supplier<IValue> supplier) throws PromptoError {
            return this.document.getMember(this.calling, name, false);
        }

        @Override
        protected void writeValue(Identifier name, IValue value) throws PromptoError {
            this.document.setMember(this.calling, name, value);
        }
    }

    public static class ResourceContext
    extends Context {
        ResourceContext() {
        }
    }

    public static class MethodDeclarationMap
    extends HashMap<String, IMethodDeclaration>
    implements IDeclaration {
        private static final long serialVersionUID = 1L;
        Identifier id;
        ICodeStore origin;

        public MethodDeclarationMap(Identifier id) {
            this.id = id;
        }

        @Override
        public Collection<CommentStatement> getComments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setComments(Collection<CommentStatement> stmts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Annotation> getLocalAnnotations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Annotation> getAllAnnotations(Context context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<Annotation> getAllAnnotationsAsStream(Context context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAnnotations(Collection<Annotation> annotations) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addAnnotation(Annotation annotation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAnnotation(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasLocalAnnotation(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasInheritedAnnotation(Context context, String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IDeclaration.DeclarationType getDeclarationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICodeStore getOrigin() {
            return this.origin;
        }

        @Override
        public void setOrigin(ICodeStore origin) {
            this.origin = origin;
        }

        public void unregister(String path) {
            ArrayList<IMethodDeclaration> toRemove = new ArrayList<IMethodDeclaration>();
            for (IMethodDeclaration decl : this.values()) {
                if (!path.equals(decl.getPath())) continue;
                toRemove.add(decl);
            }
            for (IMethodDeclaration decl : toRemove) {
                this.remove(decl.getProto());
            }
        }

        @Override
        public void toDialect(CodeWriter writer) {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public Identifier getId() {
            return this.id;
        }

        @Override
        public IType check(Context context) {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public void register(Context context) {
            throw new RuntimeException("Should never get there!");
        }

        public void register(IMethodDeclaration declaration, Context context) {
            String proto = declaration.getProto();
            if (this.containsKey(proto)) {
                context.getProblemListener().reportDuplicate(declaration, declaration.getId().toString(), (ISection)this.get(proto));
            } else {
                this.put(proto, declaration);
            }
        }

        public void registerIfMissing(IMethodDeclaration declaration, Context context) {
            String proto = declaration.getProto();
            if (!this.containsKey(proto)) {
                this.put(proto, declaration);
            }
        }

        @Override
        public IType getType(Context context) {
            throw new SyntaxError("Should never get there!");
        }

        @Override
        public int computeStartLine() {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public String getPath() {
            return "__INTERNAL__";
        }

        @Override
        public ILocation getStart() {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public ILocation getEnd() {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public Dialect getDialect() {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public void setAsBreakpoint(boolean set) {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public boolean isBreakpoint() {
            throw new RuntimeException("Should never get there!");
        }

        @Override
        public ISection locateSection(ISection section) {
            return this.values().stream().map(m -> m.locateSection(section)).filter(Objects::nonNull).findFirst().orElse(null);
        }

        @Override
        public boolean isOrContains(ISection section) {
            throw new RuntimeException("Should never get there!");
        }

        public Collection<IMethodDeclaration> globalConcreteMethods() {
            return this.values().stream().filter(m -> !m.isAbstract()).filter(m -> m.getMemberOf() == null).collect(Collectors.toList());
        }

        public IMethodDeclaration getFirst() {
            return (IMethodDeclaration)this.values().iterator().next();
        }
    }

    static class Instances {
        Map<Identifier, INamed> map = new HashMap<Identifier, INamed>();
        List<INamed> list = new ArrayList<INamed>();

        Instances() {
        }

        public String toString() {
            return this.list.toString();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set<Identifier> keySet() {
            return this.map.keySet();
        }

        public void remove(Identifier id) {
            INamed named = this.map.remove(id);
            this.list.remove(named);
        }

        public INamed get(Identifier name) {
            return this.map.get(name);
        }

        public void put(Identifier id, INamed value) {
            INamed previous = this.map.put(id, value);
            if (previous != null) {
                this.list.remove(previous);
            }
            this.list.add(value);
        }

        public Collection<INamed> values() {
            return this.list;
        }
    }
}

